<?php

//Access the WordPress Pages via an Array
$list_pages            = array();
$list_pages_by_id      = array();
$of_pages_obj          = get_pages('sort_column=post_parent,menu_order');
$list_pages['0']       = 'Select a page:';
$list_pages_by_id['0'] = 'Select a page:';
foreach ($of_pages_obj as $of_page) {
    $list_pages[$of_page->post_name] = $of_page->post_title;
    $list_pages_by_id[$of_page->ID] = $of_page->post_title;
}

function flatsome_customizer_blocks() {
  $blocks = array( false => '-- None --' );
  $items  = flatsome_get_post_type_items( 'blocks' );

  if ( ! empty( $items ) ) {
    foreach ( $items as $item ) {
      $blocks[ $item->post_name ] = $item->post_title;
    }
  }

  return $blocks;
}

// Set default transport
$transport = 'postMessage';
if ( ! isset( $wp_customize->selective_refresh ) ) {
  $transport = 'refresh';
}

function flatsome_customizer_transport() {
  global $wp_customize;
  return ! isset( $wp_customize->selective_refresh )
    ? 'refresh'
    : 'postMessage';
}

$image_url = get_template_directory_uri().'/inc/admin/customizer/img/';

function flatsome_customizer_images_uri() {
  return get_template_directory_uri() . '/inc/admin/customizer/img';
}


function flatsome_customizer_nav_elements() {
	return apply_filters( 'flatsome_header_element', array(
		'cart'          => __( 'Cart', 'flatsome' ),
		'account'       => __( 'Account', 'flatsome' ),
		'menu-icon'     => __( '☰ Nav Icon', 'flatsome' ),
		'nav'           => __( 'Main Menu', 'flatsome' ),
		'nav-secondary' => __( 'Secondary Menu', 'flatsome' ),
		'nav-top'       => __( 'Top Bar Menu', 'flatsome' ),
		'nav-vertical'  => __( '☰ Vertical Menu', 'flatsome' ),
		'search'        => __( 'Search Icon', 'flatsome' ),
		'search-form'   => __( 'Search Form', 'flatsome' ),
		'social'        => __( 'Social Icons', 'flatsome' ),
		'contact'       => __( 'Contact', 'flatsome' ),
		'button-1'      => __( 'Button 1', 'flatsome' ),
		'button-2'      => __( 'Button 2', 'flatsome' ),
		'checkout'      => __( 'Checkout Button', 'flatsome' ),
		'newsletter'    => __( 'Newsletter', 'flatsome' ),
		'languages'     => __( 'Languages', 'flatsome' ),
		'divider'       => __( '|', 'flatsome' ),
		'divider_2'     => __( '|', 'flatsome' ),
		'divider_4'     => __( '|', 'flatsome' ),
		'divider_3'     => __( '|', 'flatsome' ),
		'divider_5'     => __( '|', 'flatsome' ),
		'block-1'       => __( 'Block 1', 'flatsome' ),
		'block-2'       => __( 'Block 2', 'flatsome' ),
		'block-3'       => __( 'Block 3', 'flatsome' ),
		'block-4'       => __( 'Block 4', 'flatsome' ),
		'html'          => __( 'HTML 1', 'flatsome' ),
		'html-2'        => __( 'HTML 2', 'flatsome' ),
		'html-3'        => __( 'HTML 3', 'flatsome' ),
		'html-4'        => __( 'HTML 4', 'flatsome' ),
		'html-5'        => __( 'HTML 5', 'flatsome' ),
	) );
}

// Add Hooked Header Elements
$nav_elements = flatsome_customizer_nav_elements();

$visibility= array(
  '' => __( 'Show for All', 'flatsome' ),
  'hide-for-small' => __( 'Hide For Mobile', 'flatsome' ),
  'hide-for-medium' => __( 'Hide For Tablet', 'flatsome' ),
  'show-for-small' => __( 'Show For Mobile', 'flatsome' ),
  'show-for-medium' => __( 'Show For Tablet', 'flatsome' ),
  'show-for-large' => __( 'Show For Desktop', 'flatsome' ),
);

$nav_styles_img = array(
  '' => $image_url . 'nav-default.svg',
  'divided' => $image_url . 'nav-divided.svg',
  'line' => $image_url . 'nav-line.svg',
  'line-grow' => $image_url . 'nav-line-grow.svg',
  'line-bottom' => $image_url . 'nav-line-bottom.svg',
  'box' => $image_url . 'nav-box.svg',
  'outline' => $image_url . 'nav-outline.svg',
  'pills' => $image_url . 'nav-pills.svg',
  'tabs' => $image_url . 'nav-tabs.svg'
);

$smart_links = __( '', 'flatsome' );

$sizes = array(
    'xxlarge' => __( 'XX Large', 'flatsome' ),
    'xlarge' => __( 'X Large', 'flatsome' ),
    'larger' => __( 'Larger', 'flatsome' ),
    'large' => __( 'Large', 'flatsome' ),
    'medium' => __( 'Medium', 'flatsome' ),
    'small' => __( 'Small', 'flatsome' ),
    'smaller' => __( 'Smaller', 'flatsome' ),
    'xsmall' => __( 'X Small', 'flatsome' ),
);

$button_styles = array(
	''          => __( 'Default', 'flatsome' ),
	'outline'   => __( 'Outline', 'flatsome' ),
	'underline' => __( 'Underline', 'flatsome' ),
	'shade'     => __( 'Shade', 'flatsome' ),
	'bevel'     => __( 'Bevel', 'flatsome' ),
	'gloss'     => __( 'Gloss', 'flatsome' ),
	'link'      => __( 'Link', 'flatsome' ),
);

$nav_sizes = array(
  'xsmall' => __( 'XS', 'flatsome' ),
  'small' => __( 'S', 'flatsome' ),
  '' => __( 'Default', 'flatsome' ),
  'medium' => __( 'M', 'flatsome' ),
  'large' => __( 'L', 'flatsome' ),
  'xlarge' => __( 'XL', 'flatsome' ),
);

$nav_spacing = array(
  'xsmall' => __( 'XS', 'flatsome' ),
  'small' => __( 'S', 'flatsome' ),
  '' => __( 'Default', 'flatsome' ),
  'medium' => __( 'M', 'flatsome' ),
  'large' => __( 'L', 'flatsome' ),
  'xlarge' => __( 'XL', 'flatsome' ),
);


$bg_repeat = array(
  "repeat" => "Tiled",
  "repeat-x" => "Repeat X",
  "repeat-y" => "Repeat Y",
  "no-repeat" => "No Repeat"
);
