/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-12-11 13:18:04 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=439 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=8126 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1298 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `progress` float NOT NULL DEFAULT 0,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `owner` varchar(60) NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`),
  KEY `value_2` (`value_2`),
  KEY `value_3` (`value_3`),
  KEY `value_4` (`value_4`),
  KEY `value_5` (`value_5`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=12148 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6528 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_social_users` (
  `social_users_id` int(11) NOT NULL AUTO_INCREMENT,
  `ID` int(11) NOT NULL,
  `type` varchar(20) NOT NULL,
  `identifier` varchar(100) NOT NULL,
  `register_date` datetime DEFAULT NULL,
  `login_date` datetime DEFAULT NULL,
  `link_date` datetime DEFAULT NULL,
  PRIMARY KEY (`social_users_id`),
  KEY `ID` (`ID`,`type`),
  KEY `identifier` (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=186 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=186 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6917 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `text2` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_yith_wcwl` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `prod_id` bigint(20) NOT NULL,
  `quantity` int(11) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `wishlist_id` bigint(20) DEFAULT NULL,
  `position` int(11) DEFAULT 0,
  `original_price` decimal(9,3) DEFAULT NULL,
  `original_currency` char(3) DEFAULT NULL,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `prod_id` (`prod_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `wp_yith_wcwl_lists` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `wishlist_slug` varchar(200) NOT NULL,
  `wishlist_name` text DEFAULT NULL,
  `wishlist_token` varchar(64) NOT NULL,
  `wishlist_privacy` tinyint(1) NOT NULL DEFAULT 0,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `expiration` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `wishlist_token` (`wishlist_token`),
  KEY `wishlist_slug` (`wishlist_slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("1","flatsome","$P$Bh7in/7uNtYQvkwopc353dPi5ExtDp1","flatsome","test@samandon.com","https://theme-samandon.ir/flatsome","2023-09-23 14:20:59","","0","مدیر سایت"),
("2","Mortezah","$P$BFFim8Y1HjJ2bIEKIu/PXM138dWaEC.","mortezah","mortezah@samandon.com","","2023-10-08 05:42:18","1696743739:$P$BIqkkK9RWJ/cnpHpBZlrRQXFhPdyo0/","0","مدیر محصول");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("1","1","nickname","مدیر سایت"),
("2","1","first_name","کاربر"),
("3","1","last_name","سمندون"),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wp_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("16","1","session_tokens","a:3:{s:64:\"2e51c369707bde44a3134ad7ff688597655e47b2978384d9ef43a8f100fa4a67\";a:4:{s:10:\"expiration\";i:1702546117;s:2:\"ip\";s:12:\"2.188.72.163\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36\";s:5:\"login\";i:1701336517;}s:64:\"68406740809abf78b7adf96d3ff409be5669f90c4693db1ae31ea2ad30883b9b\";a:4:{s:10:\"expiration\";i:1702562817;s:2:\"ip\";s:12:\"2.188.72.163\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36\";s:5:\"login\";i:1701353217;}s:64:\"c485b76e15f698e0463043738a41ef8c4a911ee2ecef3aeb7227af7bb106c853\";a:4:{s:10:\"expiration\";i:1703296063;s:2:\"ip\";s:15:\"194.225.213.181\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36\";s:5:\"login\";i:1702086463;}}"),
("17","1","wp_dashboard_quick_press_last_post_id","877"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:10:\"2.188.72.0\";}"),
("19","1","_woocommerce_tracks_anon_id","woo:qTDdWbN2hh+LPgIfSV5fpm5j"),
("20","1","wc_last_active","1702252800"),
("21","1","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("22","1","last_update","1697836939"),
("23","1","wp_persisted_preferences","a:2:{s:14:\"core/edit-post\";a:3:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;s:10:\"openPanels\";a:2:{i:0;s:11:\"post-status\";i:1;s:14:\"featured-image\";}}s:9:\"_modified\";s:24:\"2023-09-24T15:28:35.573Z\";}"),
("24","1","closedpostboxes_page","a:0:{}"),
("25","1","metaboxhidden_page","a:0:{}"),
("26","1","wp_user-settings","libraryContent=browse&posts_list_mode=list&editor=tinymce&align=center&post_dfw=off&hidetb=1"),
("27","1","wp_user-settings-time","1698788981"),
("30","2","nickname","Mortezah"),
("31","2","first_name","مدیر"),
("32","2","last_name","محصول"),
("33","2","description",""),
("34","2","rich_editing","true"),
("35","2","syntax_highlighting","true"),
("36","2","comment_shortcuts","false"),
("37","2","admin_color","fresh"),
("38","2","use_ssl","0"),
("39","2","show_admin_bar_front","true"),
("40","2","locale",""),
("41","2","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("42","2","wp_user_level","10"),
("43","2","dismissed_wp_pointers",""),
("44","2","last_update","1696743739"),
("45","2","session_tokens","a:1:{s:64:\"1f22a1139e20af725b206640e739f19aea408d4e81f318381bf7c712f20a9785\";a:4:{s:10:\"expiration\";i:1697285242;s:2:\"ip\";s:12:\"51.77.192.88\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0\";s:5:\"login\";i:1697112442;}}"),
("46","2","wc_last_active","1697068800"),
("48","2","_woocommerce_tracks_anon_id","woo:nUFDarxp6q6QrbR703JR0veZ"),
("49","2","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("50","2","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("51","2","wp_user-settings","libraryContent=browse"),
("52","2","wp_user-settings-time","1697122072"),
("54","1","billing_first_name","کاربر"),
("55","1","billing_last_name","سمندون"),
("56","1","billing_company",""),
("57","1","billing_address_1","تهران"),
("58","1","billing_address_2",""),
("59","1","billing_city","تهران"),
("60","1","billing_postcode","12345678"),
("61","1","billing_country","IR"),
("62","1","billing_state","THR"),
("63","1","billing_phone","09195571942"),
("64","1","billing_email","test@samandon.com"),
("65","1","shipping_first_name","کاربر"),
("66","1","shipping_last_name","سمندون"),
("67","1","shipping_company",""),
("68","1","shipping_address_1","تهران"),
("69","1","shipping_address_2",""),
("70","1","shipping_city","تهران"),
("71","1","shipping_postcode","12345678"),
("72","1","shipping_country","IR"),
("73","1","shipping_state","THR"),
("74","1","shipping_phone",""),
("75","1","woocommerce_admin_variable_product_tour_shown","\"yes\""),
("76","1","shipping_method","a:1:{i:0;s:15:\"free_shipping:1\";}"),
("77","1","paying_customer","1"),
("78","1","closedpostboxes_product","a:1:{i:0;s:11:\"commentsdiv\";}"),
("79","1","metaboxhidden_product","a:2:{i:0;s:10:\"postcustom\";i:1;s:7:\"slugdiv\";}"),
("81","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("83","1","nav_menu_recently_edited","68"),
("84","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("85","1","metaboxhidden_nav-menus","a:9:{i:0;s:21:\"add-post-type-product\";i:1;s:27:\"add-post-type-featured_item\";i:2;s:12:\"add-post_tag\";i:3;s:15:\"add-post_format\";i:4;s:20:\"add-block_categories\";i:5;s:15:\"add-product_cat\";i:6;s:15:\"add-product_tag\";i:7;s:26:\"add-featured_item_category\";i:8;s:21:\"add-featured_item_tag\";}"),
("89","1","wpcf7_hide_welcome_panel_on","a:1:{i:0;s:3:\"5.8\";}");

INSERT IGNORE INTO `wp_actionscheduler_actions` VALUES 
("9","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","failed","2023-09-23 14:46:10","2023-09-23 14:46:10","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","2","1","2023-09-23 14:47:19","2023-09-23 18:17:19","0",NULL),
("423","woocommerce_cleanup_draft_orders","complete","2023-11-11 08:56:14","2023-11-11 07:56:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699692974;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699692974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-19 06:47:07","2023-11-19 05:47:07","0",NULL),
("424","woocommerce_cleanup_draft_orders","complete","2023-11-20 06:47:07","2023-11-20 05:47:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700462827;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700462827;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-20 08:34:50","2023-11-20 07:34:50","0",NULL),
("425","woocommerce_run_on_woocommerce_admin_updated","complete","2023-11-19 06:47:35","2023-11-19 05:47:35","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700376455;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700376455;}","4","1","2023-11-19 06:47:36","2023-11-19 05:47:36","0",NULL),
("426","woocommerce_cleanup_draft_orders","complete","2023-11-21 08:34:50","2023-11-21 07:34:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700555690;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700555690;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-21 15:18:36","2023-11-21 14:18:36","0",NULL),
("427","woocommerce_cleanup_draft_orders","complete","2023-11-22 15:18:36","2023-11-22 14:18:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700666316;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700666316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-23 05:52:34","2023-11-23 04:52:34","0",NULL),
("428","woocommerce_cleanup_draft_orders","complete","2023-11-24 05:52:34","2023-11-24 04:52:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700805154;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700805154;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-30 14:06:58","2023-11-30 13:06:58","0",NULL),
("429","woocommerce_run_on_woocommerce_admin_updated","complete","2023-11-30 09:28:37","2023-11-30 08:28:37","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1701336517;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1701336517;}","4","1","2023-11-30 14:06:59","2023-11-30 13:06:59","0",NULL),
("430","woocommerce_cleanup_draft_orders","complete","2023-12-01 14:06:58","2023-12-01 13:06:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1701439618;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1701439618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-12-02 19:28:27","2023-12-02 18:28:27","0",NULL),
("431","woocommerce_cleanup_draft_orders","complete","2023-12-03 19:28:27","2023-12-03 18:28:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1701631707;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1701631707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-12-03 19:28:27","2023-12-03 18:28:27","0",NULL),
("432","woocommerce_cleanup_draft_orders","complete","2023-12-04 19:28:27","2023-12-04 18:28:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1701718107;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1701718107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-12-05 10:19:33","2023-12-05 09:19:33","0",NULL),
("433","woocommerce_cleanup_draft_orders","complete","2023-12-06 10:19:33","2023-12-06 09:19:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1701857973;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1701857973;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-12-06 16:08:00","2023-12-06 15:08:00","0",NULL),
("434","woocommerce_cleanup_draft_orders","complete","2023-12-07 16:08:00","2023-12-07 15:08:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1701965280;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1701965280;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-12-07 16:08:15","2023-12-07 15:08:15","0",NULL),
("435","woocommerce_cleanup_draft_orders","complete","2023-12-08 16:08:15","2023-12-08 15:08:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1702051695;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1702051695;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-12-09 01:47:21","2023-12-09 00:47:21","0",NULL),
("436","woocommerce_cleanup_draft_orders","complete","2023-12-10 01:47:21","2023-12-10 00:47:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1702172841;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1702172841;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-12-10 03:14:45","2023-12-10 02:14:45","0",NULL),
("437","woocommerce_cleanup_draft_orders","complete","2023-12-11 03:14:45","2023-12-11 02:14:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1702264485;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1702264485;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-12-11 03:16:04","2023-12-11 02:16:04","0",NULL),
("438","woocommerce_cleanup_draft_orders","pending","2023-12-12 03:16:04","2023-12-12 02:16:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1702350964;s:18:\"\0*\0first_timestamp\";i:1695478916;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1702350964;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL);

INSERT IGNORE INTO `wp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2",""),
("3","woocommerce-db-updates"),
("4","woocommerce-remote-inbox-engine"),
("5","wc-admin-data"),
("6","wc_update_product_default_cat");

INSERT IGNORE INTO `wp_actionscheduler_logs` VALUES 
("8","9","ایجاد فعالیت","2023-09-23 14:46:10","2023-09-23 14:46:10"),
("9","9","عملیات توسط WP Cron شروع شد","2023-09-23 14:47:19","2023-09-23 14:47:19"),
("10","9","اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.","2023-09-23 14:47:19","2023-09-23 14:47:19"),
("1252","423","ایجاد فعالیت","2023-11-10 08:56:14","2023-11-10 07:56:14"),
("1253","423","عملیات توسط WP Cron شروع شد","2023-11-19 06:47:07","2023-11-19 05:47:07"),
("1254","423","عملیات توسط WP Cron کامل شد","2023-11-19 06:47:07","2023-11-19 05:47:07"),
("1255","424","ایجاد فعالیت","2023-11-19 06:47:07","2023-11-19 05:47:07"),
("1256","425","ایجاد فعالیت","2023-11-19 06:47:35","2023-11-19 05:47:35"),
("1257","425","عملیات توسط Async Request شروع شد","2023-11-19 06:47:36","2023-11-19 05:47:36"),
("1258","425","عملیات توسط Async Request کامل شد","2023-11-19 06:47:36","2023-11-19 05:47:36"),
("1259","424","عملیات توسط WP Cron شروع شد","2023-11-20 08:34:50","2023-11-20 07:34:50"),
("1260","424","عملیات توسط WP Cron کامل شد","2023-11-20 08:34:50","2023-11-20 07:34:50"),
("1261","426","ایجاد فعالیت","2023-11-20 08:34:50","2023-11-20 07:34:50"),
("1262","426","عملیات توسط WP Cron شروع شد","2023-11-21 15:18:36","2023-11-21 14:18:36"),
("1263","426","عملیات توسط WP Cron کامل شد","2023-11-21 15:18:36","2023-11-21 14:18:36"),
("1264","427","ایجاد فعالیت","2023-11-21 15:18:36","2023-11-21 14:18:36"),
("1265","427","عملیات توسط WP Cron شروع شد","2023-11-23 05:52:34","2023-11-23 04:52:34"),
("1266","427","عملیات توسط WP Cron کامل شد","2023-11-23 05:52:34","2023-11-23 04:52:34"),
("1267","428","ایجاد فعالیت","2023-11-23 05:52:34","2023-11-23 04:52:34"),
("1268","429","ایجاد فعالیت","2023-11-30 09:28:37","2023-11-30 08:28:37"),
("1269","428","عملیات توسط WP Cron شروع شد","2023-11-30 14:06:58","2023-11-30 13:06:58"),
("1270","428","عملیات توسط WP Cron کامل شد","2023-11-30 14:06:58","2023-11-30 13:06:58"),
("1271","430","ایجاد فعالیت","2023-11-30 14:06:58","2023-11-30 13:06:58"),
("1272","429","عملیات توسط WP Cron شروع شد","2023-11-30 14:06:58","2023-11-30 13:06:58"),
("1273","429","عملیات توسط WP Cron کامل شد","2023-11-30 14:06:59","2023-11-30 13:06:59"),
("1274","430","عملیات توسط WP Cron شروع شد","2023-12-02 19:28:27","2023-12-02 18:28:27"),
("1275","430","عملیات توسط WP Cron کامل شد","2023-12-02 19:28:27","2023-12-02 18:28:27"),
("1276","431","ایجاد فعالیت","2023-12-02 19:28:27","2023-12-02 18:28:27"),
("1277","431","عملیات توسط WP Cron شروع شد","2023-12-03 19:28:27","2023-12-03 18:28:27"),
("1278","431","عملیات توسط WP Cron کامل شد","2023-12-03 19:28:27","2023-12-03 18:28:27"),
("1279","432","ایجاد فعالیت","2023-12-03 19:28:27","2023-12-03 18:28:27"),
("1280","432","عملیات توسط WP Cron شروع شد","2023-12-05 10:19:33","2023-12-05 09:19:33"),
("1281","432","عملیات توسط WP Cron کامل شد","2023-12-05 10:19:33","2023-12-05 09:19:33"),
("1282","433","ایجاد فعالیت","2023-12-05 10:19:33","2023-12-05 09:19:33"),
("1283","433","عملیات توسط WP Cron شروع شد","2023-12-06 16:08:00","2023-12-06 15:08:00"),
("1284","433","عملیات توسط WP Cron کامل شد","2023-12-06 16:08:00","2023-12-06 15:08:00"),
("1285","434","ایجاد فعالیت","2023-12-06 16:08:00","2023-12-06 15:08:00"),
("1286","434","عملیات توسط WP Cron شروع شد","2023-12-07 16:08:15","2023-12-07 15:08:15"),
("1287","434","عملیات توسط WP Cron کامل شد","2023-12-07 16:08:15","2023-12-07 15:08:15"),
("1288","435","ایجاد فعالیت","2023-12-07 16:08:15","2023-12-07 15:08:15"),
("1289","435","عملیات توسط WP Cron شروع شد","2023-12-09 01:47:21","2023-12-09 00:47:21"),
("1290","435","عملیات توسط WP Cron کامل شد","2023-12-09 01:47:21","2023-12-09 00:47:21"),
("1291","436","ایجاد فعالیت","2023-12-09 01:47:21","2023-12-09 00:47:21"),
("1292","436","عملیات توسط WP Cron شروع شد","2023-12-10 03:14:45","2023-12-10 02:14:45"),
("1293","436","عملیات توسط WP Cron کامل شد","2023-12-10 03:14:45","2023-12-10 02:14:45"),
("1294","437","ایجاد فعالیت","2023-12-10 03:14:45","2023-12-10 02:14:45"),
("1295","437","عملیات توسط WP Cron شروع شد","2023-12-11 03:16:04","2023-12-11 02:16:04"),
("1296","437","عملیات توسط WP Cron کامل شد","2023-12-11 03:16:04","2023-12-11 02:16:04"),
("1297","438","ایجاد فعالیت","2023-12-11 03:16:04","2023-12-11 02:16:04");

INSERT IGNORE INTO `wp_commentmeta` VALUES 
("1","2","rating","5"),
("2","2","verified","0"),
("3","4","rating","5"),
("4","4","verified","0"),
("5","5","rating","5"),
("6","5","verified","0"),
("7","6","rating","4"),
("8","6","verified","0"),
("9","7","rating","5"),
("10","7","verified","0"),
("11","10","rating","4"),
("12","10","verified","0");

INSERT IGNORE INTO `wp_comments` VALUES 
("2","226","flatsome","test@samandon.com","https://theme-samandon.ir/flatsome","5.202.102.11","2023-10-19 23:30:10","2023-10-19 20:00:10","سلام\r\nاین هودی نینجا عالی هست.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36","review","0","1"),
("3","23","مدیر سایت","test@samandon.com","https://theme-samandon.ir/flatsome","5.202.102.11","2023-10-20 00:39:53","2023-10-19 21:09:53","با سلام\r\nاین اخبار عالی هست.\r\nتشکر.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36","comment","0","1"),
("4","186","مدیر سایت","test@samandon.com","https://theme-samandon.ir/flatsome","178.132.3.8","2023-10-20 23:13:12","2023-10-20 19:43:12","با سلام \r\nاین کیف سبز عالی هست.\r\nبا تشکر.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36","review","0","1"),
("5","189","مدیر سایت","test@samandon.com","https://theme-samandon.ir/flatsome","5.202.102.8","2023-10-20 23:55:35","2023-10-20 20:25:35","کیف سفید عالی هست.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36","review","0","1"),
("6","187","مدیر سایت","test@samandon.com","https://theme-samandon.ir/flatsome","5.202.102.8","2023-10-21 00:01:24","2023-10-20 20:31:24","کیف خوبی هست. قالب فلت سام سمنـــدون هم عالی هست.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36","review","0","1"),
("7","179","مدیر سایت","test@samandon.com","https://theme-samandon.ir/flatsome","5.202.102.8","2023-10-21 00:41:59","2023-10-20 21:11:59","بهترین تیشرتی هست که استفاده کردم.\r\nبا تشکر.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36","review","0","1"),
("8","531","ووکامرس","","","","2023-10-21 00:47:46","2023-10-20 21:17:46","در انتظار انتقال مستقیم بانکی(BACS) وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("9","531","مدیر سایت","test@samandon.com","","","2023-10-20 21:22:19","2023-10-20 21:22:19","وضعیت سفارش از در انتظار بررسی به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("10","182","مدیر سایت","test@samandon.com","https://theme-samandon.ir/flatsome","5.202.102.6","2023-10-21 08:28:16","2023-10-21 08:28:16","ازش راضی هستم.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36","review","0","1"),
("11","24","مدیر سایت","test@samandon.com","https://theme-samandon.ir/flatsome","2.188.72.119","2023-12-09 12:57:13","2023-12-09 13:57:13","با سلام و احترام\r\nمعرفی این مقاله عالی هست.","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","1");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("1","20231211_d9bedb8cd8b4d986d985d8a7db8cd8b","b867bd81496a56344524_20231211131740","20231211_d9bedb8cd8b4d986d985d8a7db8cd8b_b867bd81496a56344524_20231211131740_archive.zip","20","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 1,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"10.11.6\",\n    \"VersionPHP\": \"8.1.25\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231211_d9bedb8cd8b4d986d985d8a7db8cd8b\",\n    \"Hash\": \"b867bd81496a56344524_20231211131740\",\n    \"NameHash\": \"20231211_d9bedb8cd8b4d986d985d8a7db8cd8b_b867bd81496a56344524_20231211131740\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231211_d9bedb8cd8b4d986d985d8a7db8cd8b_b867bd81496a56344524_20231211131740_scan.json\",\n    \"timer_start\": 1702300683.650797,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"\\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/.opcache\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/.tmb\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/bps-backup\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/cache\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/old-cache\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/updraft\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/wfcache\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/.htaccess\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/.user.ini\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/php.ini\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/web.config\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-config.php\",\n            \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20231211_d9bedb8cd8b4d986d985d8a7db8cd8b_b867bd81496a56344524_20231211131740_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/themesam\\/public_html\\/flatsome\",\n        \"Size\": 245137234,\n        \"Dirs\": [],\n        \"DirCount\": 2197,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 13459,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231211_d9bedb8cd8b4d986d985d8a7db8cd8b_b867bd81496a56344524_20231211131740_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"PbRr0dHDzMlLJzajLS3hly7TIx8DM4g4mJlloS\\/xLZds93+Emdk7RadoSZGO5ZVX8YZo7WRyKUprzqB5kAgSTA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_persian_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"themesam_flatsome\",\n            \"tablesBaseCount\": 56,\n            \"tablesFinalCount\": 56,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 7571,\n            \"tablesSizeOnDisk\": 12042240,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"18\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"49\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"534\",\n                    \"insertedRows\": 0,\n                    \"size\": 2228224\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"4718\",\n                    \"insertedRows\": 0,\n                    \"size\": 2064384\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"722\",\n                    \"insertedRows\": 0,\n                    \"size\": 4800512\n                },\n                \"wp_social_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"171\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"170\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"453\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"179\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"73\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"113\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"64\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"112\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_woocommerce_ir\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_yith_wcwl\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_yith_wcwl_lists\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.11.6\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20231211_d9bedb8cd8b4d986d985d8a7db8cd8b_b867bd81496a56344524_20231211131740_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/themesam\\/public_html\\/flatsome\\/wp-content\\/backups-dup-pro\\/tmp\\/20231211_d9bedb8cd8b4d986d985d8a7db8cd8b_b867bd81496a56344524_20231211131740_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 20,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1702300685,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_actionscheduler_actions\",\n            \"wp_actionscheduler_claims\",\n            \"wp_actionscheduler_groups\",\n            \"wp_actionscheduler_logs\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_backups\",\n            \"wp_duplicator_entities\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_social_users\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_wc_admin_notes\",\n            \"wp_wc_admin_note_actions\",\n            \"wp_wc_category_lookup\",\n            \"wp_wc_customer_lookup\",\n            \"wp_wc_download_log\",\n            \"wp_wc_orders\",\n            \"wp_wc_orders_meta\",\n            \"wp_wc_order_addresses\",\n            \"wp_wc_order_coupon_lookup\",\n            \"wp_wc_order_operational_data\",\n            \"wp_wc_order_product_lookup\",\n            \"wp_wc_order_stats\",\n            \"wp_wc_order_tax_lookup\",\n            \"wp_wc_product_attributes_lookup\",\n            \"wp_wc_product_download_directories\",\n            \"wp_wc_product_meta_lookup\",\n            \"wp_wc_rate_limits\",\n            \"wp_wc_reserved_stock\",\n            \"wp_wc_tax_rate_classes\",\n            \"wp_wc_webhooks\",\n            \"wp_woocommerce_api_keys\",\n            \"wp_woocommerce_attribute_taxonomies\",\n            \"wp_woocommerce_downloadable_product_permissions\",\n            \"wp_woocommerce_ir\",\n            \"wp_woocommerce_log\",\n            \"wp_woocommerce_order_itemmeta\",\n            \"wp_woocommerce_order_items\",\n            \"wp_woocommerce_payment_tokenmeta\",\n            \"wp_woocommerce_payment_tokens\",\n            \"wp_woocommerce_sessions\",\n            \"wp_woocommerce_shipping_zones\",\n            \"wp_woocommerce_shipping_zone_locations\",\n            \"wp_woocommerce_shipping_zone_methods\",\n            \"wp_woocommerce_tax_rates\",\n            \"wp_woocommerce_tax_rate_locations\",\n            \"wp_yith_wcwl\",\n            \"wp_yith_wcwl_lists\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1702300683.689394,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 7571,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"2\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_social_users\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_ir\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yith_wcwl\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yith_wcwl_lists\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 6,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-11 13:17:49\",\n    \"updated\": \"2023-12-11 13:18:05\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.14.2","2023-12-11 13:17:49","2023-12-11 13:18:05");

INSERT IGNORE INTO `wp_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"test@samandon.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": -1,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"test@samandon.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"gdrive_transfer_mode\": 0,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"local_upload_chunksize_in_MB\": 16,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": -1,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"license_type\": -1,\n    \"license_limit\": 800,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1702300601,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-11 13:16:40\",\n    \"updated\": \"2023-12-11 13:17:40\"\n}","4.5.14.2","2023-12-11 13:16:40","2023-12-11 13:17:40"),
("2","DUP_PRO_Secure_Global_Entity","","","","","","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-11 13:16:40\",\n    \"updated\": \"2023-12-11 13:16:40\"\n}","4.5.14.2","2023-12-11 13:16:40","2023-12-11 13:16:40"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"\\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\n    \"notes\": \"\\u0645\\u06a9\\u0627\\u0646 \\u067e\\u06cc\\u0634 \\u0641\\u0631\\u0636 \\u0628\\u0631\\u0627\\u06cc \\u0630\\u062e\\u06cc\\u0631\\u0647 \\u0633\\u0627\\u0632\\u06cc \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u0627\\u06cc\\u0646 \\u0633\\u0631\\u0648\\u0631.\",\n    \"storage_type\": -2,\n    \"config\": \"nNANi1hhBHLPdyg5M0asKxNX\\/OAKzvWpXmF8s77YVIjdVlAdgVlSYgT6WE1Jr9A2euzd4Q328jRls0GmL+6k4GFqdOCifHE5NRTte4gNwEaG6U6KRn5uKqwR97yEZWB+TQC2pNTslmAYjfavxfVA\\/OBCT6r0ZKAzdrwjyWUKIxP4IspkTa2BoywvAlevks8uekzWM1QwiBthbfHij9ybP3eF27WGkvBKoCmnlnQyDfvZsfXpNTgi6iNfiP+F+QgtZHQQu5ke21SjrYsa8hzctf8mACpbVMrcEscsqYi1L1o=\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 3,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-11 13:16:40\",\n    \"updated\": \"2023-12-11 13:16:40\"\n}","4.5.14.2","2023-12-11 13:16:40","2023-12-11 13:16:40"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [\n        3\n    ],\n    \"id\": 4,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-11 13:16:40\",\n    \"updated\": \"2023-12-11 13:16:40\"\n}","4.5.14.2","2023-12-11 13:16:40","2023-12-11 13:16:40"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"\\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\n    \"notes\": \"\\u0642\\u0627\\u0644\\u0628 \\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"aEuiYuGw94Nuukjfi4kw3wk1sWGs3kbe6WCHltJ3kjhR72p1nlmp+YNiC1K86DPcecQPsBJpSV4P2PmcRRD5jA==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 5,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-11 13:16:40\",\n    \"updated\": \"2023-12-11 13:16:40\"\n}","4.5.14.2","2023-12-11 13:16:40","2023-12-11 13:16:40"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[\\u062d\\u0627\\u0644\\u062a \\u062f\\u0633\\u062a\\u06cc ]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"Btd9THjqBZq7FGcADGm8wkmSEmwkXLVgJmLOei83lbDE85lJ2NdualFHKAwZYk6enoA3eUNH8JaWcVyZ4Or50A==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 6,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-11 13:16:40\",\n    \"updated\": \"2023-12-11 13:17:40\"\n}","4.5.14.2","2023-12-11 13:16:40","2023-12-11 13:17:40"),
("7","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1702300683,\n    \"id\": 7,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-11 13:16:42\",\n    \"updated\": \"2023-12-11 13:18:03\"\n}","4.5.14.2","2023-12-11 13:16:42","2023-12-11 13:18:03");

INSERT IGNORE INTO `wp_options` VALUES 
("1","siteurl","https://theme-samandon.ir/flatsome","yes"),
("2","home","https://theme-samandon.ir/flatsome","yes"),
("3","blogname","پیشنمایش قالب فلت سام | پوسته Flatsome","yes"),
("4","blogdescription","","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","test@samandon.com","yes"),
("7","start_of_week","6","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","1","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","j F , Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","0","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("29","rewrite_rules","a:216:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:47:\"(([^/]+/)*wishlist)(/(.*))?/page/([0-9]{1,})/?$\";s:76:\"index.php?pagename=$matches[1]&wishlist-action=$matches[4]&paged=$matches[5]\";s:30:\"(([^/]+/)*wishlist)(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&wishlist-action=$matches[4]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:16:\"featured_item/?$\";s:33:\"index.php?post_type=featured_item\";s:46:\"featured_item/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=featured_item&feed=$matches[1]\";s:41:\"featured_item/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=featured_item&feed=$matches[1]\";s:33:\"featured_item/page/([0-9]{1,})/?$\";s:51:\"index.php?post_type=featured_item&paged=$matches[1]\";s:32:\"blocks/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"blocks/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"blocks/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blocks/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blocks/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"blocks/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"blocks/(.+?)/embed/?$\";s:39:\"index.php?blocks=$matches[1]&embed=true\";s:25:\"blocks/(.+?)/trackback/?$\";s:33:\"index.php?blocks=$matches[1]&tb=1\";s:33:\"blocks/(.+?)/page/?([0-9]{1,})/?$\";s:46:\"index.php?blocks=$matches[1]&paged=$matches[2]\";s:40:\"blocks/(.+?)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?blocks=$matches[1]&cpage=$matches[2]\";s:30:\"blocks/(.+?)/wc-api(/(.*))?/?$\";s:47:\"index.php?blocks=$matches[1]&wc-api=$matches[3]\";s:36:\"blocks/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"blocks/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:29:\"blocks/(.+?)(?:/([0-9]+))?/?$\";s:45:\"index.php?blocks=$matches[1]&page=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:57:\"block_categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?block_categories=$matches[1]&feed=$matches[2]\";s:52:\"block_categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?block_categories=$matches[1]&feed=$matches[2]\";s:33:\"block_categories/([^/]+)/embed/?$\";s:49:\"index.php?block_categories=$matches[1]&embed=true\";s:45:\"block_categories/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?block_categories=$matches[1]&paged=$matches[2]\";s:27:\"block_categories/([^/]+)/?$\";s:38:\"index.php?block_categories=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:36:\"shop/.+?/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"shop/.+?/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"shop/.+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"shop/.+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"shop/.+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"shop/.+?/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"shop/(.+?)/([^/]+)/embed/?$\";s:64:\"index.php?product_cat=$matches[1]&product=$matches[2]&embed=true\";s:31:\"shop/(.+?)/([^/]+)/trackback/?$\";s:58:\"index.php?product_cat=$matches[1]&product=$matches[2]&tb=1\";s:51:\"shop/(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?product_cat=$matches[1]&product=$matches[2]&feed=$matches[3]\";s:46:\"shop/(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?product_cat=$matches[1]&product=$matches[2]&feed=$matches[3]\";s:39:\"shop/(.+?)/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?product_cat=$matches[1]&product=$matches[2]&paged=$matches[3]\";s:46:\"shop/(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?product_cat=$matches[1]&product=$matches[2]&cpage=$matches[3]\";s:36:\"shop/(.+?)/([^/]+)/wc-api(/(.*))?/?$\";s:72:\"index.php?product_cat=$matches[1]&product=$matches[2]&wc-api=$matches[4]\";s:40:\"shop/.+?/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"shop/.+?/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"shop/(.+?)/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?product_cat=$matches[1]&product=$matches[2]&page=$matches[3]\";s:25:\"shop/.+?/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"shop/.+?/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"shop/.+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"shop/.+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"shop/.+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"shop/.+?/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"featured_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"featured_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"featured_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"featured_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"featured_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"featured_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"featured_item/([^/]+)/embed/?$\";s:46:\"index.php?featured_item=$matches[1]&embed=true\";s:34:\"featured_item/([^/]+)/trackback/?$\";s:40:\"index.php?featured_item=$matches[1]&tb=1\";s:54:\"featured_item/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?featured_item=$matches[1]&feed=$matches[2]\";s:49:\"featured_item/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?featured_item=$matches[1]&feed=$matches[2]\";s:42:\"featured_item/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?featured_item=$matches[1]&paged=$matches[2]\";s:49:\"featured_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?featured_item=$matches[1]&cpage=$matches[2]\";s:39:\"featured_item/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?featured_item=$matches[1]&wc-api=$matches[3]\";s:45:\"featured_item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"featured_item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"featured_item/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?featured_item=$matches[1]&page=$matches[2]\";s:30:\"featured_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"featured_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"featured_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"featured_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"featured_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"featured_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"featured_item_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?featured_item_category=$matches[1]&feed=$matches[2]\";s:58:\"featured_item_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?featured_item_category=$matches[1]&feed=$matches[2]\";s:39:\"featured_item_category/([^/]+)/embed/?$\";s:55:\"index.php?featured_item_category=$matches[1]&embed=true\";s:51:\"featured_item_category/([^/]+)/page/?([0-9]{1,})/?$\";s:62:\"index.php?featured_item_category=$matches[1]&paged=$matches[2]\";s:33:\"featured_item_category/([^/]+)/?$\";s:44:\"index.php?featured_item_category=$matches[1]\";s:58:\"featured_item_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?featured_item_tag=$matches[1]&feed=$matches[2]\";s:53:\"featured_item_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?featured_item_tag=$matches[1]&feed=$matches[2]\";s:34:\"featured_item_tag/([^/]+)/embed/?$\";s:50:\"index.php?featured_item_tag=$matches[1]&embed=true\";s:46:\"featured_item_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?featured_item_tag=$matches[1]&paged=$matches[2]\";s:28:\"featured_item_tag/([^/]+)/?$\";s:39:\"index.php?featured_item_tag=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=103&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:6:{i:0;s:33:\"classic-editor/classic-editor.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:33:\"duplicator-pro/duplicator-pro.php\";i:3;s:53:\"nextend-facebook-connect/nextend-facebook-connect.php\";i:4;s:27:\"woocommerce/woocommerce.php\";i:5;s:34:\"yith-woocommerce-wishlist/init.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","http://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","","no"),
("40","template","flatsome","yes"),
("41","stylesheet","flatsome","yes"),
("42","comment_registration","0","yes"),
("43","html_type","text/html","yes"),
("44","use_trackback","0","yes"),
("45","default_role","subscriber","yes"),
("46","db_version","56657","yes"),
("47","uploads_use_yearmonth_folders","1","yes"),
("48","upload_path","","yes"),
("49","blog_public","1","yes"),
("50","default_link_category","2","yes"),
("51","show_on_front","page","yes"),
("52","tag_base","","yes"),
("53","show_avatars","1","yes"),
("54","avatar_rating","G","yes"),
("55","upload_url_path","","yes"),
("56","thumbnail_size_w","280","yes"),
("57","thumbnail_size_h","280","yes"),
("58","thumbnail_crop","1","yes"),
("59","medium_size_w","800","yes"),
("60","medium_size_h","400","yes"),
("61","avatar_default","mystery","yes"),
("62","large_size_w","1400","yes"),
("63","large_size_h","800","yes"),
("64","image_default_link_type","none","yes"),
("65","image_default_size","","yes"),
("66","image_default_align","","yes"),
("67","close_comments_for_old_posts","0","yes"),
("68","close_comments_days_old","14","yes"),
("69","thread_comments","1","yes"),
("70","thread_comments_depth","5","yes"),
("71","page_comments","0","yes"),
("72","comments_per_page","50","yes"),
("73","default_comments_page","newest","yes"),
("74","comment_order","asc","yes"),
("75","sticky_posts","a:0:{}","yes"),
("76","widget_categories","a:4:{i:5;a:0:{}i:7;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:1;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:14;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:1;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("77","widget_text","a:6:{i:1;a:0:{}i:4;a:3:{s:5:\"title\";s:4:\"asdf\";s:4:\"text\";s:4:\"asdf\";s:6:\"filter\";b:0;}i:13;a:4:{s:5:\"title\";s:12:\"درباره\";s:4:\"text\";s:166:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;}s:12:\"_multiwidget\";i:1;i:15;a:4:{s:5:\"title\";s:17:\"درباره ما\";s:4:\"text\";s:612:\"<p style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد کتابهای زیادی در 63% گذشته حال و آینده شناخت فراوان جامعه را می طلبد.</p>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:16;a:4:{s:5:\"title\";s:30:\"عضویت در خبرنامه\";s:4:\"text\";s:364:\"<p style=\"text-align: justify;\">برای عضویت در خبرنامه ما و دریافت آخرین اخبار، اطلاعیه ها و تخفیفات شگفت انگیز، ایمیل خود را در زیر وارد کنید تا اولین نفری باشید که با خبر می شود.</p>\r\n[contact-form-7 id=\"c61d1e5\" title=\"خبرنامه عمودی\"]\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}}","yes"),
("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("79","uninstall_plugins","a:0:{}","no"),
("80","timezone_string","Atlantic/Azores","yes"),
("81","page_for_posts","94","yes"),
("82","page_on_front","103","yes"),
("83","default_post_format","0","yes"),
("84","link_manager_enabled","0","yes"),
("85","finished_splitting_shared_terms","1","yes"),
("86","site_icon","285","yes"),
("87","medium_large_size_w","768","yes"),
("88","medium_large_size_h","0","yes"),
("89","wp_page_for_privacy_policy","3","yes"),
("90","show_comments_cookies_opt_in","1","yes"),
("91","admin_email_lifespan","1711030858","yes"),
("92","disallowed_keys","","no"),
("93","comment_previously_approved","1","yes"),
("94","auto_plugin_theme_update_emails","a:0:{}","no"),
("95","auto_update_core_dev","enabled","yes"),
("96","auto_update_core_minor","enabled","yes"),
("97","auto_update_core_major","enabled","yes"),
("98","wp_force_deactivated_plugins","a:0:{}","yes"),
("99","initial_db_version","55853","yes"),
("100","wp_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:123:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}","yes"),
("101","fresh_site","0","yes"),
("102","WPLANG","fa_IR","yes"),
("103","user_count","2","no"),
("104","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","yes"),
("105","sidebars_widgets","a:7:{s:19:\"wp_inactive_widgets\";a:86:{i:0;s:23:\"flatsome_recent_posts-3\";i:1;s:23:\"flatsome_recent_posts-5\";i:2;s:23:\"flatsome_recent_posts-6\";i:3;s:23:\"flatsome_recent_posts-8\";i:4;s:23:\"flatsome_recent_posts-9\";i:5;s:24:\"flatsome_recent_posts-11\";i:6;s:24:\"flatsome_recent_posts-13\";i:7;s:24:\"flatsome_recent_posts-14\";i:8;s:24:\"flatsome_recent_posts-16\";i:9;s:24:\"flatsome_recent_posts-17\";i:10;s:24:\"flatsome_recent_posts-18\";i:11;s:14:\"block_widget-2\";i:12;s:14:\"block_widget-3\";i:13;s:15:\"upsell_widget-3\";i:14;s:15:\"upsell_widget-5\";i:15;s:15:\"upsell_widget-7\";i:16;s:31:\"woocommerce_product_tag_cloud-8\";i:17;s:7:\"pages-3\";i:18;s:7:\"pages-5\";i:19;s:7:\"pages-6\";i:20;s:7:\"pages-8\";i:21;s:10:\"calendar-3\";i:22;s:10:\"calendar-5\";i:23;s:10:\"archives-4\";i:24;s:10:\"archives-6\";i:25;s:8:\"search-4\";i:26;s:6:\"text-4\";i:27;s:12:\"categories-5\";i:28;s:12:\"categories-7\";i:29;s:14:\"recent-posts-4\";i:30;s:14:\"recent-posts-6\";i:31;s:14:\"recent-posts-8\";i:32;s:17:\"recent-comments-4\";i:33;s:11:\"tag_cloud-3\";i:34;s:11:\"tag_cloud-8\";i:35;s:25:\"woocommerce_widget_cart-3\";i:36;s:25:\"woocommerce_widget_cart-5\";i:37;s:33:\"woocommerce_layered_nav_filters-3\";i:38;s:33:\"woocommerce_layered_nav_filters-5\";i:39;s:33:\"woocommerce_layered_nav_filters-7\";i:40;s:33:\"woocommerce_layered_nav_filters-9\";i:41;s:25:\"woocommerce_layered_nav-3\";i:42;s:25:\"woocommerce_layered_nav-5\";i:43;s:25:\"woocommerce_layered_nav-7\";i:44;s:26:\"woocommerce_layered_nav-10\";i:45;s:26:\"woocommerce_price_filter-3\";i:46;s:26:\"woocommerce_price_filter-5\";i:47;s:26:\"woocommerce_price_filter-7\";i:48;s:27:\"woocommerce_price_filter-11\";i:49;s:32:\"woocommerce_product_categories-5\";i:50;s:32:\"woocommerce_product_categories-7\";i:51;s:32:\"woocommerce_product_categories-9\";i:52;s:33:\"woocommerce_product_categories-10\";i:53;s:33:\"woocommerce_product_categories-12\";i:54;s:31:\"woocommerce_product_tag_cloud-3\";i:55;s:31:\"woocommerce_product_tag_cloud-5\";i:56;s:31:\"woocommerce_product_tag_cloud-6\";i:57;s:31:\"woocommerce_product_tag_cloud-7\";i:58;s:22:\"woocommerce_products-3\";i:59;s:22:\"woocommerce_products-4\";i:60;s:22:\"woocommerce_products-5\";i:61;s:22:\"woocommerce_products-7\";i:62;s:22:\"woocommerce_products-9\";i:63;s:23:\"woocommerce_products-10\";i:64;s:27:\"woocommerce_rating_filter-2\";i:65;s:27:\"woocommerce_rating_filter-3\";i:66;s:28:\"woocommerce_recent_reviews-3\";i:67;s:38:\"woocommerce_recently_viewed_products-3\";i:68;s:38:\"woocommerce_recently_viewed_products-5\";i:69;s:38:\"woocommerce_recently_viewed_products-7\";i:70;s:32:\"woocommerce_top_rated_products-2\";i:71;s:7:\"text-13\";i:72;s:17:\"recent-comments-5\";i:73;s:11:\"tag_cloud-9\";i:74;s:13:\"categories-14\";i:75;s:10:\"archives-7\";i:76;s:23:\"woocommerce_products-12\";i:77;s:23:\"woocommerce_products-11\";i:78;s:23:\"woocommerce_products-13\";i:79;s:32:\"woocommerce_top_rated_products-3\";i:80;s:12:\"tag_cloud-11\";i:81;s:34:\"woocommerce_layered_nav_filters-10\";i:82;s:33:\"woocommerce_product_categories-13\";i:83;s:26:\"woocommerce_layered_nav-11\";i:84;s:26:\"woocommerce_price_filter-9\";i:85;s:38:\"woocommerce_recently_viewed_products-8\";}s:12:\"sidebar-main\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:16:\"sidebar-footer-1\";a:4:{i:0;s:7:\"text-15\";i:1;s:24:\"flatsome_recent_posts-20\";i:2;s:12:\"tag_cloud-13\";i:3;s:7:\"text-16\";}s:16:\"sidebar-footer-2\";a:0:{}s:12:\"shop-sidebar\";a:0:{}s:15:\"product-sidebar\";a:0:{}s:13:\"array_version\";i:3;}","yes"),
("106","cron","a:22:{i:1702300730;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1702300859;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1702300912;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1702300913;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1702300967;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1702302714;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1702304459;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1702304466;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1702304469;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1702304512;a:2:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1702306004;a:1:{s:34:\"yith_wcwl_delete_expired_wishlists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1702308516;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1702342800;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1702373326;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1702384116;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1702632576;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1702736463;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1702822859;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1702826699;a:1:{s:40:\"flatsome_instagram_refresh_access_tokens\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1702911600;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1703209878;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes"),
("107","widget_pages","a:6:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}i:3;a:3:{s:5:\"title\";s:5:\"Pages\";s:6:\"sortby\";s:10:\"post_title\";s:7:\"exclude\";s:0:\"\";}i:5;a:0:{}i:6;a:3:{s:5:\"title\";s:0:\"\";s:6:\"sortby\";s:10:\"post_title\";s:7:\"exclude\";s:0:\"\";}i:8;a:0:{}}","yes"),
("108","widget_calendar","a:4:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}i:3;a:0:{}i:5;a:0:{}}","yes"),
("109","widget_archives","a:4:{s:12:\"_multiwidget\";i:1;i:4;a:0:{}i:6;a:3:{s:5:\"title\";s:7:\"Archive\";s:5:\"count\";i:1;s:8:\"dropdown\";i:0;}i:7;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:1;s:8:\"dropdown\";i:0;}}","yes"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("115","widget_search","a:2:{s:12:\"_multiwidget\";i:1;i:4;a:1:{s:5:\"title\";s:6:\"Search\";}}","yes"),
("116","widget_recent-posts","a:4:{s:12:\"_multiwidget\";i:1;i:4;a:0:{}i:6;a:3:{s:5:\"title\";s:4:\"asdf\";s:6:\"number\";i:3;s:9:\"show_date\";b:0;}i:8;a:0:{}}","yes"),
("117","widget_recent-comments","a:3:{i:4;a:0:{}i:5;a:2:{s:5:\"title\";s:21:\"آخرین نظرات\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("118","widget_tag_cloud","a:7:{i:1;a:0:{}i:3;a:0:{}i:8;a:0:{}i:9;a:3:{s:5:\"title\";s:17:\"ابر برچسب\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;i:11;a:3:{s:5:\"title\";s:22:\"ابر برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}i:13;a:3:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}}","yes"),
("119","widget_nav_menu","a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}","yes"),
("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("122","recovery_keys","a:0:{}","yes"),
("123","https_detection_errors","a:0:{}","yes"),
("153","recently_activated","a:0:{}","yes"),
("158","action_scheduler_hybrid_store_demarkation","5","yes"),
("159","schema-ActionScheduler_StoreSchema","7.0.1695478910","yes"),
("160","schema-ActionScheduler_LoggerSchema","3.0.1695478910","yes"),
("163","woocommerce_newly_installed","no","yes"),
("164","woocommerce_schema_version","430","yes"),
("165","woocommerce_store_address","","yes"),
("166","woocommerce_store_address_2","","yes"),
("167","woocommerce_store_city","","yes"),
("168","woocommerce_default_country","IR:THR","yes"),
("169","woocommerce_store_postcode","","yes"),
("170","woocommerce_allowed_countries","all","yes"),
("171","woocommerce_all_except_countries","a:0:{}","yes"),
("172","woocommerce_specific_allowed_countries","a:0:{}","yes"),
("173","woocommerce_ship_to_countries","","yes"),
("174","woocommerce_specific_ship_to_countries","a:0:{}","yes"),
("175","woocommerce_default_customer_address","base","yes"),
("176","woocommerce_calc_taxes","no","yes"),
("177","woocommerce_enable_coupons","yes","yes"),
("178","woocommerce_calc_discounts_sequentially","no","no"),
("179","woocommerce_currency","IRT","yes"),
("180","woocommerce_currency_pos","right_space","yes"),
("181","woocommerce_price_thousand_sep",",","yes"),
("182","woocommerce_price_decimal_sep",".","yes"),
("183","woocommerce_price_num_decimals","0","yes"),
("184","woocommerce_shop_page_id","6","yes"),
("185","woocommerce_cart_redirect_after_add","no","yes"),
("186","woocommerce_enable_ajax_add_to_cart","yes","yes"),
("187","woocommerce_placeholder_image","5","yes"),
("188","woocommerce_weight_unit","kg","yes"),
("189","woocommerce_dimension_unit","cm","yes"),
("190","woocommerce_enable_reviews","yes","yes"),
("191","woocommerce_review_rating_verification_label","yes","no"),
("192","woocommerce_review_rating_verification_required","no","no"),
("193","woocommerce_enable_review_rating","yes","yes"),
("194","woocommerce_review_rating_required","yes","no"),
("195","woocommerce_manage_stock","yes","yes"),
("196","woocommerce_hold_stock_minutes","60","no"),
("197","woocommerce_notify_low_stock","yes","no"),
("198","woocommerce_notify_no_stock","yes","no"),
("199","woocommerce_stock_email_recipient","test@samandon.com","no"),
("200","woocommerce_notify_low_stock_amount","2","no"),
("201","woocommerce_notify_no_stock_amount","0","yes"),
("202","woocommerce_hide_out_of_stock_items","no","yes"),
("203","woocommerce_stock_format","","yes"),
("204","woocommerce_file_download_method","force","no"),
("205","woocommerce_downloads_redirect_fallback_allowed","no","no"),
("206","woocommerce_downloads_require_login","no","no"),
("207","woocommerce_downloads_grant_access_after_payment","yes","no"),
("208","woocommerce_downloads_deliver_inline","","no"),
("209","woocommerce_downloads_add_hash_to_filename","yes","yes"),
("211","woocommerce_attribute_lookup_direct_updates","no","yes"),
("212","woocommerce_prices_include_tax","no","yes"),
("213","woocommerce_tax_based_on","shipping","yes"),
("214","woocommerce_shipping_tax_class","inherit","yes"),
("215","woocommerce_tax_round_at_subtotal","no","yes"),
("216","woocommerce_tax_classes","","yes"),
("217","woocommerce_tax_display_shop","excl","yes"),
("218","woocommerce_tax_display_cart","excl","yes"),
("219","woocommerce_price_display_suffix","","yes"),
("220","woocommerce_tax_total_display","itemized","no"),
("221","woocommerce_enable_shipping_calc","yes","no"),
("222","woocommerce_shipping_cost_requires_address","no","yes"),
("223","woocommerce_ship_to_destination","billing","no"),
("224","woocommerce_shipping_debug_mode","no","yes"),
("225","woocommerce_enable_guest_checkout","yes","no"),
("226","woocommerce_enable_checkout_login_reminder","no","no"),
("227","woocommerce_enable_signup_and_login_from_checkout","no","no"),
("228","woocommerce_enable_myaccount_registration","no","no"),
("229","woocommerce_registration_generate_username","yes","no"),
("230","woocommerce_registration_generate_password","yes","no"),
("231","woocommerce_erasure_request_removes_order_data","no","no"),
("232","woocommerce_erasure_request_removes_download_data","no","no"),
("233","woocommerce_allow_bulk_remove_personal_data","no","no"),
("234","woocommerce_registration_privacy_policy_text","اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.","yes"),
("235","woocommerce_checkout_privacy_policy_text","اطلاعات شخصی شما برای پردازش سفارش شما، پشتیبانی از تجربه شما در سراسر این وب سایت و برای اهدافی که در [privacy_policy] ذکر شده است استفاده می شود.","yes"),
("236","woocommerce_delete_inactive_accounts","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("237","woocommerce_trash_pending_orders","","no"),
("238","woocommerce_trash_failed_orders","","no"),
("239","woocommerce_trash_cancelled_orders","","no"),
("240","woocommerce_anonymize_completed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("241","woocommerce_email_from_name","پیشنمایش قالب فلت سام | پوسته Flatsome","no"),
("242","woocommerce_email_from_address","test@samandon.com","no"),
("243","woocommerce_email_header_image","","no"),
("244","woocommerce_email_footer_text","{site_title} &mdash; Built with {WooCommerce}","no"),
("245","woocommerce_email_base_color","#7f54b3","no"),
("246","woocommerce_email_background_color","#f7f7f7","no"),
("247","woocommerce_email_body_background_color","#ffffff","no"),
("248","woocommerce_email_text_color","#3c3c3c","no"),
("249","woocommerce_merchant_email_notifications","no","no"),
("250","woocommerce_cart_page_id","7","no"),
("251","woocommerce_checkout_page_id","8","no"),
("252","woocommerce_myaccount_page_id","9","no"),
("253","woocommerce_terms_page_id","","no"),
("254","woocommerce_checkout_pay_endpoint","order-pay","yes"),
("255","woocommerce_checkout_order_received_endpoint","order-received","yes"),
("256","woocommerce_myaccount_add_payment_method_endpoint","add-payment-method","yes"),
("257","woocommerce_myaccount_delete_payment_method_endpoint","delete-payment-method","yes"),
("258","woocommerce_myaccount_set_default_payment_method_endpoint","set-default-payment-method","yes"),
("259","woocommerce_myaccount_orders_endpoint","orders","yes"),
("260","woocommerce_myaccount_view_order_endpoint","view-order","yes"),
("261","woocommerce_myaccount_downloads_endpoint","downloads","yes"),
("262","woocommerce_myaccount_edit_account_endpoint","edit-account","yes"),
("263","woocommerce_myaccount_edit_address_endpoint","edit-address","yes"),
("264","woocommerce_myaccount_payment_methods_endpoint","payment-methods","yes"),
("265","woocommerce_myaccount_lost_password_endpoint","lost-password","yes"),
("266","woocommerce_logout_endpoint","customer-logout","yes"),
("267","woocommerce_api_enabled","no","yes"),
("268","woocommerce_allow_tracking","no","no"),
("269","woocommerce_show_marketplace_suggestions","yes","no"),
("270","woocommerce_analytics_enabled","yes","yes"),
("271","woocommerce_navigation_enabled","no","yes"),
("272","woocommerce_feature_product_block_editor_enabled","no","yes"),
("273","woocommerce_custom_orders_table_enabled","no","yes"),
("274","woocommerce_custom_orders_table_data_sync_enabled","no","yes"),
("275","woocommerce_custom_orders_table_created","yes","yes"),
("276","woocommerce_single_image_width","510","yes"),
("277","woocommerce_thumbnail_image_width","247","yes"),
("278","woocommerce_checkout_highlight_required_fields","yes","yes"),
("279","woocommerce_demo_store","no","no"),
("280","wc_downloads_approved_directories_mode","enabled","yes"),
("281","woocommerce_permalinks","a:5:{s:12:\"product_base\";s:19:\"/shop/%product_cat%\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:1;}","yes"),
("282","current_theme_supports_woocommerce","yes","yes"),
("283","woocommerce_queue_flush_rewrite_rules","no","yes"),
("286","default_product_cat","15","yes"),
("288","woocommerce_refund_returns_page_id","10","yes"),
("291","woocommerce_paypal_settings","a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:17:\"test@samandon.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:17:\"test@samandon.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}","yes"),
("292","woocommerce_version","8.3.1","yes"),
("293","woocommerce_db_version","8.3.1","yes"),
("294","woocommerce_admin_install_timestamp","1695478912","yes"),
("295","woocommerce_inbox_variant_assignment","6","yes"),
("299","_transient_jetpack_autoloader_plugin_paths","a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}","yes"),
("300","action_scheduler_lock_async-request-runner","65770bf11051c0.91380474|1702300717","no"),
("301","woocommerce_admin_notices","a:0:{}","yes"),
("302","wc_blocks_version","11.4.9","yes"),
("303","jetpack_connection_active_plugins","a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:14:\"ووکامرس\";}}","yes"),
("304","woocommerce_maxmind_geolocation_settings","a:1:{s:15:\"database_prefix\";s:32:\"haiidJ8eC65dl671ktITAlBLY7elf12L\";}","yes"),
("305","_transient_woocommerce_webhook_ids_status_active","a:0:{}","yes"),
("306","widget_woocommerce_widget_cart","a:4:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}i:3;a:2:{s:5:\"title\";s:6:\"Cart12\";s:13:\"hide_if_empty\";i:0;}i:5;a:0:{}}","yes"),
("307","widget_woocommerce_layered_nav_filters","a:7:{i:1;a:0:{}i:3;a:0:{}i:5;a:0:{}i:7;a:0:{}i:9;a:1:{s:5:\"title\";s:14:\"Active Filters\";}i:10;a:1:{s:5:\"title\";s:25:\"فیلترهای فعال\";}s:12:\"_multiwidget\";i:1;}","yes"),
("308","widget_woocommerce_layered_nav","a:7:{i:1;a:0:{}i:3;a:0:{}i:5;a:0:{}i:7;a:4:{s:5:\"title\";s:9:\"Filter by\";s:9:\"attribute\";s:5:\"color\";s:12:\"display_type\";s:4:\"list\";s:10:\"query_type\";s:2:\"or\";}i:10;a:4:{s:5:\"title\";s:9:\"Filter by\";s:9:\"attribute\";s:5:\"color\";s:12:\"display_type\";s:4:\"list\";s:10:\"query_type\";s:2:\"or\";}i:11;a:4:{s:5:\"title\";s:35:\"فیلتر بر اساس ویژگی\";s:9:\"attribute\";s:6:\"رنگ\";s:12:\"display_type\";s:4:\"list\";s:10:\"query_type\";s:3:\"and\";}s:12:\"_multiwidget\";i:1;}","yes"),
("309","widget_woocommerce_price_filter","a:7:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}i:3;a:0:{}i:5;a:0:{}i:7;a:0:{}i:9;a:0:{}i:11;a:1:{s:5:\"title\";s:15:\"Filter by price\";}}","yes"),
("310","widget_woocommerce_product_categories","a:8:{i:1;a:0:{}i:5;a:7:{s:5:\"title\";s:18:\"Product Categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:1;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}i:7;a:7:{s:5:\"title\";s:18:\"Product Categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:1;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}i:9;a:7:{s:5:\"title\";s:9:\"Browse By\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:1;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}i:10;a:7:{s:5:\"title\";s:18:\"Product Categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}i:12;a:7:{s:5:\"title\";s:18:\"Product Categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:1;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}i:13;a:8:{s:5:\"title\";s:17:\"مرور کردن\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("311","widget_woocommerce_product_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("312","widget_woocommerce_product_tag_cloud","a:7:{i:1;a:0:{}i:3;a:0:{}i:5;a:1:{s:5:\"title\";s:4:\"Tags\";}i:6;a:1:{s:5:\"title\";s:12:\"Product Tags\";}i:7;a:1:{s:5:\"title\";s:12:\"Product Tags\";}i:8;a:1:{s:5:\"title\";s:22:\"ابر برچسب ها\";}s:12:\"_multiwidget\";i:1;}","yes"),
("313","widget_woocommerce_products","a:11:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}i:3;a:7:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";s:1:\"4\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:4;a:7:{s:5:\"title\";s:12:\"Best Sellers\";s:6:\"number\";s:1:\"4\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:5:\"sales\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:5;a:7:{s:5:\"title\";s:7:\"On Sale\";s:6:\"number\";i:3;s:4:\"show\";s:6:\"onsale\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:7;a:7:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";i:4;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:9;a:7:{s:5:\"title\";s:15:\"Latest Products\";s:6:\"number\";i:4;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"rand\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:10;a:7:{s:5:\"title\";s:17:\"Featured Products\";s:6:\"number\";i:4;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:11;a:7:{s:5:\"title\";s:36:\"پرفروش ترین محصولات\";s:6:\"number\";i:4;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:5:\"sales\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:12;a:7:{s:5:\"title\";s:25:\"آخرین محصولات\";s:6:\"number\";i:4;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:13;a:7:{s:5:\"title\";s:23:\"محصولات ویژه\";s:6:\"number\";i:4;s:4:\"show\";s:8:\"featured\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}}","yes"),
("314","widget_woocommerce_recently_viewed_products","a:6:{i:1;a:0:{}i:3;a:2:{s:5:\"title\";s:24:\"Recently Viewed Products\";s:6:\"number\";s:1:\"3\";}i:5;a:2:{s:5:\"title\";s:24:\"Recently Viewed Products\";s:6:\"number\";i:4;}i:7;a:2:{s:5:\"title\";s:24:\"Recently Viewed Products\";s:6:\"number\";i:10;}i:8;a:2:{s:5:\"title\";s:45:\"محصولات اخیرا بازدید شده\";s:6:\"number\";i:3;}s:12:\"_multiwidget\";i:1;}","yes"),
("315","widget_woocommerce_top_rated_products","a:4:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}i:2;a:2:{s:5:\"title\";s:18:\"Top Rated Products\";s:6:\"number\";i:5;}i:3;a:2:{s:5:\"title\";s:27:\"برترین محصولات\";s:6:\"number\";i:3;}}","yes"),
("316","widget_woocommerce_recent_reviews","a:3:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}i:3;a:2:{s:5:\"title\";s:14:\"Recent Reviews\";s:6:\"number\";s:1:\"3\";}}","yes"),
("317","widget_woocommerce_rating_filter","a:3:{s:12:\"_multiwidget\";i:1;i:2;a:1:{s:5:\"title\";s:14:\"Average Rating\";}i:3;a:1:{s:5:\"title\";s:14:\"Average Rating\";}}","yes"),
("322","wcpay_was_in_use","no","yes"),
("334","wc_admin_show_legacy_coupon_menu","0","yes"),
("335","_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl","1704892672","no"),
("336","_transient_woocommerce_blocks_asset_api_script_data_ssl","{\"script_data\":{\"build\\/wc-settings.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-settings.js\",\"version\":\"811714876abd43a87bd7\",\"dependencies\":[\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/wc-blocks-middleware.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-middleware.js\",\"version\":\"ca04183222edaf8a26be\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\"]},\"build\\/wc-blocks-data.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-data.js\",\"version\":\"44400df383376f8b7fe7\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"build\\/wc-blocks-vendors.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-vendors.js\",\"version\":\"e52cee08054e9f3ffe1d\",\"dependencies\":[\"wp-polyfill\"]},\"build\\/wc-blocks-registry.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-registry.js\",\"version\":\"e7d9da2af6eda520ea57\",\"dependencies\":[\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-polyfill\"]},\"build\\/wc-blocks.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks.js\",\"version\":\"ac61343ba386c5afa166\",\"dependencies\":[\"wp-blocks\",\"wp-compose\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/wc-blocks-shared-context.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-shared-context.js\",\"version\":\"20ec2364dc7f9fed72cb\",\"dependencies\":[\"wp-element\",\"wp-polyfill\"]},\"build\\/wc-blocks-shared-hocs.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-shared-hocs.js\",\"version\":\"e9b159d0b79d44581eed\",\"dependencies\":[\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"build\\/price-format.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/price-format.js\",\"version\":\"eb7a7398126f71912b09\",\"dependencies\":[\"wc-settings\",\"wp-polyfill\"]},\"build\\/blocks-checkout.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/blocks-checkout.js\",\"version\":\"36cac271dc32d663ff9b\",\"dependencies\":[\"lodash\",\"react\",\"react-dom\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"build\\/blocks-components.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/blocks-components.js\",\"version\":\"dcff128e74cd87c473f2\",\"dependencies\":[\"react\",\"wc-blocks-checkout\",\"wp-compose\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/active-filters.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/active-filters.js\",\"version\":\"b6e9eb3e0f960c24d528\",\"dependencies\":[\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/active-filters-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/active-filters-frontend.js\",\"version\":\"7f19935b45ec0abc002a\",\"dependencies\":[\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wp-data\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/all-products.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/all-products.js\",\"version\":\"c05b4f546fab76a9051a\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/all-products-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/all-products-frontend.js\",\"version\":\"e24250707c907b8c41b7\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/all-reviews.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/all-reviews.js\",\"version\":\"725ec7bbe34d892261d9\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/reviews-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/reviews-frontend.js\",\"version\":\"48f4e2a59ddf8a675ce0\",\"dependencies\":[\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-compose\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"build\\/attribute-filter.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/attribute-filter.js\",\"version\":\"f0d6ac9c7b1e1f55e2f1\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"build\\/attribute-filter-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/attribute-filter-frontend.js\",\"version\":\"f920c3b56ef5b551b1b3\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"build\\/breadcrumbs.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/breadcrumbs.js\",\"version\":\"6b45dded020303f67506\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/catalog-sorting.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/catalog-sorting.js\",\"version\":\"4391eb36f5cb037f64d3\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/legacy-template.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/legacy-template.js\",\"version\":\"7745f71e7318b0f01255\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/classic-shortcode.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/classic-shortcode.js\",\"version\":\"c713b514a992a9e664a4\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/customer-account.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/customer-account.js\",\"version\":\"ee155a26a7cc78f028c2\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/featured-category.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/featured-category.js\",\"version\":\"711c1faf465cb5effd56\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\"]},\"build\\/featured-product.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/featured-product.js\",\"version\":\"6db6e325a0711c102b7f\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\"]},\"build\\/filter-wrapper.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/filter-wrapper.js\",\"version\":\"b19921517c7b9147d2f4\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/filter-wrapper-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/filter-wrapper-frontend.js\",\"version\":\"d5947ab32f460fff899d\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\"]},\"build\\/handpicked-products.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/handpicked-products.js\",\"version\":\"1e3f000920b15a3e91fc\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/mini-cart.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart.js\",\"version\":\"4b72a71f1e0d037a371d\",\"dependencies\":[\"react\",\"wc-price-format\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/mini-cart-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-frontend.js\",\"version\":\"61e99d9cd2611bcf7267\",\"dependencies\":[\"wc-price-format\",\"wc-settings\",\"wp-api-fetch\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/store-notices.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/store-notices.js\",\"version\":\"38316b7a9eee1b7f1a6e\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/price-filter.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/price-filter.js\",\"version\":\"ec8ae11fcdb9b959892e\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/price-filter-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/price-filter-frontend.js\",\"version\":\"dd4e55aad706b6d82855\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-url\"]},\"build\\/product-add-to-cart.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-add-to-cart.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-add-to-cart-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-add-to-cart-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-best-sellers.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-best-sellers.js\",\"version\":\"5c11d140749a960416d6\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/product-button.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-button.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-button-interactivity-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-button-interactivity-frontend.js\",\"version\":\"13791a2a13bd09d17cdc\",\"dependencies\":[\"lodash\",\"wc-blocks-data-store\",\"wc-interactivity\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"build\\/product-categories.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-categories.js\",\"version\":\"5ad643e9636e7e993ffe\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\"]},\"build\\/product-category.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-category.js\",\"version\":\"9edc688d083a77d71c75\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/product-collection.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-collection.js\",\"version\":\"5fbe8b2630e60f0004f1\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/product-new.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-new.js\",\"version\":\"111fb1795b522aeec9a2\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/product-on-sale.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-on-sale.js\",\"version\":\"951afd2329ccd655925c\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/product-template.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-template.js\",\"version\":\"360717558cb56501fe69\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/product-query.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-query.js\",\"version\":\"b1fb9bec1006abd8ca00\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/product-query-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-query-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-results-count.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-results-count.js\",\"version\":\"13825f464c6c45d5afae\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/product-search.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-search.js\",\"version\":\"c4b9e7d6160ef89018bd\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/product-summary.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-summary.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-tag.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-tag.js\",\"version\":\"4d7388028f36ca8fcf09\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/product-title.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-title.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-title-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-title-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-top-rated.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-top-rated.js\",\"version\":\"cdcf2e54dd95a5c33334\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/products-by-attribute.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/products-by-attribute.js\",\"version\":\"a95f41882a3500ba3537\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/rating-filter.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/rating-filter.js\",\"version\":\"8cdf324c59f3341eab0b\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"build\\/reviews-by-category.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/reviews-by-category.js\",\"version\":\"b65caad230120481d78b\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/reviews-by-product.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/reviews-by-product.js\",\"version\":\"8b7e33547559684a790c\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/single-product.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/single-product.js\",\"version\":\"42ed58e087043e17bf85\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-store-data\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/stock-filter.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/stock-filter.js\",\"version\":\"10519f8d8fd3e66a1827\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"build\\/stock-filter-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/stock-filter-frontend.js\",\"version\":\"e4069417fcbb0f97d59b\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"build\\/page-content-wrapper.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/page-content-wrapper.js\",\"version\":\"56bb47464c0ff5b7a604\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-status.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-status.js\",\"version\":\"f14c86bad8f5cf0da65a\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-summary.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-summary.js\",\"version\":\"f46fd23fcdbc82d84cbe\",\"dependencies\":[\"wc-price-format\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-date\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-totals.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-totals.js\",\"version\":\"e80e47bfcd02246ca77c\",\"dependencies\":[\"wc-price-format\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-totals-wrapper.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-totals-wrapper.js\",\"version\":\"e121effbe218d09adf50\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-downloads.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-downloads.js\",\"version\":\"8c8aa7f060e385c78076\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-downloads-wrapper.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-downloads-wrapper.js\",\"version\":\"2066976a0b58ca359f42\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-billing-address.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-billing-address.js\",\"version\":\"fe9f414caddf75cfa681\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-shipping-address.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-shipping-address.js\",\"version\":\"59a5f6ef042b626de44a\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-billing-wrapper.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-billing-wrapper.js\",\"version\":\"547a513a64eb92dfa993\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-shipping-wrapper.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-shipping-wrapper.js\",\"version\":\"88815ce3d06c68e335b1\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-additional-information.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-additional-information.js\",\"version\":\"4e371b569d26db536166\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/cart.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart.js\",\"version\":\"d442e3988df8ace1acd0\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-editor\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/wc-payment-method-cheque.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-payment-method-cheque.js\",\"version\":\"77fd104213f608200fcf\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/wc-payment-method-bacs.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-payment-method-bacs.js\",\"version\":\"5e2505172bd7b5886aaf\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/wc-payment-method-cod.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-payment-method-cod.js\",\"version\":\"313cf2de9481109290e2\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/cart-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-frontend.js\",\"version\":\"ccaa02b19a06f8bcd7c5\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-blocks\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/cart-blocks\\/cart-accepted-payment-methods-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-accepted-payment-methods-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-accepted-payment-methods-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-accepted-payment-methods-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-cross-sells-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-cross-sells-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-cross-sells-products-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-cross-sells-products-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-cross-sells-products-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-cross-sells-products-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-cross-sells-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-cross-sells-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-express-payment-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-express-payment-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-express-payment-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-express-payment-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-items-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-items-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-items-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-items-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-line-items-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-line-items-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-line-items-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-line-items-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-order-summary-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-order-summary-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-order-summary-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-order-summary-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-totals-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-totals-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-totals-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-totals-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/empty-cart-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/empty-cart-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/filled-cart-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/filled-cart-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/filled-cart-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-coupon-form-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-coupon-form-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-coupon-form-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-coupon-form-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-discount-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-discount-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-discount-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-discount-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-fee-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-fee-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-fee-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-fee-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-heading-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-heading-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-heading-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-heading-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-shipping-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-shipping-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-shipping-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-shipping-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-subtotal-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-subtotal-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-subtotal-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-subtotal-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-taxes-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-taxes-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-taxes-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-taxes-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/proceed-to-checkout-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/proceed-to-checkout-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/proceed-to-checkout-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/proceed-to-checkout-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-taxes-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-taxes-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-subtotal-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-subtotal-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/filled-cart-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/filled-cart-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/empty-cart-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/empty-cart-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-totals-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-totals-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-items-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-items-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-line-items-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-line-items-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-express-payment-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-express-payment-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/proceed-to-checkout-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/proceed-to-checkout-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-accepted-payment-methods-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-accepted-payment-methods-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-coupon-form-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-coupon-form-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-discount-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-discount-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-fee-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-fee-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-heading-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-heading-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-shipping-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-shipping-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-cross-sells-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-cross-sells-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-cross-sells-products-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-cross-sells-products-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout.js\",\"version\":\"a9fdc8d8792a40805ed6\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-editor\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/checkout-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-frontend.js\",\"version\":\"6e00ea8fc9060a4d0444\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/checkout-blocks\\/actions-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/actions-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/actions-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/actions-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/billing-address-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/billing-address-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/billing-address-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/billing-address-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/contact-information-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/contact-information-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/contact-information-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/contact-information-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/express-payment-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/express-payment-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/fields-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/fields-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/fields-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/fields-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-note-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-note-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-cart-items-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-cart-items-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-cart-items-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-cart-items-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-coupon-form-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-coupon-form-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-coupon-form-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-coupon-form-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-discount-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-discount-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-discount-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-discount-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-fee-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-fee-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-fee-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-fee-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-shipping-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-shipping-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-shipping-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-shipping-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-subtotal-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-subtotal-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-subtotal-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-subtotal-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-taxes-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-taxes-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-taxes-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-taxes-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/payment-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/payment-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/payment-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/payment-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/pickup-options-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/pickup-options-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/pickup-options-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/pickup-options-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-address-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-address-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-address-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-address-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-method-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-method-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-methods-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-methods-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-methods-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-methods-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-method-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-method-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/terms-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/terms-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/terms-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/terms-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/totals-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/totals-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/totals-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/totals-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-express-payment--checkout-blocks\\/express-payment-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-express-payment--checkout-blocks\\/express-payment-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-actions-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-actions-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-billing-address-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-billing-address-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-contact-information-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-contact-information-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-express-payment-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-express-payment-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-fields-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-fields-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-note-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-note-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-cart-items-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-cart-items-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-coupon-form-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-coupon-form-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-discount-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-discount-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-fee-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-fee-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-shipping-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-shipping-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-subtotal-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-subtotal-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-taxes-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-taxes-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-payment-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-payment-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-shipping-address-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-shipping-address-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-shipping-methods-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-shipping-methods-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-shipping-method-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-shipping-method-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-pickup-options-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-pickup-options-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-terms-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-terms-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-totals-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-totals-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents.js\",\"version\":\"60d7c3a553a736a6130f\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/empty-mini-cart-contents-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/empty-mini-cart-contents-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/filled-mini-cart-contents-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/filled-mini-cart-contents-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-footer-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-footer-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-items-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-items-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-products-table-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-products-table-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-shopping-button-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-shopping-button-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-cart-button-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-cart-button-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-checkout-button-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-checkout-button-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-title-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-title-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-title-items-counter-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-title-items-counter-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-title-label-block.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-title-label-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-component-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-component-frontend.js\",\"version\":\"e9b2e4691cc86be6723b\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/mini-cart-contents-block\\/cart-button-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/cart-button-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/cart-button-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/cart-button-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/checkout-button-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/checkout-button-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/checkout-button-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/checkout-button-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/empty-cart-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/empty-cart-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/filled-cart-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/filled-cart-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/filled-cart-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/footer-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/footer-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/footer-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/footer-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/items-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/items-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/items-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/items-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/shopping-button-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/shopping-button-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/shopping-button-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/shopping-button-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/title-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/title-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/title-items-counter-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/title-items-counter-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/title-items-counter-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/title-items-counter-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/title-label-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/title-label-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/title-label-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/title-label-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents-block\\/title-style.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents-block\\/title-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/wc-shipping-method-pickup-location.js\":{\"src\":\"https:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-shipping-method-pickup-location.js\",\"version\":\"1900729d0999a73c1d64\",\"dependencies\":[\"react\",\"react-dom\",\"wc-settings\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]}},\"version\":\"11.4.9\",\"hash\":\"1f30642b53866fe76ee7afd19d4b59b9\"}","no");

INSERT IGNORE INTO `wp_options` VALUES 
("337","wc_blocks_db_schema_version","260","yes"),
("338","wc_remote_inbox_notifications_stored_state","O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}","no"),
("345","jetpack_options","a:1:{s:14:\"last_heartbeat\";i:1702218141;}","yes"),
("346","_transient_woocommerce_reports-transient-version","1697836979","yes"),
("360","finished_updating_comment_type","1","yes"),
("362","_transient_shipping-transient-version","1695479124","yes"),
("365","woocommerce_task_list_tracked_completed_tasks","a:4:{i:0;s:8:\"purchase\";i:1;s:8:\"shipping\";i:2;s:8:\"products\";i:3;s:8:\"payments\";}","yes"),
("368","woocommerce_onboarding_profile","a:7:{s:15:\"business_choice\";s:18:\"im_already_selling\";s:21:\"selling_online_answer\";s:34:\"im_selling_both_online_and_offline\";s:17:\"selling_platforms\";a:1:{i:0;s:9:\"wordpress\";}s:20:\"is_store_country_set\";b:1;s:8:\"industry\";a:1:{i:0;N;}s:9:\"completed\";b:1;s:23:\"is_plugins_page_skipped\";b:1;}","yes"),
("369","woocommerce_admin_created_default_shipping_zones","yes","yes"),
("370","_transient_woocommerce_shipping_task_zone_count_transient","1","yes"),
("371","woocommerce_task_list_prompt_shown","1","yes"),
("380","theme_mods_twentytwentythree","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1695479139;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","yes"),
("381","current_theme","Flatsome","yes"),
("382","theme_mods_flatsome","a:112:{i:0;b:0;s:17:\"flatsome_fallback\";i:1;s:20:\"topbar_elements_left\";a:1:{i:0;s:4:\"html\";}s:21:\"topbar_elements_right\";a:3:{i:0;s:7:\"nav-top\";i:1;s:10:\"newsletter\";i:2;s:6:\"social\";}s:20:\"header_elements_left\";a:2:{i:0;s:6:\"search\";i:1;s:3:\"nav\";}s:21:\"header_elements_right\";a:5:{i:0;s:7:\"account\";i:1;s:9:\"divider_3\";i:2;s:8:\"wishlist\";i:3;s:7:\"divider\";i:4;s:4:\"cart\";}s:27:\"header_elements_bottom_left\";a:0:{}s:29:\"header_elements_bottom_center\";a:0:{}s:28:\"header_elements_bottom_right\";a:0:{}s:27:\"header_mobile_elements_left\";a:1:{i:0;s:9:\"menu-icon\";}s:28:\"header_mobile_elements_right\";a:1:{i:0;s:4:\"cart\";}s:26:\"header_mobile_elements_top\";a:1:{i:0;s:4:\"html\";}s:14:\"mobile_sidebar\";a:7:{i:0;s:11:\"search-form\";i:1;s:3:\"nav\";i:2;s:7:\"account\";i:3;s:10:\"newsletter\";i:4;s:6:\"social\";i:5;s:6:\"html-2\";i:6;s:6:\"html-3\";}s:14:\"product_layout\";s:19:\"right-sidebar-small\";s:23:\"payment_icons_placement\";s:6:\"footer\";s:14:\"follow_twitter\";s:10:\"http://url\";s:15:\"follow_facebook\";s:10:\"http://url\";s:16:\"follow_instagram\";s:10:\"http://url\";s:12:\"follow_email\";s:10:\"your@email\";s:16:\"flatsome_version\";i:3;s:24:\"portfolio_archive_filter\";s:4:\"left\";s:13:\"type_headings\";a:5:{s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:7:\"variant\";s:3:\"700\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:700;s:10:\"font-style\";s:6:\"normal\";}s:10:\"type_texts\";a:5:{s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:7:\"variant\";s:7:\"regular\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:400;s:10:\"font-style\";s:6:\"normal\";}s:8:\"type_nav\";a:5:{s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:7:\"variant\";s:7:\"regular\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:400;s:10:\"font-style\";s:6:\"normal\";}s:8:\"type_alt\";a:5:{s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:7:\"variant\";s:7:\"regular\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:400;s:10:\"font-style\";s:6:\"normal\";}s:14:\"pages_template\";s:7:\"default\";s:11:\"site_loader\";s:0:\"\";s:19:\"flatsome_db_version\";s:6:\"3.18.2\";s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:68;s:6:\"footer\";i:67;s:11:\"top_bar_nav\";i:67;}s:7:\"backups\";N;s:9:\"smof_init\";s:31:\"Sat, 23 Sep 2023 14:25:41 +0000\";s:19:\"html_scripts_header\";s:0:\"\";s:19:\"html_scripts_footer\";s:0:\"\";s:23:\"html_scripts_after_body\";s:0:\"\";s:24:\"html_scripts_before_body\";s:0:\"\";s:15:\"html_custom_css\";s:0:\"\";s:22:\"html_custom_css_tablet\";s:0:\"\";s:22:\"html_custom_css_mobile\";s:0:\"\";s:17:\"perf_instant_page\";i:0;s:21:\"lazy_load_backgrounds\";i:1;s:16:\"lazy_load_images\";s:1:\"1\";s:26:\"flatsome_disable_style_css\";i:0;s:13:\"disable_emoji\";i:0;s:16:\"disable_blockcss\";i:0;s:14:\"jquery_migrate\";i:0;s:17:\"site_loader_color\";s:5:\"light\";s:14:\"site_loader_bg\";s:0:\"\";s:11:\"live_search\";i:1;s:18:\"search_placeholder\";s:0:\"\";s:21:\"search_result_latency\";s:1:\"0\";s:13:\"search_result\";i:1;s:19:\"search_result_style\";s:6:\"slider\";s:24:\"search_products_order_by\";s:9:\"relevance\";s:13:\"search_by_sku\";i:0;s:21:\"search_by_product_tag\";i:0;s:19:\"instagram_lazy_load\";i:0;s:14:\"google_map_api\";s:0:\"\";s:16:\"maintenance_mode\";i:0;s:29:\"maintenance_mode_admin_notice\";i:1;s:21:\"maintenance_mode_page\";i:0;s:21:\"maintenance_mode_text\";s:57:\"لطفا به زودی دوباره بررسی کنید..\";s:9:\"404_block\";i:0;s:8:\"swatches\";s:1:\"1\";s:27:\"additional_variation_images\";s:1:\"1\";s:16:\"ajax_add_to_cart\";s:1:\"1\";s:15:\"disable_reviews\";i:0;s:27:\"product_gallery_woocommerce\";i:0;s:14:\"html_shop_page\";s:24:\"[block id=\"shop-header\"]\";s:9:\"tab_title\";s:0:\"\";s:11:\"tab_content\";s:0:\"\";s:23:\"html_before_add_to_cart\";s:1:\" \";s:22:\"html_after_add_to_cart\";s:0:\"\";s:14:\"html_thank_you\";s:0:\"\";s:12:\"catalog_mode\";i:0;s:19:\"catalog_mode_prices\";i:0;s:23:\"catalog_mode_sale_badge\";i:0;s:19:\"catalog_mode_header\";s:0:\"\";s:20:\"catalog_mode_product\";s:0:\"\";s:21:\"catalog_mode_lightbox\";s:0:\"\";s:27:\"infinite_scroll_loader_type\";s:7:\"spinner\";s:26:\"infinite_scroll_loader_img\";s:0:\"\";s:16:\"activated_before\";b:1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1695480322;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"sidebar-main\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:16:\"sidebar-footer-1\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:16:\"sidebar-footer-2\";a:0:{}s:12:\"shop-sidebar\";a:0:{}s:15:\"product-sidebar\";a:0:{}}}s:18:\"custom_css_post_id\";i:784;s:10:\"logo_width\";s:3:\"200\";s:13:\"disable_fonts\";b:0;s:16:\"type_size_mobile\";s:3:\"100\";s:9:\"type_size\";s:3:\"100\";s:16:\"footer_left_text\";s:148:\"تمامی حقوق برای وبسایت سمنـــدون \n محفوط می باشد [ux_current_year] © <strong>قالب فلت سام</strong>\";s:17:\"facebook_accounts\";a:1:{i:0;s:1:\"0\";}s:12:\"fl_portfolio\";s:1:\"1\";s:15:\"parallax_mobile\";s:1:\"0\";s:15:\"flatsome_studio\";s:1:\"1\";s:15:\"release_channel\";s:6:\"stable\";s:22:\"blog_posts_depth_hover\";s:1:\"0\";s:11:\"blog_header\";s:24:\"[block id=\"blog-header\"]\";s:17:\"footer_1_bg_image\";s:0:\"\";s:23:\"header_newsletter_label\";s:14:\"خبرنامه\";s:23:\"header_newsletter_title\";s:46:\"برای خبرنامه ثبت نام کنید\";s:27:\"header_newsletter_sub_title\";s:199:\"در خبرنامه ما ثبت نام کنید تا از فروش و محصولات جدید مطلع شوید. هر متنی را در اینجا اضافه کنید یا آن را حذف کنید.\";s:20:\"header_newsletter_bg\";s:70:\"https://theme-samandon.ir/flatsome/wp-content/uploads/2014/07/sf-1.jpg\";s:27:\"header_newsletter_shortcode\";s:61:\"[contact-form-7 id=\"6af22c7\" title=\"خبرنامه افقی\"]\";s:14:\"footer_1_color\";s:4:\"dark\";s:17:\"footer_1_bg_color\";s:7:\"#777777\";s:8:\"footer_2\";b:0;s:15:\"blog_pagination\";s:0:\"\";s:15:\"shop_pagination\";s:0:\"\";s:24:\"shop_filter_widgets_pjax\";s:1:\"0\";s:18:\"pjax_scroll_to_top\";s:1:\"0\";s:27:\"maintenance_mode_bypass_key\";s:0:\"\";s:31:\"maintenance_mode_excluded_roles\";a:6:{s:6:\"editor\";s:1:\"0\";s:6:\"author\";s:1:\"0\";s:11:\"contributor\";s:1:\"0\";s:10:\"subscriber\";s:1:\"0\";s:8:\"customer\";s:1:\"0\";s:12:\"shop_manager\";s:1:\"0\";}s:21:\"header_wishlist_label\";s:24:\"علاقه مندی ها\";}","yes"),
("383","theme_switched","","yes"),
("384","flatsome_registration","a:8:{s:2:\"id\";s:13:\"new_id_123456\";s:4:\"type\";s:6:\"PUBLIC\";s:6:\"domain\";s:17:\"theme-samandon.ir\";s:12:\"registeredAt\";s:24:\"2021-07-18T12:51:10.826Z\";s:12:\"purchaseCode\";s:36:\"abcd1234-5678-90ef-ghij-klmnopqrstuv\";s:11:\"licenseType\";s:15:\"Regular License\";s:6:\"errors\";a:0:{}s:11:\"show_notice\";b:0;}","yes"),
("385","widget_flatsome_recent_posts","a:14:{i:1;a:0:{}i:3;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:5:\"image\";s:2:\"on\";}i:5;a:3:{s:5:\"title\";s:5:\"Posts\";s:6:\"number\";i:5;s:5:\"image\";s:2:\"on\";}i:6;a:3:{s:5:\"title\";s:16:\"Latest From Blog\";s:6:\"number\";i:4;s:5:\"image\";N;}i:8;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;s:5:\"image\";N;}i:9;a:3:{s:5:\"title\";s:10:\"Thumbnail \";s:6:\"number\";i:5;s:5:\"image\";s:2:\"on\";}i:11;a:3:{s:5:\"title\";s:17:\"Latest Blog Posts\";s:6:\"number\";i:5;s:5:\"image\";N;}i:13;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:4;s:5:\"image\";N;}i:14;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;s:5:\"image\";N;}i:16;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:5:\"image\";N;}i:17;a:4:{s:5:\"title\";s:26:\"آخرین نوشته ها\";s:6:\"number\";i:5;s:5:\"image\";N;s:10:\"date-stamp\";N;}i:18;a:4:{s:5:\"title\";s:21:\"آخرین اخبار\";s:6:\"number\";i:4;s:5:\"image\";N;s:10:\"date-stamp\";N;}s:12:\"_multiwidget\";i:1;i:20;a:4:{s:5:\"title\";s:21:\"آخرین اخبار\";s:6:\"number\";i:4;s:5:\"image\";N;s:10:\"date-stamp\";N;}}","yes"),
("386","widget_block_widget","a:3:{s:12:\"_multiwidget\";i:1;i:2;a:2:{s:5:\"title\";s:17:\"درباره ما\";s:5:\"block\";s:15:\"footer-about-us\";}i:3;a:2:{s:5:\"title\";s:34:\"عضویت برای خبرنامه\";s:5:\"block\";s:24:\"footer-newsletter-signup\";}}","yes"),
("387","widget_upsell_widget","a:5:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}i:3;a:0:{}i:5;a:0:{}i:7;a:1:{s:5:\"title\";s:16:\"Complete the loo\";}}","yes"),
("388","woocommerce_thumbnail_cropping","custom","yes"),
("389","woocommerce_thumbnail_cropping_custom_width","5","yes"),
("390","woocommerce_thumbnail_cropping_custom_height","6","yes"),
("391","wc_blocks_use_blockified_product_grid_block_as_template","no","yes"),
("393","woocommerce_maybe_regenerate_images_hash","958afab2d0b050fa8d8b61b9b9cd31bf","yes"),
("398","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.4.2\";s:5:\"files\";a:500:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:20:\"block/editor-rtl.css\";i:29;s:24:\"block/editor-rtl.min.css\";i:30;s:16:\"block/editor.css\";i:31;s:20:\"block/editor.min.css\";i:32;s:21:\"button/editor-rtl.css\";i:33;s:25:\"button/editor-rtl.min.css\";i:34;s:17:\"button/editor.css\";i:35;s:21:\"button/editor.min.css\";i:36;s:20:\"button/style-rtl.css\";i:37;s:24:\"button/style-rtl.min.css\";i:38;s:16:\"button/style.css\";i:39;s:20:\"button/style.min.css\";i:40;s:22:\"buttons/editor-rtl.css\";i:41;s:26:\"buttons/editor-rtl.min.css\";i:42;s:18:\"buttons/editor.css\";i:43;s:22:\"buttons/editor.min.css\";i:44;s:21:\"buttons/style-rtl.css\";i:45;s:25:\"buttons/style-rtl.min.css\";i:46;s:17:\"buttons/style.css\";i:47;s:21:\"buttons/style.min.css\";i:48;s:22:\"calendar/style-rtl.css\";i:49;s:26:\"calendar/style-rtl.min.css\";i:50;s:18:\"calendar/style.css\";i:51;s:22:\"calendar/style.min.css\";i:52;s:25:\"categories/editor-rtl.css\";i:53;s:29:\"categories/editor-rtl.min.css\";i:54;s:21:\"categories/editor.css\";i:55;s:25:\"categories/editor.min.css\";i:56;s:24:\"categories/style-rtl.css\";i:57;s:28:\"categories/style-rtl.min.css\";i:58;s:20:\"categories/style.css\";i:59;s:24:\"categories/style.min.css\";i:60;s:19:\"code/editor-rtl.css\";i:61;s:23:\"code/editor-rtl.min.css\";i:62;s:15:\"code/editor.css\";i:63;s:19:\"code/editor.min.css\";i:64;s:18:\"code/style-rtl.css\";i:65;s:22:\"code/style-rtl.min.css\";i:66;s:14:\"code/style.css\";i:67;s:18:\"code/style.min.css\";i:68;s:18:\"code/theme-rtl.css\";i:69;s:22:\"code/theme-rtl.min.css\";i:70;s:14:\"code/theme.css\";i:71;s:18:\"code/theme.min.css\";i:72;s:22:\"columns/editor-rtl.css\";i:73;s:26:\"columns/editor-rtl.min.css\";i:74;s:18:\"columns/editor.css\";i:75;s:22:\"columns/editor.min.css\";i:76;s:21:\"columns/style-rtl.css\";i:77;s:25:\"columns/style-rtl.min.css\";i:78;s:17:\"columns/style.css\";i:79;s:21:\"columns/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:30:\"comment-template/style-rtl.css\";i:85;s:34:\"comment-template/style-rtl.min.css\";i:86;s:26:\"comment-template/style.css\";i:87;s:30:\"comment-template/style.min.css\";i:88;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:89;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:90;s:38:\"comments-pagination-numbers/editor.css\";i:91;s:42:\"comments-pagination-numbers/editor.min.css\";i:92;s:34:\"comments-pagination/editor-rtl.css\";i:93;s:38:\"comments-pagination/editor-rtl.min.css\";i:94;s:30:\"comments-pagination/editor.css\";i:95;s:34:\"comments-pagination/editor.min.css\";i:96;s:33:\"comments-pagination/style-rtl.css\";i:97;s:37:\"comments-pagination/style-rtl.min.css\";i:98;s:29:\"comments-pagination/style.css\";i:99;s:33:\"comments-pagination/style.min.css\";i:100;s:29:\"comments-title/editor-rtl.css\";i:101;s:33:\"comments-title/editor-rtl.min.css\";i:102;s:25:\"comments-title/editor.css\";i:103;s:29:\"comments-title/editor.min.css\";i:104;s:23:\"comments/editor-rtl.css\";i:105;s:27:\"comments/editor-rtl.min.css\";i:106;s:19:\"comments/editor.css\";i:107;s:23:\"comments/editor.min.css\";i:108;s:22:\"comments/style-rtl.css\";i:109;s:26:\"comments/style-rtl.min.css\";i:110;s:18:\"comments/style.css\";i:111;s:22:\"comments/style.min.css\";i:112;s:20:\"cover/editor-rtl.css\";i:113;s:24:\"cover/editor-rtl.min.css\";i:114;s:16:\"cover/editor.css\";i:115;s:20:\"cover/editor.min.css\";i:116;s:19:\"cover/style-rtl.css\";i:117;s:23:\"cover/style-rtl.min.css\";i:118;s:15:\"cover/style.css\";i:119;s:19:\"cover/style.min.css\";i:120;s:22:\"details/editor-rtl.css\";i:121;s:26:\"details/editor-rtl.min.css\";i:122;s:18:\"details/editor.css\";i:123;s:22:\"details/editor.min.css\";i:124;s:21:\"details/style-rtl.css\";i:125;s:25:\"details/style-rtl.min.css\";i:126;s:17:\"details/style.css\";i:127;s:21:\"details/style.min.css\";i:128;s:20:\"embed/editor-rtl.css\";i:129;s:24:\"embed/editor-rtl.min.css\";i:130;s:16:\"embed/editor.css\";i:131;s:20:\"embed/editor.min.css\";i:132;s:19:\"embed/style-rtl.css\";i:133;s:23:\"embed/style-rtl.min.css\";i:134;s:15:\"embed/style.css\";i:135;s:19:\"embed/style.min.css\";i:136;s:19:\"embed/theme-rtl.css\";i:137;s:23:\"embed/theme-rtl.min.css\";i:138;s:15:\"embed/theme.css\";i:139;s:19:\"embed/theme.min.css\";i:140;s:19:\"file/editor-rtl.css\";i:141;s:23:\"file/editor-rtl.min.css\";i:142;s:15:\"file/editor.css\";i:143;s:19:\"file/editor.min.css\";i:144;s:18:\"file/style-rtl.css\";i:145;s:22:\"file/style-rtl.min.css\";i:146;s:14:\"file/style.css\";i:147;s:18:\"file/style.min.css\";i:148;s:23:\"footnotes/style-rtl.css\";i:149;s:27:\"footnotes/style-rtl.min.css\";i:150;s:19:\"footnotes/style.css\";i:151;s:23:\"footnotes/style.min.css\";i:152;s:23:\"freeform/editor-rtl.css\";i:153;s:27:\"freeform/editor-rtl.min.css\";i:154;s:19:\"freeform/editor.css\";i:155;s:23:\"freeform/editor.min.css\";i:156;s:22:\"gallery/editor-rtl.css\";i:157;s:26:\"gallery/editor-rtl.min.css\";i:158;s:18:\"gallery/editor.css\";i:159;s:22:\"gallery/editor.min.css\";i:160;s:21:\"gallery/style-rtl.css\";i:161;s:25:\"gallery/style-rtl.min.css\";i:162;s:17:\"gallery/style.css\";i:163;s:21:\"gallery/style.min.css\";i:164;s:21:\"gallery/theme-rtl.css\";i:165;s:25:\"gallery/theme-rtl.min.css\";i:166;s:17:\"gallery/theme.css\";i:167;s:21:\"gallery/theme.min.css\";i:168;s:20:\"group/editor-rtl.css\";i:169;s:24:\"group/editor-rtl.min.css\";i:170;s:16:\"group/editor.css\";i:171;s:20:\"group/editor.min.css\";i:172;s:19:\"group/style-rtl.css\";i:173;s:23:\"group/style-rtl.min.css\";i:174;s:15:\"group/style.css\";i:175;s:19:\"group/style.min.css\";i:176;s:19:\"group/theme-rtl.css\";i:177;s:23:\"group/theme-rtl.min.css\";i:178;s:15:\"group/theme.css\";i:179;s:19:\"group/theme.min.css\";i:180;s:21:\"heading/style-rtl.css\";i:181;s:25:\"heading/style-rtl.min.css\";i:182;s:17:\"heading/style.css\";i:183;s:21:\"heading/style.min.css\";i:184;s:19:\"html/editor-rtl.css\";i:185;s:23:\"html/editor-rtl.min.css\";i:186;s:15:\"html/editor.css\";i:187;s:19:\"html/editor.min.css\";i:188;s:20:\"image/editor-rtl.css\";i:189;s:24:\"image/editor-rtl.min.css\";i:190;s:16:\"image/editor.css\";i:191;s:20:\"image/editor.min.css\";i:192;s:19:\"image/style-rtl.css\";i:193;s:23:\"image/style-rtl.min.css\";i:194;s:15:\"image/style.css\";i:195;s:19:\"image/style.min.css\";i:196;s:19:\"image/theme-rtl.css\";i:197;s:23:\"image/theme-rtl.min.css\";i:198;s:15:\"image/theme.css\";i:199;s:19:\"image/theme.min.css\";i:200;s:29:\"latest-comments/style-rtl.css\";i:201;s:33:\"latest-comments/style-rtl.min.css\";i:202;s:25:\"latest-comments/style.css\";i:203;s:29:\"latest-comments/style.min.css\";i:204;s:27:\"latest-posts/editor-rtl.css\";i:205;s:31:\"latest-posts/editor-rtl.min.css\";i:206;s:23:\"latest-posts/editor.css\";i:207;s:27:\"latest-posts/editor.min.css\";i:208;s:26:\"latest-posts/style-rtl.css\";i:209;s:30:\"latest-posts/style-rtl.min.css\";i:210;s:22:\"latest-posts/style.css\";i:211;s:26:\"latest-posts/style.min.css\";i:212;s:18:\"list/style-rtl.css\";i:213;s:22:\"list/style-rtl.min.css\";i:214;s:14:\"list/style.css\";i:215;s:18:\"list/style.min.css\";i:216;s:25:\"media-text/editor-rtl.css\";i:217;s:29:\"media-text/editor-rtl.min.css\";i:218;s:21:\"media-text/editor.css\";i:219;s:25:\"media-text/editor.min.css\";i:220;s:24:\"media-text/style-rtl.css\";i:221;s:28:\"media-text/style-rtl.min.css\";i:222;s:20:\"media-text/style.css\";i:223;s:24:\"media-text/style.min.css\";i:224;s:19:\"more/editor-rtl.css\";i:225;s:23:\"more/editor-rtl.min.css\";i:226;s:15:\"more/editor.css\";i:227;s:19:\"more/editor.min.css\";i:228;s:30:\"navigation-link/editor-rtl.css\";i:229;s:34:\"navigation-link/editor-rtl.min.css\";i:230;s:26:\"navigation-link/editor.css\";i:231;s:30:\"navigation-link/editor.min.css\";i:232;s:29:\"navigation-link/style-rtl.css\";i:233;s:33:\"navigation-link/style-rtl.min.css\";i:234;s:25:\"navigation-link/style.css\";i:235;s:29:\"navigation-link/style.min.css\";i:236;s:33:\"navigation-submenu/editor-rtl.css\";i:237;s:37:\"navigation-submenu/editor-rtl.min.css\";i:238;s:29:\"navigation-submenu/editor.css\";i:239;s:33:\"navigation-submenu/editor.min.css\";i:240;s:25:\"navigation/editor-rtl.css\";i:241;s:29:\"navigation/editor-rtl.min.css\";i:242;s:21:\"navigation/editor.css\";i:243;s:25:\"navigation/editor.min.css\";i:244;s:24:\"navigation/style-rtl.css\";i:245;s:28:\"navigation/style-rtl.min.css\";i:246;s:20:\"navigation/style.css\";i:247;s:24:\"navigation/style.min.css\";i:248;s:23:\"nextpage/editor-rtl.css\";i:249;s:27:\"nextpage/editor-rtl.min.css\";i:250;s:19:\"nextpage/editor.css\";i:251;s:23:\"nextpage/editor.min.css\";i:252;s:24:\"page-list/editor-rtl.css\";i:253;s:28:\"page-list/editor-rtl.min.css\";i:254;s:20:\"page-list/editor.css\";i:255;s:24:\"page-list/editor.min.css\";i:256;s:23:\"page-list/style-rtl.css\";i:257;s:27:\"page-list/style-rtl.min.css\";i:258;s:19:\"page-list/style.css\";i:259;s:23:\"page-list/style.min.css\";i:260;s:24:\"paragraph/editor-rtl.css\";i:261;s:28:\"paragraph/editor-rtl.min.css\";i:262;s:20:\"paragraph/editor.css\";i:263;s:24:\"paragraph/editor.min.css\";i:264;s:23:\"paragraph/style-rtl.css\";i:265;s:27:\"paragraph/style-rtl.min.css\";i:266;s:19:\"paragraph/style.css\";i:267;s:23:\"paragraph/style.min.css\";i:268;s:25:\"post-author/style-rtl.css\";i:269;s:29:\"post-author/style-rtl.min.css\";i:270;s:21:\"post-author/style.css\";i:271;s:25:\"post-author/style.min.css\";i:272;s:33:\"post-comments-form/editor-rtl.css\";i:273;s:37:\"post-comments-form/editor-rtl.min.css\";i:274;s:29:\"post-comments-form/editor.css\";i:275;s:33:\"post-comments-form/editor.min.css\";i:276;s:32:\"post-comments-form/style-rtl.css\";i:277;s:36:\"post-comments-form/style-rtl.min.css\";i:278;s:28:\"post-comments-form/style.css\";i:279;s:32:\"post-comments-form/style.min.css\";i:280;s:23:\"post-date/style-rtl.css\";i:281;s:27:\"post-date/style-rtl.min.css\";i:282;s:19:\"post-date/style.css\";i:283;s:23:\"post-date/style.min.css\";i:284;s:27:\"post-excerpt/editor-rtl.css\";i:285;s:31:\"post-excerpt/editor-rtl.min.css\";i:286;s:23:\"post-excerpt/editor.css\";i:287;s:27:\"post-excerpt/editor.min.css\";i:288;s:26:\"post-excerpt/style-rtl.css\";i:289;s:30:\"post-excerpt/style-rtl.min.css\";i:290;s:22:\"post-excerpt/style.css\";i:291;s:26:\"post-excerpt/style.min.css\";i:292;s:34:\"post-featured-image/editor-rtl.css\";i:293;s:38:\"post-featured-image/editor-rtl.min.css\";i:294;s:30:\"post-featured-image/editor.css\";i:295;s:34:\"post-featured-image/editor.min.css\";i:296;s:33:\"post-featured-image/style-rtl.css\";i:297;s:37:\"post-featured-image/style-rtl.min.css\";i:298;s:29:\"post-featured-image/style.css\";i:299;s:33:\"post-featured-image/style.min.css\";i:300;s:34:\"post-navigation-link/style-rtl.css\";i:301;s:38:\"post-navigation-link/style-rtl.min.css\";i:302;s:30:\"post-navigation-link/style.css\";i:303;s:34:\"post-navigation-link/style.min.css\";i:304;s:28:\"post-template/editor-rtl.css\";i:305;s:32:\"post-template/editor-rtl.min.css\";i:306;s:24:\"post-template/editor.css\";i:307;s:28:\"post-template/editor.min.css\";i:308;s:27:\"post-template/style-rtl.css\";i:309;s:31:\"post-template/style-rtl.min.css\";i:310;s:23:\"post-template/style.css\";i:311;s:27:\"post-template/style.min.css\";i:312;s:24:\"post-terms/style-rtl.css\";i:313;s:28:\"post-terms/style-rtl.min.css\";i:314;s:20:\"post-terms/style.css\";i:315;s:24:\"post-terms/style.min.css\";i:316;s:24:\"post-title/style-rtl.css\";i:317;s:28:\"post-title/style-rtl.min.css\";i:318;s:20:\"post-title/style.css\";i:319;s:24:\"post-title/style.min.css\";i:320;s:26:\"preformatted/style-rtl.css\";i:321;s:30:\"preformatted/style-rtl.min.css\";i:322;s:22:\"preformatted/style.css\";i:323;s:26:\"preformatted/style.min.css\";i:324;s:24:\"pullquote/editor-rtl.css\";i:325;s:28:\"pullquote/editor-rtl.min.css\";i:326;s:20:\"pullquote/editor.css\";i:327;s:24:\"pullquote/editor.min.css\";i:328;s:23:\"pullquote/style-rtl.css\";i:329;s:27:\"pullquote/style-rtl.min.css\";i:330;s:19:\"pullquote/style.css\";i:331;s:23:\"pullquote/style.min.css\";i:332;s:23:\"pullquote/theme-rtl.css\";i:333;s:27:\"pullquote/theme-rtl.min.css\";i:334;s:19:\"pullquote/theme.css\";i:335;s:23:\"pullquote/theme.min.css\";i:336;s:39:\"query-pagination-numbers/editor-rtl.css\";i:337;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:338;s:35:\"query-pagination-numbers/editor.css\";i:339;s:39:\"query-pagination-numbers/editor.min.css\";i:340;s:31:\"query-pagination/editor-rtl.css\";i:341;s:35:\"query-pagination/editor-rtl.min.css\";i:342;s:27:\"query-pagination/editor.css\";i:343;s:31:\"query-pagination/editor.min.css\";i:344;s:30:\"query-pagination/style-rtl.css\";i:345;s:34:\"query-pagination/style-rtl.min.css\";i:346;s:26:\"query-pagination/style.css\";i:347;s:30:\"query-pagination/style.min.css\";i:348;s:25:\"query-title/style-rtl.css\";i:349;s:29:\"query-title/style-rtl.min.css\";i:350;s:21:\"query-title/style.css\";i:351;s:25:\"query-title/style.min.css\";i:352;s:20:\"query/editor-rtl.css\";i:353;s:24:\"query/editor-rtl.min.css\";i:354;s:16:\"query/editor.css\";i:355;s:20:\"query/editor.min.css\";i:356;s:19:\"query/style-rtl.css\";i:357;s:23:\"query/style-rtl.min.css\";i:358;s:15:\"query/style.css\";i:359;s:19:\"query/style.min.css\";i:360;s:19:\"quote/style-rtl.css\";i:361;s:23:\"quote/style-rtl.min.css\";i:362;s:15:\"quote/style.css\";i:363;s:19:\"quote/style.min.css\";i:364;s:19:\"quote/theme-rtl.css\";i:365;s:23:\"quote/theme-rtl.min.css\";i:366;s:15:\"quote/theme.css\";i:367;s:19:\"quote/theme.min.css\";i:368;s:23:\"read-more/style-rtl.css\";i:369;s:27:\"read-more/style-rtl.min.css\";i:370;s:19:\"read-more/style.css\";i:371;s:23:\"read-more/style.min.css\";i:372;s:18:\"rss/editor-rtl.css\";i:373;s:22:\"rss/editor-rtl.min.css\";i:374;s:14:\"rss/editor.css\";i:375;s:18:\"rss/editor.min.css\";i:376;s:17:\"rss/style-rtl.css\";i:377;s:21:\"rss/style-rtl.min.css\";i:378;s:13:\"rss/style.css\";i:379;s:17:\"rss/style.min.css\";i:380;s:21:\"search/editor-rtl.css\";i:381;s:25:\"search/editor-rtl.min.css\";i:382;s:17:\"search/editor.css\";i:383;s:21:\"search/editor.min.css\";i:384;s:20:\"search/style-rtl.css\";i:385;s:24:\"search/style-rtl.min.css\";i:386;s:16:\"search/style.css\";i:387;s:20:\"search/style.min.css\";i:388;s:20:\"search/theme-rtl.css\";i:389;s:24:\"search/theme-rtl.min.css\";i:390;s:16:\"search/theme.css\";i:391;s:20:\"search/theme.min.css\";i:392;s:24:\"separator/editor-rtl.css\";i:393;s:28:\"separator/editor-rtl.min.css\";i:394;s:20:\"separator/editor.css\";i:395;s:24:\"separator/editor.min.css\";i:396;s:23:\"separator/style-rtl.css\";i:397;s:27:\"separator/style-rtl.min.css\";i:398;s:19:\"separator/style.css\";i:399;s:23:\"separator/style.min.css\";i:400;s:23:\"separator/theme-rtl.css\";i:401;s:27:\"separator/theme-rtl.min.css\";i:402;s:19:\"separator/theme.css\";i:403;s:23:\"separator/theme.min.css\";i:404;s:24:\"shortcode/editor-rtl.css\";i:405;s:28:\"shortcode/editor-rtl.min.css\";i:406;s:20:\"shortcode/editor.css\";i:407;s:24:\"shortcode/editor.min.css\";i:408;s:24:\"site-logo/editor-rtl.css\";i:409;s:28:\"site-logo/editor-rtl.min.css\";i:410;s:20:\"site-logo/editor.css\";i:411;s:24:\"site-logo/editor.min.css\";i:412;s:23:\"site-logo/style-rtl.css\";i:413;s:27:\"site-logo/style-rtl.min.css\";i:414;s:19:\"site-logo/style.css\";i:415;s:23:\"site-logo/style.min.css\";i:416;s:27:\"site-tagline/editor-rtl.css\";i:417;s:31:\"site-tagline/editor-rtl.min.css\";i:418;s:23:\"site-tagline/editor.css\";i:419;s:27:\"site-tagline/editor.min.css\";i:420;s:25:\"site-title/editor-rtl.css\";i:421;s:29:\"site-title/editor-rtl.min.css\";i:422;s:21:\"site-title/editor.css\";i:423;s:25:\"site-title/editor.min.css\";i:424;s:24:\"site-title/style-rtl.css\";i:425;s:28:\"site-title/style-rtl.min.css\";i:426;s:20:\"site-title/style.css\";i:427;s:24:\"site-title/style.min.css\";i:428;s:26:\"social-link/editor-rtl.css\";i:429;s:30:\"social-link/editor-rtl.min.css\";i:430;s:22:\"social-link/editor.css\";i:431;s:26:\"social-link/editor.min.css\";i:432;s:27:\"social-links/editor-rtl.css\";i:433;s:31:\"social-links/editor-rtl.min.css\";i:434;s:23:\"social-links/editor.css\";i:435;s:27:\"social-links/editor.min.css\";i:436;s:26:\"social-links/style-rtl.css\";i:437;s:30:\"social-links/style-rtl.min.css\";i:438;s:22:\"social-links/style.css\";i:439;s:26:\"social-links/style.min.css\";i:440;s:21:\"spacer/editor-rtl.css\";i:441;s:25:\"spacer/editor-rtl.min.css\";i:442;s:17:\"spacer/editor.css\";i:443;s:21:\"spacer/editor.min.css\";i:444;s:20:\"spacer/style-rtl.css\";i:445;s:24:\"spacer/style-rtl.min.css\";i:446;s:16:\"spacer/style.css\";i:447;s:20:\"spacer/style.min.css\";i:448;s:20:\"table/editor-rtl.css\";i:449;s:24:\"table/editor-rtl.min.css\";i:450;s:16:\"table/editor.css\";i:451;s:20:\"table/editor.min.css\";i:452;s:19:\"table/style-rtl.css\";i:453;s:23:\"table/style-rtl.min.css\";i:454;s:15:\"table/style.css\";i:455;s:19:\"table/style.min.css\";i:456;s:19:\"table/theme-rtl.css\";i:457;s:23:\"table/theme-rtl.min.css\";i:458;s:15:\"table/theme.css\";i:459;s:19:\"table/theme.min.css\";i:460;s:23:\"tag-cloud/style-rtl.css\";i:461;s:27:\"tag-cloud/style-rtl.min.css\";i:462;s:19:\"tag-cloud/style.css\";i:463;s:23:\"tag-cloud/style.min.css\";i:464;s:28:\"template-part/editor-rtl.css\";i:465;s:32:\"template-part/editor-rtl.min.css\";i:466;s:24:\"template-part/editor.css\";i:467;s:28:\"template-part/editor.min.css\";i:468;s:27:\"template-part/theme-rtl.css\";i:469;s:31:\"template-part/theme-rtl.min.css\";i:470;s:23:\"template-part/theme.css\";i:471;s:27:\"template-part/theme.min.css\";i:472;s:30:\"term-description/style-rtl.css\";i:473;s:34:\"term-description/style-rtl.min.css\";i:474;s:26:\"term-description/style.css\";i:475;s:30:\"term-description/style.min.css\";i:476;s:27:\"text-columns/editor-rtl.css\";i:477;s:31:\"text-columns/editor-rtl.min.css\";i:478;s:23:\"text-columns/editor.css\";i:479;s:27:\"text-columns/editor.min.css\";i:480;s:26:\"text-columns/style-rtl.css\";i:481;s:30:\"text-columns/style-rtl.min.css\";i:482;s:22:\"text-columns/style.css\";i:483;s:26:\"text-columns/style.min.css\";i:484;s:19:\"verse/style-rtl.css\";i:485;s:23:\"verse/style-rtl.min.css\";i:486;s:15:\"verse/style.css\";i:487;s:19:\"verse/style.min.css\";i:488;s:20:\"video/editor-rtl.css\";i:489;s:24:\"video/editor-rtl.min.css\";i:490;s:16:\"video/editor.css\";i:491;s:20:\"video/editor.min.css\";i:492;s:19:\"video/style-rtl.css\";i:493;s:23:\"video/style-rtl.min.css\";i:494;s:15:\"video/style.css\";i:495;s:19:\"video/style.min.css\";i:496;s:19:\"video/theme-rtl.css\";i:497;s:23:\"video/theme-rtl.min.css\";i:498;s:15:\"video/theme.css\";i:499;s:19:\"video/theme.min.css\";}}","yes"),
("411","flatsome_update_cache","a:2:{s:12:\"last_checked\";i:1702295540;s:7:\"version\";s:6:\"3.18.2\";}","yes"),
("431","allowedthemes","a:1:{s:14:\"flatsome-child\";b:1;}","no"),
("432","fl_has_child_theme","flatsome-child","yes"),
("434","theme_mods_flatsome-child","a:84:{i:0;b:0;s:17:\"flatsome_fallback\";i:1;s:20:\"topbar_elements_left\";a:1:{i:0;s:4:\"html\";}s:21:\"topbar_elements_right\";a:3:{i:0;s:7:\"nav-top\";i:1;s:10:\"newsletter\";i:2;s:6:\"social\";}s:20:\"header_elements_left\";a:2:{i:0;s:6:\"search\";i:1;s:3:\"nav\";}s:21:\"header_elements_right\";a:3:{i:0;s:7:\"account\";i:1;s:7:\"divider\";i:2;s:4:\"cart\";}s:27:\"header_elements_bottom_left\";a:0:{}s:29:\"header_elements_bottom_center\";a:0:{}s:28:\"header_elements_bottom_right\";a:0:{}s:27:\"header_mobile_elements_left\";a:1:{i:0;s:9:\"menu-icon\";}s:28:\"header_mobile_elements_right\";a:1:{i:0;s:4:\"cart\";}s:26:\"header_mobile_elements_top\";a:1:{i:0;s:4:\"html\";}s:14:\"mobile_sidebar\";a:7:{i:0;s:11:\"search-form\";i:1;s:3:\"nav\";i:2;s:7:\"account\";i:3;s:10:\"newsletter\";i:4;s:6:\"social\";i:5;s:6:\"html-2\";i:6;s:6:\"html-3\";}s:14:\"product_layout\";s:19:\"right-sidebar-small\";s:23:\"payment_icons_placement\";s:6:\"footer\";s:14:\"follow_twitter\";s:10:\"http://url\";s:15:\"follow_facebook\";s:10:\"http://url\";s:16:\"follow_instagram\";s:10:\"http://url\";s:12:\"follow_email\";s:10:\"your@email\";s:16:\"flatsome_version\";i:3;s:24:\"portfolio_archive_filter\";s:4:\"left\";s:13:\"type_headings\";a:2:{s:11:\"font-family\";s:4:\"Lato\";s:7:\"variant\";s:3:\"700\";}s:10:\"type_texts\";a:2:{s:11:\"font-family\";s:4:\"Lato\";s:7:\"variant\";s:7:\"regular\";}s:8:\"type_nav\";a:2:{s:11:\"font-family\";s:4:\"Lato\";s:7:\"variant\";s:3:\"700\";}s:8:\"type_alt\";a:2:{s:11:\"font-family\";s:14:\"Dancing Script\";s:7:\"variant\";s:7:\"regular\";}s:14:\"pages_template\";s:7:\"default\";s:11:\"site_loader\";s:0:\"\";s:19:\"flatsome_db_version\";s:6:\"3.17.7\";s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:68;s:6:\"footer\";i:67;s:11:\"top_bar_nav\";i:67;}s:7:\"backups\";N;s:9:\"smof_init\";s:31:\"Sat, 23 Sep 2023 14:45:32 +0000\";s:19:\"html_scripts_header\";s:0:\"\";s:19:\"html_scripts_footer\";s:0:\"\";s:23:\"html_scripts_after_body\";s:0:\"\";s:24:\"html_scripts_before_body\";s:0:\"\";s:15:\"html_custom_css\";s:0:\"\";s:22:\"html_custom_css_tablet\";s:0:\"\";s:22:\"html_custom_css_mobile\";s:0:\"\";s:17:\"perf_instant_page\";i:0;s:21:\"lazy_load_backgrounds\";i:1;s:16:\"lazy_load_images\";i:0;s:26:\"flatsome_disable_style_css\";i:0;s:13:\"disable_emoji\";i:0;s:16:\"disable_blockcss\";i:0;s:14:\"jquery_migrate\";i:0;s:17:\"site_loader_color\";s:5:\"light\";s:14:\"site_loader_bg\";s:0:\"\";s:11:\"live_search\";i:1;s:18:\"search_placeholder\";s:0:\"\";s:21:\"search_result_latency\";s:1:\"0\";s:13:\"search_result\";i:1;s:19:\"search_result_style\";s:6:\"slider\";s:24:\"search_products_order_by\";s:9:\"relevance\";s:13:\"search_by_sku\";i:0;s:21:\"search_by_product_tag\";i:0;s:19:\"instagram_lazy_load\";i:0;s:14:\"google_map_api\";s:0:\"\";s:16:\"maintenance_mode\";i:0;s:29:\"maintenance_mode_admin_notice\";i:1;s:21:\"maintenance_mode_page\";i:0;s:21:\"maintenance_mode_text\";s:24:\"Please check back soon..\";s:9:\"404_block\";i:0;s:8:\"swatches\";i:0;s:27:\"additional_variation_images\";i:0;s:16:\"ajax_add_to_cart\";i:0;s:15:\"disable_reviews\";i:0;s:27:\"product_gallery_woocommerce\";i:0;s:14:\"html_shop_page\";s:0:\"\";s:9:\"tab_title\";s:0:\"\";s:11:\"tab_content\";s:0:\"\";s:23:\"html_before_add_to_cart\";s:1:\" \";s:22:\"html_after_add_to_cart\";s:0:\"\";s:14:\"html_thank_you\";s:0:\"\";s:12:\"catalog_mode\";i:0;s:19:\"catalog_mode_prices\";i:0;s:23:\"catalog_mode_sale_badge\";i:0;s:19:\"catalog_mode_header\";s:0:\"\";s:20:\"catalog_mode_product\";s:0:\"\";s:21:\"catalog_mode_lightbox\";s:0:\"\";s:24:\"flatsome_infinite_scroll\";i:0;s:27:\"infinite_scroll_loader_type\";s:7:\"spinner\";s:26:\"infinite_scroll_loader_img\";s:0:\"\";s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1695569098;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:70:{i:0;s:7:\"pages-3\";i:1;s:7:\"pages-5\";i:2;s:7:\"pages-6\";i:3;s:7:\"pages-8\";i:4;s:10:\"calendar-3\";i:5;s:10:\"calendar-5\";i:6;s:10:\"archives-4\";i:7;s:10:\"archives-6\";i:8;s:8:\"search-4\";i:9;s:6:\"text-4\";i:10;s:12:\"categories-5\";i:11;s:12:\"categories-7\";i:12;s:14:\"recent-posts-4\";i:13;s:14:\"recent-posts-6\";i:14;s:14:\"recent-posts-8\";i:15;s:17:\"recent-comments-4\";i:16;s:11:\"tag_cloud-3\";i:17;s:11:\"tag_cloud-8\";i:18;s:10:\"nav_menu-3\";i:19;s:10:\"nav_menu-4\";i:20;s:25:\"woocommerce_widget_cart-3\";i:21;s:25:\"woocommerce_widget_cart-5\";i:22;s:33:\"woocommerce_layered_nav_filters-3\";i:23;s:33:\"woocommerce_layered_nav_filters-5\";i:24;s:33:\"woocommerce_layered_nav_filters-7\";i:25;s:33:\"woocommerce_layered_nav_filters-9\";i:26;s:25:\"woocommerce_layered_nav-3\";i:27;s:25:\"woocommerce_layered_nav-5\";i:28;s:25:\"woocommerce_layered_nav-7\";i:29;s:26:\"woocommerce_layered_nav-10\";i:30;s:26:\"woocommerce_price_filter-3\";i:31;s:26:\"woocommerce_price_filter-5\";i:32;s:26:\"woocommerce_price_filter-7\";i:33;s:27:\"woocommerce_price_filter-11\";i:34;s:32:\"woocommerce_product_categories-5\";i:35;s:32:\"woocommerce_product_categories-7\";i:36;s:32:\"woocommerce_product_categories-9\";i:37;s:33:\"woocommerce_product_categories-10\";i:38;s:33:\"woocommerce_product_categories-12\";i:39;s:31:\"woocommerce_product_tag_cloud-3\";i:40;s:31:\"woocommerce_product_tag_cloud-5\";i:41;s:31:\"woocommerce_product_tag_cloud-6\";i:42;s:31:\"woocommerce_product_tag_cloud-7\";i:43;s:22:\"woocommerce_products-3\";i:44;s:22:\"woocommerce_products-4\";i:45;s:22:\"woocommerce_products-5\";i:46;s:22:\"woocommerce_products-7\";i:47;s:22:\"woocommerce_products-9\";i:48;s:23:\"woocommerce_products-10\";i:49;s:27:\"woocommerce_rating_filter-2\";i:50;s:27:\"woocommerce_rating_filter-3\";i:51;s:28:\"woocommerce_recent_reviews-3\";i:52;s:38:\"woocommerce_recently_viewed_products-3\";i:53;s:38:\"woocommerce_recently_viewed_products-5\";i:54;s:38:\"woocommerce_recently_viewed_products-7\";i:55;s:32:\"woocommerce_top_rated_products-2\";i:56;s:21:\"null-instagram-feed-3\";i:57;s:21:\"null-instagram-feed-4\";i:58;s:23:\"flatsome_recent_posts-3\";i:59;s:23:\"flatsome_recent_posts-5\";i:60;s:23:\"flatsome_recent_posts-6\";i:61;s:23:\"flatsome_recent_posts-8\";i:62;s:23:\"flatsome_recent_posts-9\";i:63;s:24:\"flatsome_recent_posts-11\";i:64;s:24:\"flatsome_recent_posts-13\";i:65;s:24:\"flatsome_recent_posts-14\";i:66;s:24:\"flatsome_recent_posts-16\";i:67;s:15:\"upsell_widget-3\";i:68;s:15:\"upsell_widget-5\";i:69;s:15:\"upsell_widget-7\";}s:12:\"sidebar-main\";a:7:{i:0;s:7:\"text-13\";i:1;s:24:\"flatsome_recent_posts-17\";i:2;s:17:\"recent-comments-5\";i:3;s:11:\"tag_cloud-9\";i:4;s:13:\"categories-14\";i:5;s:10:\"archives-7\";i:6;s:21:\"null-instagram-feed-5\";}s:16:\"sidebar-footer-1\";a:4:{i:0;s:23:\"woocommerce_products-12\";i:1;s:23:\"woocommerce_products-11\";i:2;s:23:\"woocommerce_products-13\";i:3;s:32:\"woocommerce_top_rated_products-3\";}s:16:\"sidebar-footer-2\";a:4:{i:0;s:14:\"block_widget-2\";i:1;s:24:\"flatsome_recent_posts-18\";i:2;s:31:\"woocommerce_product_tag_cloud-8\";i:3;s:14:\"block_widget-3\";}s:12:\"shop-sidebar\";a:5:{i:0;s:34:\"woocommerce_layered_nav_filters-10\";i:1;s:33:\"woocommerce_product_categories-13\";i:2;s:26:\"woocommerce_layered_nav-11\";i:3;s:26:\"woocommerce_price_filter-9\";i:4;s:38:\"woocommerce_recently_viewed_products-8\";}s:15:\"product-sidebar\";a:0:{}}}}","yes"),
("437","wpcf7","a:2:{s:7:\"version\";s:5:\"5.8.4\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1695480339;s:7:\"version\";s:3:\"5.8\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}","yes"),
("438","nsl-version","3.1.11","yes"),
("439","widget_nextend_social_login","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("440","yit_recently_activated","a:1:{i:0;s:34:\"yith-woocommerce-wishlist/init.php\";}","yes"),
("441","yith_wcwl_wishlist_page_id","12","yes"),
("442","yith_wcwl_version","3.25.0","yes"),
("443","yith_wcwl_db_version","3.0.0","yes"),
("444","yith_wcwl_ajax_enable","yes","yes"),
("445","yith_wcwl_after_add_to_wishlist_behaviour","view","yes"),
("446","yith_wcwl_show_on_loop","no","yes"),
("447","yith_wcwl_loop_position","after_add_to_cart","yes"),
("448","yith_wcwl_button_position","shortcode","yes"),
("449","yith_wcwl_add_to_wishlist_text","افزودن به علاقه مندی ها","yes"),
("450","yith_wcwl_product_added_text","اضافه شد!","yes"),
("451","yith_wcwl_browse_wishlist_text","لیست علاقه مندی ها","yes"),
("452","yith_wcwl_already_in_wishlist_text","این محصول در لیست علاقه مندی ها شما قرار دارد!","yes"),
("453","yith_wcwl_add_to_wishlist_style","link","yes"),
("454","yith_wcwl_rounded_corners_radius","16","yes"),
("455","yith_wcwl_add_to_wishlist_icon","fa-heart-o","yes"),
("456","yith_wcwl_add_to_wishlist_custom_icon","","yes"),
("457","yith_wcwl_added_to_wishlist_icon","fa-heart","yes"),
("458","yith_wcwl_added_to_wishlist_custom_icon","","yes"),
("459","yith_wcwl_custom_css","","yes"),
("460","yith_wcwl_variation_show","","yes"),
("461","yith_wcwl_price_show","yes","yes"),
("462","yith_wcwl_stock_show","yes","yes"),
("463","yith_wcwl_show_dateadded","","yes"),
("464","yith_wcwl_add_to_cart_show","yes","yes"),
("465","yith_wcwl_show_remove","yes","yes"),
("466","yith_wcwl_repeat_remove_button","","yes"),
("467","yith_wcwl_redirect_cart","no","yes"),
("468","yith_wcwl_remove_after_add_to_cart","yes","yes"),
("469","yith_wcwl_enable_share","yes","yes"),
("470","yith_wcwl_share_fb","yes","yes"),
("471","yith_wcwl_share_twitter","yes","yes"),
("472","yith_wcwl_share_pinterest","yes","yes"),
("473","yith_wcwl_share_email","yes","yes"),
("474","yith_wcwl_share_whatsapp","yes","yes"),
("475","yith_wcwl_share_url","no","yes"),
("476","yith_wcwl_socials_title","لیست علاقه مندی های من در پیشنمایش قالب فلت سام | پوسته Flatsome","yes"),
("477","yith_wcwl_socials_text","","yes"),
("478","yith_wcwl_socials_image_url","","yes"),
("479","yith_wcwl_wishlist_title","لیست علاقه مندی های من","yes"),
("480","yith_wcwl_add_to_cart_text","افزودن به سبد خرید","yes"),
("481","yith_wcwl_add_to_cart_style","link","yes"),
("482","yith_wcwl_add_to_cart_rounded_corners_radius","16","yes"),
("483","yith_wcwl_add_to_cart_icon","fa-shopping-cart","yes"),
("484","yith_wcwl_add_to_cart_custom_icon","","yes"),
("485","yith_wcwl_color_headers_background","#F4F4F4","yes"),
("486","yith_wcwl_fb_button_icon","fa-facebook","yes"),
("487","yith_wcwl_fb_button_custom_icon","","yes"),
("488","yith_wcwl_tw_button_icon","fa-twitter","yes"),
("489","yith_wcwl_tw_button_custom_icon","","yes"),
("490","yith_wcwl_pr_button_icon","fa-pinterest","yes"),
("491","yith_wcwl_pr_button_custom_icon","","yes"),
("492","yith_wcwl_em_button_icon","fa-envelope-o","yes"),
("493","yith_wcwl_em_button_custom_icon","","yes"),
("494","yith_wcwl_wa_button_icon","fa-whatsapp","yes"),
("495","yith_wcwl_wa_button_custom_icon","","yes"),
("496","yit_plugin_fw_panel_wc_default_options_set","a:1:{s:15:\"yith_wcwl_panel\";b:1;}","yes"),
("500","_transient_product_query-transient-version","1702283851","yes"),
("501","wp_calendar_block_has_published_posts","1","yes"),
("526","widget_null-instagram-feed","a:4:{i:3;a:0:{}i:4;a:6:{s:5:\"title\";s:9:\"Instagram\";s:8:\"username\";s:21:\"beautifuldestinations\";s:6:\"number\";s:2:\"10\";s:4:\"size\";s:5:\"large\";s:6:\"target\";s:5:\"_self\";s:4:\"link\";s:10:\"Follow Me!\";}i:5;a:6:{s:5:\"title\";s:9:\"Instagram\";s:8:\"username\";s:7:\"topshop\";s:6:\"number\";s:1:\"6\";s:4:\"size\";s:9:\"thumbnail\";s:6:\"target\";s:5:\"_self\";s:4:\"link\";s:9:\"Follow us\";}s:12:\"_multiwidget\";i:1;}","yes"),
("532","envato_setup_complete","1695480665","yes"),
("535","kirki_downloaded_font_files","a:7:{s:68:\"https://fonts.gstatic.com/s/lato/v24/S6uyw4BMUTPHjxAwWCWtFCfQ7A.woff\";s:89:\"/home/themesam/public_html/flatsome/wp-content/fonts/lato/S6uyw4BMUTPHjxAwWCWtFCfQ7A.woff\";s:65:\"https://fonts.gstatic.com/s/lato/v24/S6uyw4BMUTPHjx4wWCWtFCc.woff\";s:86:\"/home/themesam/public_html/flatsome/wp-content/fonts/lato/S6uyw4BMUTPHjx4wWCWtFCc.woff\";s:72:\"https://fonts.gstatic.com/s/lato/v24/S6u9w4BMUTPHh6UVSwaPHw3q5d0N7w.woff\";s:93:\"/home/themesam/public_html/flatsome/wp-content/fonts/lato/S6u9w4BMUTPHh6UVSwaPHw3q5d0N7w.woff\";s:69:\"https://fonts.gstatic.com/s/lato/v24/S6u9w4BMUTPHh6UVSwiPHw3q5d0.woff\";s:90:\"/home/themesam/public_html/flatsome/wp-content/fonts/lato/S6u9w4BMUTPHh6UVSwiPHw3q5d0.woff\";s:110:\"https://fonts.gstatic.com/s/dancingscript/v25/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7BMSo3Rep6hNX6pmRMjLo.woff\";s:132:\"/home/themesam/public_html/flatsome/wp-content/fonts/dancing-script/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7BMSo3Rep6hNX6pmRMjLo.woff\";s:110:\"https://fonts.gstatic.com/s/dancingscript/v25/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7BMSo3ROp6hNX6pmRMjLo.woff\";s:132:\"/home/themesam/public_html/flatsome/wp-content/fonts/dancing-script/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7BMSo3ROp6hNX6pmRMjLo.woff\";s:107:\"https://fonts.gstatic.com/s/dancingscript/v25/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7BMSo3Sup6hNX6pmRM.woff\";s:129:\"/home/themesam/public_html/flatsome/wp-content/fonts/dancing-script/If2cXTr6YS-zF4S-kcSWSVi_sxjsohD9F50Ruu7BMSo3Sup6hNX6pmRM.woff\";}","yes"),
("536","_transient_product-transient-version","1698789138","yes"),
("600","_transient_health-check-site-status-result","{\"good\":17,\"recommended\":4,\"critical\":3}","yes"),
("642","_transient__flatsome_activation_redirect","1","yes"),
("766","category_children","a:0:{}","yes"),
("783","featured_item_category_children","a:0:{}","yes"),
("975","flatsome_wup_purchase_code","ZqihUGpp-MjNr-oKco-hRit-PbJXLeLwwAqW","yes"),
("976","flatsome_wup_supported_until","31.08.2077","yes"),
("977","flatsome_wup_buyer","Licensed","yes"),
("978","flatsome_wup_sold_at","1695671719","yes"),
("1033","flatsome_wupdates","a:2:{s:6:\"errors\";a:0:{}s:11:\"show_notice\";b:0;}","yes"),
("3556","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:17:\"test@samandon.com\";s:7:\"version\";s:5:\"6.4.2\";s:9:\"timestamp\";i:1701921436;}","no"),
("3684","woocommerce_feature_marketplace_enabled","yes","yes"),
("3692","wc_remote_inbox_notifications_wca_updated","","no"),
("4846","auto_update_plugins","a:5:{i:0;s:53:\"nextend-facebook-connect/nextend-facebook-connect.php\";i:1;s:34:\"yith-woocommerce-wishlist/init.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:27:\"woocommerce/woocommerce.php\";i:4;s:33:\"classic-editor/classic-editor.php\";}","no"),
("4871","woocommerce_attribute_lookup_enabled","yes","yes"),
("4892","_transient_orders-transient-version","1697836939","yes"),
("4912","woocommerce_task_list_reminder_bar_hidden","yes","yes"),
("5276","woocommerce_bacs_settings","a:11:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:36:\"انتقال مستقیم بانکی\";s:11:\"description\";s:325:\"پرداخت خود را مستقیما به حساب بانکی ما واریز کنید.خواهشمندیم شماره سفارش خود را بعنوان کد ارجاع پرداخت استفاده کنید.سفارش شما تا زمانی که وجوه به حساب ما وارد نشود ارسال نخواهد شد.\";s:12:\"instructions\";s:0:\"\";s:15:\"account_details\";s:0:\"\";s:12:\"account_name\";s:0:\"\";s:14:\"account_number\";s:0:\"\";s:9:\"sort_code\";s:0:\"\";s:9:\"bank_name\";s:0:\"\";s:4:\"iban\";s:0:\"\";s:3:\"bic\";s:0:\"\";}","yes"),
("5277","woocommerce_cheque_settings","a:4:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:22:\"پرداخت با چک\";s:11:\"description\";s:189:\"لطفا چک خود را به نام فروشگاه، خیابان فروشگاه، شهر فروشگاه، ایالت/کشور فروشگاه، کدپستی فروشگاه بفرستید.\";s:12:\"instructions\";s:0:\"\";}","yes"),
("5278","woocommerce_cod_settings","a:6:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:36:\"پرداخت هنگام دریافت\";s:11:\"description\";s:42:\"پرداخت نقدی پس از تحویل\";s:12:\"instructions\";s:42:\"پرداخت نقدی پس از تحویل\";s:18:\"enable_for_methods\";a:0:{}s:18:\"enable_for_virtual\";s:3:\"yes\";}","yes"),
("5279","woocommerce_gateway_order","a:3:{s:4:\"bacs\";i:0;s:6:\"cheque\";i:1;s:3:\"cod\";i:2;}","yes"),
("5732","wpp_settings","a:17:{s:10:\"admin_lang\";s:7:\"disable\";s:9:\"user_lang\";s:7:\"disable\";s:12:\"persian_date\";s:7:\"disable\";s:20:\"disable_widget_block\";s:7:\"disable\";s:12:\"submenu_move\";s:7:\"disable\";s:8:\"dev_mode\";s:7:\"disable\";s:12:\"enable_fonts\";s:7:\"disable\";s:10:\"conv_title\";s:7:\"disable\";s:13:\"conv_contents\";s:7:\"disable\";s:12:\"conv_excerpt\";s:7:\"disable\";s:13:\"conv_comments\";s:7:\"disable\";s:18:\"conv_comment_count\";s:7:\"disable\";s:10:\"conv_dates\";s:7:\"disable\";s:9:\"conv_cats\";s:7:\"disable\";s:11:\"conv_arabic\";s:7:\"disable\";s:15:\"conv_permalinks\";s:7:\"disable\";s:11:\"news_source\";s:5:\"parsi\";}","yes"),
("5733","widget_parsidate_archive","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("5734","widget_parsidate_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("5740","persian_woocommerce_translates","a:0:{}","yes"),
("5743","PW_Options","a:6:{s:24:\"enable_jalali_datepicker\";s:3:\"yes\";s:21:\"super_admin_boost_woo\";s:2:\"no\";s:27:\"super_admin_boost_dashboard\";s:2:\"no\";s:24:\"super_admin_disable_core\";s:2:\"no\";s:27:\"super_admin_disable_plugins\";s:2:\"no\";s:26:\"super_admin_disable_themes\";s:2:\"no\";}","yes"),
("5748","new_admin_email","test@samandon.com","yes"),
("5752","pw_dismiss_notice_pws","1713388858","yes"),
("5753","pw_dismiss_notice_all","1697923258","yes"),
("5780","woocommerce_admin_last_orders_milestone","1","yes"),
("5881","action_scheduler_migration_status","complete","yes"),
("6458","woocommerce_sales_record_date","2023-10-20","yes"),
("6459","woocommerce_sales_record_amount","2095000","yes"),
("7354","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes"),
("8198","product_cat_children","a:3:{i:23;a:1:{i:0;i:33;}i:57;a:2:{i:0;i:58;i:1;i:59;}i:61;a:2:{i:0;i:62;i:1;i:110;}}","yes"),
("9132","wp_attachment_pages_enabled","1","yes"),
("9133","db_upgraded","","yes"),
("9287","_transient_timeout_wc_term_counts","1704887716","no"),
("9288","_transient_wc_term_counts","a:44:{i:59;s:1:\"4\";i:33;s:1:\"7\";i:60;s:1:\"5\";i:58;s:1:\"2\";i:61;s:2:\"12\";i:24;s:1:\"9\";i:29;s:1:\"7\";i:46;s:1:\"6\";i:34;s:1:\"8\";i:23;s:1:\"7\";i:57;s:1:\"6\";i:110;s:1:\"5\";i:62;s:1:\"7\";i:118;s:1:\"3\";i:116;s:1:\"4\";i:131;s:1:\"2\";i:139;s:1:\"1\";i:134;s:1:\"5\";i:140;s:1:\"1\";i:15;s:1:\"0\";i:36;s:1:\"0\";i:160;s:1:\"1\";i:161;s:1:\"1\";i:136;s:1:\"1\";i:135;s:1:\"1\";i:112;s:2:\"13\";i:157;s:1:\"2\";i:158;s:1:\"2\";i:155;s:1:\"7\";i:130;s:1:\"1\";i:129;s:1:\"1\";i:138;s:1:\"3\";i:137;s:1:\"1\";i:115;s:1:\"1\";i:117;s:1:\"1\";i:113;s:1:\"2\";i:124;s:1:\"1\";i:127;s:1:\"1\";i:126;s:1:\"1\";i:128;s:1:\"2\";i:154;s:1:\"2\";i:111;s:1:\"1\";i:159;s:1:\"1\";i:156;s:1:\"3\";}","no"),
("9321","_transient_wc_attribute_taxonomies","a:4:{i:0;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"4\";s:14:\"attribute_name\";s:6:\"number\";s:15:\"attribute_label\";s:10:\"شماره\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}i:1;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"3\";s:14:\"attribute_name\";s:16:\"number-of-nights\";s:15:\"attribute_label\";s:15:\"تعداد شب\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}i:2;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"2\";s:14:\"attribute_name\";s:15:\"number-of-weeks\";s:15:\"attribute_label\";s:19:\"تعداد هفته\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}i:3;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"1\";s:14:\"attribute_name\";s:6:\"رنگ\";s:15:\"attribute_label\";s:6:\"رنگ\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}}","yes"),
("9324","_transient_timeout_woocommerce_admin_remote_inbox_notifications_specs","1702822941","no"),
("9325","_transient_woocommerce_admin_remote_inbox_notifications_specs","a:1:{s:5:\"fa_IR\";a:62:{s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:261:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store’s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:110:\"https://woo.com/products/wayflyer/?utm_source=inbox_note&utm_medium=product&utm_campaign=wayflyer_bnpl_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:202:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woo.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:127:\"https://woo.com/woocommerce-shipping/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_shipping_mobile_app_usps_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:251:\"WooCommerce Shipping & Tax helps get your store \"ready to sell\" as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:17:25\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:459:\"That’s huge! You’re well on your way to building a successful online store — now it’s time to think about how you’ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woo.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:122:\"https://woo.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:177:\"It’s crucial to get your store’s checkout as smooth as possible to avoid losing sales. Let’s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:136:\"https://woo.com/posts/optimizing-woocommerce-checkout?utm_source=inbox_note&utm_medium=product&utm_campaign=optimizing-the-checkout-flow\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:49\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Payments setup - let us know what you think\";s:7:\"content\";s:146:\"Congrats on enabling WooCommerce Payments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:39:\"https://automattic.survey.fm/wc-pay-new\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:13\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:50\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:114:\"https://woo.com/products/google-listings-and-ads?utm_source=inbox_note&utm_medium=product&utm_campaign=get-started\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:722:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site’s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woo.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woo.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:30:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:31:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:434:\"Heads up! There’s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woo.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:33:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:350:\"Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br /><br />Start using our <a href=\"https://woo.com/products/woocommerce-paypal-payments/\" target=\"_blank\">latest PayPal today</a> to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:34:30\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:574:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br /><br />Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br /><br />For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:129:\"https://woo.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:59:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:38;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}i:39;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.5.10\";}i:40;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.7\";}i:41;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.3\";}i:42;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.3\";}i:43;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.5\";}i:44;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.4\";}i:45;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.4\";}i:46;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.5\";}i:47;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.6\";}i:48;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.4\";}i:49;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.5\";}i:50;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.5\";}i:51;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.4\";}i:52;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:53;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.5\";}i:54;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.3\";}i:55;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:56;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.5\";}i:57;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.3\";}i:58;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.4\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:129:\"https://woo.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:32:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:42\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:129:\"https://woo.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:18\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:129:\"https://woo.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:54\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"We’re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:136:\"We’d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:37:30\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}s:42:\"woocommerce-core-paypal-march-2022-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:383:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy PayPal Standard security updates for stores running WooCommerce (version 3.5 to 6.3). It’s recommended to disable PayPal Standard, and use <a href=\"https://woo.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal Payments</a> to accept PayPal.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-core-paypal-march-2022-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:44:57\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"5.5\";}i:1;a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}}}}}}}s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:237:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy security updates related to PayPal Standard payment gateway for stores running WooCommerce (version 3.5 to 6.3).\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:45:04\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}s:24:\"pinterest_03_2022_update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"pinterest_03_2022_update\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"Your Pinterest for WooCommerce plugin is out of date!\";s:7:\"content\";s:262:\"Update to the latest version of Pinterest for WooCommerce to continue using this plugin and keep your store connected with Pinterest. To update, visit <strong>Plugins &gt; Installed Plugins</strong>, and click on “update now” under Pinterest for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"pinterest_03_2022_update\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"Update Instructions\";}}s:3:\"url\";s:140:\"https://woo.com/document/pinterest-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=pinterest_03_2022_update#section-3\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-23 00:00:39\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"pinterest-for-woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"1.0.8\";}}}s:33:\"store_setup_survey_survey_q2_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:33:\"store_setup_survey_survey_q2_2022\";s:4:\"type\";s:6:\"survey\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:30:\"How is your store setup going?\";s:7:\"content\";s:232:\"Our goal is to make sure you have all the right tools to start setting up your store in the smoothest way possible.\r\nWe’d love to know if we hit our mark and how we can improve. To collect your thoughts, we made a 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:53:\"store_setup_survey_survey_q2_2022_share_your_thoughts\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Tell us how it’s going\";}}s:3:\"url\";s:52:\"https://automattic.survey.fm/store-setup-survey-2022\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-05-09 08:42:10\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:7;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:9;}}}s:47:\"woocommerce-payments-august-2022-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-payments-august-2022-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:51:\"Action required: Please update WooCommerce Payments\";s:7:\"content\";s:213:\"An updated secure version of WooCommerce Payments is available – please ensure that you’re using the latest patch version. For more information on what action you need to take, please review the article below.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Find out more\";}}s:3:\"url\";s:96:\"https://developer.woocommerce.com/2022/08/09/woocommerce-payments-3-9-4-4-5-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:9:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-08-09 14:44:17\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"3.9\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"4.5.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.1\";}}}s:46:\"woocommerce-payments-august-2022-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-payments-august-2022-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:51:\"WooCommerce Payments has been automatically updated\";s:7:\"content\";s:265:\"You’re now running the latest secure version of WooCommerce Payments. We’ve worked with the WordPress Plugins team to deploy a security update to stores running WooCommerce Payments (version 3.9 to 4.5). For further information, please review the article below.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Find out more\";}}s:3:\"url\";s:96:\"https://developer.woocommerce.com/2022/08/09/woocommerce-payments-3-9-4-4-5-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-08-09 14:41:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:47:\"woocommerce-payments-august-2022-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.1\";}}}}}s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:58:\"Security vulnerability patched in WooCommerce Eway Gateway\";s:7:\"content\";s:323:\"In response to a potential vulnerability identified in WooCommerce Eway Gateway versions 3.1.0 to 3.5.0, we’ve worked to deploy security fixes and have released an updated version.\r\nNo external exploits have been detected, but we recommend you update to your latest supported version 3.1.26, 3.2.3, 3.3.1, 3.4.6, or 3.5.1\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:62:\"needs-update-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:63:\"needs-update-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.1.26\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"3.5.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"3.1.0\";}}}s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Eway Gateway has been automatically updated\";s:7:\"content\";s:280:\"Your store is now running the latest secure version of WooCommerce Eway Gateway. We worked with the WordPress Plugins team to deploy a software update to stores running WooCommerce Eway Gateway (versions 3.1.0 to 3.5.0) in response to a security vulnerability that was discovered.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"updated-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"See all updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"updated-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:5:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.1.26\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}}}}}s:31:\"ecomm-wc-navigation-survey-2023\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"ecomm-wc-navigation-survey-2023\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:39:\"Navigating WooCommerce on WordPress.com\";s:7:\"content\";s:166:\"We are improving the WooCommerce navigation on WordPress.com and would love your help to make it better! Please share your experience with us in this 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:32:\"share-navigation-survey-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/new-ecommerce-plan-navigation\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-01-16 09:53:44\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:12:\"is_ecommerce\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:180;}}}s:39:\"woopay-beta-merchantrecruitment-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"woopay-beta-merchantrecruitment-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:319:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> —and we’re inviting you to be one of the first to try it. \r\n<br><br>\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br><br>\r\n<b>Get started in seconds.</b>\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:48:\"woopay-beta-merchantrecruitment-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:147:\"https://woo.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:27\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:42:\"woocommerce-wcpay-march-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-wcpay-march-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:57:\"Action required: Security update for WooCommerce Payments\";s:7:\"content\";s:296:\"<strong>Your store requires a security update for WooCommerce Payments</strong>. Please update to the latest version of WooCommerce Payments immediately to address a potential vulnerability discovered on March 22. For more information on how to update, visit this WooCommerce Developer Blog Post.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:49:\"woocommerce-wcpay-march-2023-update-needed-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"See Blog Post\";}}s:3:\"url\";s:122:\"https://developer.woocommerce.com/2023/03/23/critical-vulnerability-detected-in-woocommerce-payments-what-you-need-to-know\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"woocommerce-wcpay-march-2023-update-needed-dismiss-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:11:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-03-22 20:25:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.8.0\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.6.1\";}}}s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:52:\"Accept in-person contactless payments on your iPhone\";s:7:\"content\";s:230:\"Tap to Pay on iPhone and WooCommerce Payments is quick, secure, and simple to set up — no extra terminals or card readers are needed. Accept contactless debit and credit cards, Apple Pay, and other NFC digital wallets in person.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:20:\"Simplify my payments\";}}s:3:\"url\";s:135:\"https://woo.com/products/woocommerce-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=tap_to_pay_iphone_q2_2023_no_wcpay\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-03 23:59:47\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce Pre-Orders extension\";s:7:\"content\";s:220:\"<strong>Your store requires a security update for the WooCommerce Pre-Orders extension</strong>. Please update the WooCommerce Pre-Orders extension immediately to address a potential vulnerability discovered on April 11.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:18:\"extension-settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-12 22:16:37\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:22:\"woocommerce-pre-orders\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.0.0\";}}}s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:321:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> — and you’re invited to try it. \r\n<br /><br />\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br /><br />\r\n<b>Update WooCommerce Payments</b> to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:52:\"woopay-beta-merchantrecruitment-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"woopay-beta-merchantrecruitment-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:361:\"Thanks for previously trying WooPay, the<b> express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>. No action is required on your part.\r\n<br /><br />\r\nYou can now <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Documentation\";}}s:3:\"url\";s:170:\"https://woo.com/document/woopay-merchant-documentation/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:23\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:44:\"woopay-beta-existingmerchants-update-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woopay-beta-existingmerchants-update-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:368:\"Thanks for previously trying WooPay, the <b>express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>.\r\n<br /><br />\r\n\r\nUpdate to the latest WooCommerce Payments version to <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:50:\"woopay-beta-existingmerchants-update-WCPay-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woopay-beta-merchantrecruitment-short-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:64:\"woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:153:\"https://woo.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:36\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:20\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTA\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTA\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test A\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:159:\"https://woo.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 00:01:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTB\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTB\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTB\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test B\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:159:\"https://woo.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 20:58:43\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTC\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTC\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTC\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test C\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:159:\"https://woo.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 21:03:33\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTD\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTD\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTD\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test D\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:159:\"https://woo.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 21:32:09\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-activate-button-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:72:\"woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:161:\"https://woo.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:18:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:45:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:44:\"woocommerce-WCstripe-May-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woocommerce-WCstripe-May-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Action required: Security update of WooCommerce Stripe plugin\";s:7:\"content\";s:183:\"<strong>Your store requires a security update for the WooCommerce Stripe plugin</strong>. Please update the WooCommerce Stripe plugin immediately to address a potential vulnerability.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woocommerce-WCStripe-May-2023-updated-needed-Plugin-Settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:68:\"woocommerce-WCStripe-May-2023-updated-needed-Plugin-Settings-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-31 19:54:10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.4.1\";}}}s:47:\"woocommerce-WCPayments-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-WCPayments-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Security update of WooCommerce Payments\";s:7:\"content\";s:187:\"<strong>Your store requires a security update for the WooCommerce Payments plugin</strong>. Please update the WooCommerce Payments plugin immediately to address a potential vulnerability.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:63:\"woocommerce-WCPayments-June-2023-updated-needed-Plugin-Settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"woocommerce-WCPayments-June-2023-updated-needed-Dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:20:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-06 08:00:52\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"3.2.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.4\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.6.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.7.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.8.2\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.9.1\";}}}s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Action required: Security update of WooCommerce Subscriptions\";s:7:\"content\";s:197:\"<strong>Your store requires a security update for the WooCommerce Subscriptions plugin</strong>. Please update the WooCommerce Subscriptions plugin immediately to address a potential vulnerability.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:68:\"woocommerce-WCSubscriptions-June-2023-updated-needed-Plugin-Settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woocommerce-WCSubscriptions-June-2023-updated-needed-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-06 08:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"2.1.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.1.2\";}}}s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: Security update of WooCommerce Returns and Warranty Requests extension\";s:7:\"content\";s:270:\"<strong>Your store requires a security update for the Returns and Warranty Requests extension</strong>.  Please update to the latest version of the WooCommerce Returns and Warranty Requests extension immediately to address a potential vulnerability discovered on May 31.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-02 23:53:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-warranty\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.1.8\";}}}s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:65:\"Action required: Security update of WooCommerce One Page Checkout\";s:7:\"content\";s:232:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce One Page Checkout extension</strong>. The fix for this vulnerability was released for this extension on June 13th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-21 14:05:46\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:29:\"woocommerce-one-page-checkout\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.4.0\";}}}s:40:\"woocommerce-WCGC-July-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce GoCardless Extension\";s:7:\"content\";s:205:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce GoCardless extension</strong>. The fix for this vulnerability was released on July 4th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-04 15:36:07\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:30:\"woocommerce-gateway-gocardless\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.5.6\";}}}s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";s:4:\"type\";s:7:\"warning\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Scheduled FedEx API outage — July 2023\";s:7:\"content\";s:277:\"On July 16 there will be a full outage of the FedEx API from 04:00 to 08:00 AM UTC. Due to planned maintenance by FedEx, you\'ll be unable to provide FedEx shipping rates during this time. Follow the link below for more information and recommendations on how to minimize impact.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:117:\"https://woo.com/document/fedex/?utm_medium=product&utm_source=inbox_note&utm_campaign=learn-more#july-2023-api-outage\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-05 18:19:17\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-shipping-fedex\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-07-17 00:00:00\";}}}s:35:\"wcship-2023-07-hazmat-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wcship-2023-07-hazmat-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: USPS HAZMAT compliance update for WooCommerce Shipping & Tax extension\";s:7:\"content\";s:251:\"<strong>Your store requires an update for the WooCommerce Shipping extension</strong>. Please update to the latest version of the WooCommerce Shipping &amp; Tax extension immediately to ensure compliance with new USPS HAZMAT rules currently in effect.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"plugin-list\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:23:\"admin.php?page=wc-admin\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-11 20:26:59\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-services\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.3.0\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Action required: Security update for WooCommerce Stripe plugin\";s:7:\"content\";s:183:\"<strong>Your shop requires an important security update for the  WooCommerce Stripe plugin</strong>. The fix for this vulnerability was released on July 31. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.4.2\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}}}s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:44:\"Security update of WooCommerce Stripe plugin\";s:7:\"content\";s:144:\"<strong>Your store has been updated to the latest secure version of the WooCommerce Stripe plugin</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}s:46:\"woocommerce-WooPayments-Aug-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-WooPayments-Aug-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:78:\"Action required: Security update for WooPayments (WooCommerce Payments) plugin\";s:7:\"content\";s:201:\"<strong>Your shop requires an important security update for the WooPayments (WooCommerce Payments) extension</strong>. The fix for this vulnerability was released on July 31. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:46:\"woocommerce-WooPayments-Aug-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"2.8.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"6.2.1\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.6\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.5\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.4\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}}}}}}}s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:60:\"Security update of WooPayments (WooCommerce Payments) plugin\";s:7:\"content\";s:147:\"<strong>Your store has been updated to the more secure version of WooPayments (WooCommerce Payments)</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:13\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.6\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.5\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.4\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}}}}}s:24:\"avalara_q3-2023_noAvaTax\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"avalara_q3-2023_noAvaTax\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Automatically calculate VAT in real time\";s:7:\"content\";s:284:\"Take the effort out of determining tax rates and sell confidently across borders with automated tax management from Avalara AvaTax— including built-in VAT calculation when you sell into or across the EU and UK. Save time and stay compliant when you let Avalara do the heavy lifting.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"avalara_q3-2023_noAvaTax\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Automate my sales tax\";}}s:3:\"url\";s:123:\"https://woo.com/products/woocommerce-avatax/?utm_source=inbox_note&utm_medium=product&utm_campaign=avalara_q3-2023_noAvaTax\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-08 22:32:23\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-08-09 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-avatax\";}}}}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:30;}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:100;s:9:\"operation\";s:1:\">\";}}}s:38:\"woo-activation-survey-blockers-22AUG23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:38:\"woo-activation-survey-blockers-22AUG23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"How can we help you get that first sale?\";s:7:\"content\";s:211:\"Your feedback is vital. Please take a minute to share your experience of setting up your new store and whether anything is preventing you from making those first few sales. Together, we can make Woo even better!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:52:\"woo-activation-survey-blockers-survey-button-22AUG23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Take our short survey\";}}s:3:\"url\";s:54:\"https://woocommerce.survey.fm/getting-started-with-woo\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-22 15:54:58\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\"<=\";s:4:\"days\";i:30;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";i:0;}}}s:44:\"woocommerce-usermeta-Sept2023-productvendors\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:37:\"Your store requires a security update\";s:7:\"content\";s:339:\"<strong>Your shop needs an update to address a vulnerability in WooCommerce.</strong> The fix was released on Sept 15. Please update WooCommerce to the latest version immediately. <a href=\"https://developer.woocommerce.com/2023/09/16/woocommerce-vulnerability-reintroduced-from-7-0-1/\" />Read our developer update</a> for more information.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:11:\"plugins.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-09-20 00:50:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-product-vendors\";}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"8.1.1\";}}}s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Security update for WooCommerce Stripe Gateway\";s:7:\"content\";s:201:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce Stripe Gateway</strong>. The fix for this vulnerability was released on October 17. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:36:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-10-18 00:01:58\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.5.4\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.6\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.6.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.8.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.9.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.0.2\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.1.2\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.2.2\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.3.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.4.6\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.7.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.8.3\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.9.3\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.0.5\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.1.3\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.2.3\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.3.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.4.3\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.5.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.6.1\";}}}s:40:\"tap_to_pay_iphone_q4_2023_no_woopayments\";O:8:\"stdClass\":8:{s:4:\"slug\";s:40:\"tap_to_pay_iphone_q4_2023_no_woopayments\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:52:\"Accept in-person contactless payments on your iPhone\";s:7:\"content\";s:221:\"Tap to Pay on iPhone and WooPayments is quick, secure, and simple to set up — no extra terminals or card readers are needed. Accept contactless debit and credit cards, Apple Pay, and other NFC digital wallets in person.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"tap_to_pay_iphone_q4_2023_no_woopayments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:20:\"Simplify my payments\";}}s:3:\"url\";s:132:\"https://woo.com/products/woopayments/?utm_source=inbox_note&utm_medium=product&utm_campaign=tap_to_pay_iphone_q4_2023_no_woopayments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-12-05 18:48:20\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-12-17 23:59:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:10;s:9:\"operation\";s:1:\">\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:3;}}}s:42:\"tap_to_pay_iphone_q4_2023_with_woopayments\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"tap_to_pay_iphone_q4_2023_with_woopayments\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:57:\"New: accept in-person contactless payments on your iPhone\";s:7:\"content\";s:241:\"Tap to Pay on iPhone is quick, secure, and simple to set up in WooPayments — no extra terminals or card readers are needed. Accept contactless debit and credit cards, Apple Pay, and other NFC digital wallets in person in a few short steps!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"tap_to_pay_iphone_q4_2023_with_woopayments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Set up Tap to Pay on iPhone\";}}s:3:\"url\";s:171:\"https://woo.com/document/woopayments/in-person-payments/tap-to-pay-iphone/?utm_source=inbox_note&utm_medium=product&utm_campaign=tap_to_pay_iphone_q4_2023_with_woopayments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-12-05 18:48:25\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-12-17 23:59:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:10;s:9:\"operation\";s:1:\">\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:3;}}}s:29:\"amazon-mcf-reviews-2023-12-07\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"amazon-mcf-reviews-2023-12-07\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:36:\"Enjoying Amazon MCF for WooCommerce?\";s:7:\"content\";s:292:\"We\'re Never Settle, the developers behind Amazon MCF for WooCommerce, and would be deeply honored to have your review. Reviews help immensely as other users can learn how MCF can solve their needs too! Not happy or need help? Please reach out for support and we’d love to make things right!\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"amazon-mcf-review-button-2023-12-07\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Leave a review\";}}s:3:\"url\";s:153:\"https://woo.com/products/woocommerce-amazon-fulfillment/?review&utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-review-button-2023-12-07\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:36:\"amazon-mcf-support-button-2023-12-07\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Request support\";}}s:3:\"url\";s:134:\"https://woo.com/my-account/contact-support/?utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-support-button-2023-12-07\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-12-06 15:21:27\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:30:\"woocommerce-amazon-fulfillment\";}}}}}}","no");

INSERT IGNORE INTO `wp_options` VALUES 
("9326","_transient_timeout_woocommerce_admin_remote_free_extensions_specs","1702822940","no"),
("9327","_transient_woocommerce_admin_remote_free_extensions_specs","a:1:{s:5:\"fa_IR\";a:5:{s:10:\"obw/basics\";O:8:\"stdClass\":3:{s:3:\"key\";s:10:\"obw/basics\";s:5:\"title\";s:46:\"اصول اولیه را دریافت کنید\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"WooPayments\";s:11:\"description\";s:197:\"کارت‌های اعتباری و سایر روش‌های پرداخت محبوب را با <a href=\"https://woo.com/products/woocommerce-payments\" target=\"_blank\">WooPayments</a> بپذیرید\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"is_built_by_wc\";b:1;s:14:\"min_wp_version\";s:3:\"5.9\";s:3:\"key\";s:20:\"woocommerce-payments\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:31:\"حمل و نقل ووکامرس\";s:11:\"description\";s:131:\"چاپ برچسب های حمل و نقل با <a href=\"https://woo.com/products/shipping\" target=\"_blank\">WooCommerce Shipping</a>\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:13:\"product_types\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:5:\"count\";}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:5:\"value\";i:1;s:7:\"default\";a:0:{}s:9:\"operation\";s:2:\"!=\";}}i:1;a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:15:\"product_types.0\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:5:\"value\";s:9:\"downloads\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:2:\"!=\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:29:\"woocommerce-services:shipping\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"مالیات ووکامرس\";s:11:\"description\";s:150:\"با <a href=\"https://woo.com/products/tax\" target=\"_blank\">مالیات WooCommerce</a> مالیات بر فروش خودکار دریافت کنید\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:24:\"woocommerce-services:tax\";}i:3;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"جت پک\";s:11:\"description\";s:115:\"افزایش سرعت و امنیت با <a href=\"https://woo.com/products/jetpack\" target=\"_blank\">جت‌پک</a>\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:7:\"jetpack\";}}}}}s:14:\"is_built_by_wc\";b:0;s:14:\"min_wp_version\";s:3:\"6.0\";s:3:\"key\";s:7:\"jetpack\";}}}s:8:\"obw/grow\";O:8:\"stdClass\":3:{s:3:\"key\";s:8:\"obw/grow\";s:5:\"title\";s:42:\"فروشگاه خود را رشد دهید\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"میل‌پوئت\";s:11:\"description\";s:144:\"با <a href=\"https://woo.com/products/mailpoet\" target=\"_blank\">MailPoet</a> سطح ایمیل مارکتینگ خود را ارتقا دهید\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:8:\"mailpoet\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:8:\"mailpoet\";}i:1;O:8:\"stdClass\":8:{s:4:\"name\";s:21:\"Google Listings & Ads\";s:11:\"description\";s:134:\"هدایت فروش‌ها با <a href=\"https://woo.com/products/google-listings-and-ads\" target=\"_blank\">Google Listings and Ads</a>\";s:9:\"image_url\";s:86:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google-listings-and-ads\";}}}}}s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.4\";s:3:\"key\";s:23:\"google-listings-and-ads\";}i:2;O:8:\"stdClass\":7:{s:4:\"name\";s:38:\"پینترست برای ووکامرس\";s:11:\"description\";s:137:\"محصولات خود را در مقابل Pinners در جستجوی ایده ها و چیزهایی برای خرید قرار دهید.\";s:9:\"image_url\";s:89:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/pinterest.png\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.3\";s:3:\"key\";s:25:\"pinterest-for-woocommerce\";}i:3;O:8:\"stdClass\":7:{s:4:\"name\";s:36:\"فیسبوک برای ووکامرس\";s:11:\"description\";s:133:\"List products and create ads on Facebook and Instagram with <a href=\"https://woo.com/products/facebook/\">Facebook for WooCommerce</a>\";s:9:\"image_url\";s:88:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/facebook.png\";s:10:\"manage_url\";s:26:\"admin.php?page=wc-facebook\";s:10:\"is_visible\";b:0;s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:24:\"facebook-for-woocommerce\";}}}s:15:\"task-list/reach\";O:8:\"stdClass\":3:{s:3:\"key\";s:15:\"task-list/reach\";s:5:\"title\";s:41:\"با مشتریان تماس بگیرید\";s:7:\"plugins\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"میل‌پوئت\";s:11:\"description\";s:189:\"ایمیل‌های پیگیری خرید، خبرنامه‌ها و کمپین‌های تبلیغاتی را مستقیماً از داشبورد خود ایجاد و ارسال کنید.\";s:9:\"image_url\";s:88:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/mailpoet.svg\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:12:\"mailpoet:alt\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"Mailchimp\";s:11:\"description\";s:149:\"با Mailchimp کمپین‌های هدفمند ارسال، سبدهای خرید رها شده و موارد دیگر را بازیابی کنید.\";s:9:\"image_url\";s:89:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/mailchimp.svg\";s:10:\"manage_url\";s:36:\"admin.php?page=mailchimp-woocommerce\";s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:25:\"mailchimp-for-woocommerce\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"Klaviyo\";s:11:\"description\";s:217:\"با خودکارسازی بازاریابی ایمیلی و پیامکی هوشمند و تاثیرگذار و دیدگاه تلفیقی از تعاملات مشتری، مشتریان را رشد و حفظ کنید.\";s:9:\"image_url\";s:87:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/klaviyo.png\";s:10:\"manage_url\";s:31:\"admin.php?page=klaviyo_settings\";s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:7:\"klaviyo\";}}}s:14:\"task-list/grow\";O:8:\"stdClass\":3:{s:3:\"key\";s:14:\"task-list/grow\";s:5:\"title\";s:42:\"فروشگاه خود را رشد دهید\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"Google Listings & Ads\";s:11:\"description\";s:326:\"به خریداران بیشتری دسترسی پیدا کنید و فروش را برای فروشگاه خود افزایش دهید. با گوگل ادغام شوید تا محصولات خود را به صورت رایگان فهرست کنید و کمپین های تبلیغاتی پولی راه اندازی کنید.\";s:9:\"image_url\";s:86:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:27:\"google-listings-and-ads:alt\";}i:1;O:8:\"stdClass\":7:{s:4:\"name\";s:30:\"TikTok برای ووکامرس\";s:9:\"image_url\";s:86:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/tiktok.svg\";s:11:\"description\";s:203:\"با تبلیغ محصولات خود در TikTok به بیش از یک میلیارد کاربر فعال ماهانه در سراسر جهان، فروش آنلاین خود را افزایش دهید.\";s:10:\"manage_url\";s:21:\"admin.php?page=tiktok\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:40:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MY\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PH\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"VN\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TH\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"KR\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IL\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UA\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TR\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SA\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:19:\"tiktok-for-business\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:38:\"پینترست برای ووکامرس\";s:11:\"description\";s:293:\"محصولات خود را در مقابل کاربران پینترست که در جستجوی ایده‌ها و چیزهایی برای خرید هستند قرار دهید. با پینترست شروع کنید و کل کاتالوگ محصولات خود را قابل مرور کنید.\";s:9:\"image_url\";s:89:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/pinterest.png\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:29:\"pinterest-for-woocommerce:alt\";}i:3;O:8:\"stdClass\":7:{s:4:\"name\";s:36:\"فیسبوک برای ووکامرس\";s:11:\"description\";s:96:\"لیست محصولات و ایجاد تبلیغات در فیس بوک و اینستاگرام.\";s:9:\"image_url\";s:88:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/facebook.png\";s:10:\"manage_url\";s:26:\"admin.php?page=wc-facebook\";s:10:\"is_visible\";b:0;s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:28:\"facebook-for-woocommerce:alt\";}}}s:17:\"obw/core-profiler\";O:8:\"stdClass\":3:{s:3:\"key\";s:17:\"obw/core-profiler\";s:5:\"title\";s:42:\"فروشگاه خود را رشد دهید\";s:7:\"plugins\";a:8:{i:0;O:8:\"stdClass\":10:{s:4:\"name\";s:11:\"WooPayments\";s:11:\"description\";s:161:\"پرداخت ها را ایمن بپذیرید و فعالیت پرداخت را مستقیماً از داشبورد فروشگاه خود مدیریت کنید\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"is_built_by_wc\";b:1;s:14:\"min_wp_version\";s:3:\"5.9\";s:3:\"key\";s:20:\"woocommerce-payments\";s:5:\"label\";s:45:\"با WooPayments پول دریافت کنید\";s:9:\"image_url\";s:102:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo.svg\";s:15:\"learn_more_link\";s:45:\"https://woo.com/products/woocommerce-payments\";s:16:\"install_priority\";i:5;}i:1;O:8:\"stdClass\":9:{s:4:\"name\";s:31:\"حمل و نقل ووکامرس\";s:11:\"description\";s:158:\"برچسب های USPS و DHL را مستقیماً از داشبورد خود چاپ کنید و در هزینه حمل و نقل صرفه جویی کنید.\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:29:\"woocommerce-services:shipping\";s:5:\"label\";s:69:\"چاپ برچسب‌های حمل و نقل با WooCommerce Shipping\";s:9:\"image_url\";s:102:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo.svg\";s:15:\"learn_more_link\";s:36:\"https://woo.com/woocommerce-shipping\";s:16:\"install_priority\";i:3;}i:2;O:8:\"stdClass\":10:{s:4:\"name\";s:9:\"جت پک\";s:11:\"description\";s:216:\"در زمان تولید محتوا صرفه‌جویی کنید — نوشته‌ها و برگه‌های وبلاگ با کیفیت بالا را با استفاده از هوش مصنوعی داشته باشید.\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:0;s:14:\"min_wp_version\";s:3:\"6.0\";s:3:\"key\";s:7:\"jetpack\";s:5:\"label\";s:72:\"تولید محتوا را با Jetpack AI Assistant تقویت کنید\";s:9:\"image_url\";s:106:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-jetpack.svg\";s:15:\"learn_more_link\";s:32:\"https://woo.com/products/jetpack\";s:16:\"install_priority\";i:8;}i:3;O:8:\"stdClass\":10:{s:4:\"name\";s:38:\"پینترست برای ووکامرس\";s:11:\"description\";s:97:\"محصولات خود را در مقابل یک مخاطب بسیار فعال قرار دهید.\";s:9:\"image_url\";s:108:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-pinterest.svg\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.3\";s:3:\"key\";s:25:\"pinterest-for-woocommerce\";s:5:\"label\";s:77:\"محصولات خود را در پینترست به نمایش بگذارید\";s:15:\"learn_more_link\";s:50:\"https://woo.com/products/pinterest-for-woocommerce\";s:16:\"install_priority\";i:2;}i:4;O:8:\"stdClass\":10:{s:4:\"name\";s:17:\"میل‌پوئت\";s:11:\"description\";s:131:\"ایمیل‌های پیگیری خرید، خبرنامه‌ها و کمپین‌های تبلیغاتی را ارسال کنید.\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:8:\"mailpoet\";s:5:\"label\";s:51:\"با MailPoet به مشتریان خود برسید\";s:9:\"image_url\";s:107:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-mailpoet.svg\";s:15:\"learn_more_link\";s:33:\"https://woo.com/products/mailpoet\";s:16:\"install_priority\";i:7;}i:5;O:8:\"stdClass\":11:{s:4:\"name\";s:21:\"Google Listings & Ads\";s:11:\"description\";s:138:\"با listings and ads رایگان به میلیون‌ها خریدار فعال در سراسر گوگل دسترسی پیدا کنید.\";s:9:\"image_url\";s:105:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.4\";s:3:\"key\";s:23:\"google-listings-and-ads\";s:5:\"label\";s:64:\"با Google Listings & Ads، فروش را افزایش دهید\";s:15:\"learn_more_link\";s:48:\"https://woo.com/products/google-listings-and-ads\";s:16:\"install_priority\";i:6;}i:6;O:8:\"stdClass\":9:{s:4:\"name\";s:27:\"مالیات ووکامرس\";s:11:\"description\";s:172:\"به طور خودکار محاسبه کنید که چقدر مالیات بر فروش باید جمع‌آوری شود - بر اساس شهر، کشور یا ایالت.\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:24:\"woocommerce-services:tax\";s:5:\"label\";s:91:\"با WooCommerce Tax نرخ‌های مالیاتی را خودکار دریافت کنید\";s:9:\"image_url\";s:102:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo.svg\";s:15:\"learn_more_link\";s:28:\"https://woo.com/products/tax\";s:16:\"install_priority\";i:4;}i:7;O:8:\"stdClass\":10:{s:4:\"name\";s:30:\"TikTok برای ووکامرس\";s:9:\"image_url\";s:105:\"https://woo.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-tiktok.svg\";s:11:\"description\";s:138:\"کمپین‌های تبلیغاتی ایجاد کنید و به یک میلیارد کاربر جهانی دسترسی پیدا کنید.\";s:10:\"manage_url\";s:21:\"admin.php?page=tiktok\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:40:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MY\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PH\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"VN\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TH\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"KR\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IL\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UA\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TR\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SA\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:19:\"tiktok-for-business\";s:5:\"label\";s:77:\"در تیک‌تاک کمپین‌های تبلیغاتی ایجاد کنید\";s:15:\"learn_more_link\";s:47:\"https://woo.com/products/tiktok-for-woocommerce\";s:16:\"install_priority\";i:1;}}}}}","no"),
("9340","_transient_timeout_wc_shipping_method_count_legacy","1703945222","no"),
("9341","_transient_wc_shipping_method_count_legacy","a:2:{s:7:\"version\";s:10:\"1695479124\";s:5:\"value\";i:1;}","no"),
("9342","can_compress_scripts","0","yes"),
("9740","_transient_timeout_wc_product_children_172","1704205323","no"),
("9741","_transient_wc_product_children_172","a:2:{s:3:\"all\";a:10:{i:0;i:630;i:1;i:631;i:2;i:632;i:3;i:633;i:4;i:634;i:5;i:635;i:6;i:636;i:7;i:637;i:8;i:638;i:9;i:639;}s:7:\"visible\";a:10:{i:0;i:630;i:1;i:631;i:2;i:632;i:3;i:633;i:4;i:634;i:5;i:635;i:6;i:636;i:7;i:637;i:8;i:638;i:9;i:639;}}","no"),
("9742","_transient_timeout_wc_var_prices_172","1704205323","no"),
("9743","_transient_wc_var_prices_172","{\"version\":\"1698789138\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"630\":\"350000\",\"631\":\"360000\",\"632\":\"370000\",\"633\":\"380000\",\"634\":\"390000\",\"635\":\"400000\",\"636\":\"410000\",\"637\":\"420000\",\"638\":\"430000\",\"639\":\"440000\"},\"regular_price\":{\"630\":\"350000\",\"631\":\"360000\",\"632\":\"370000\",\"633\":\"380000\",\"634\":\"390000\",\"635\":\"400000\",\"636\":\"410000\",\"637\":\"420000\",\"638\":\"430000\",\"639\":\"440000\"},\"sale_price\":{\"630\":\"350000\",\"631\":\"360000\",\"632\":\"370000\",\"633\":\"380000\",\"634\":\"390000\",\"635\":\"400000\",\"636\":\"410000\",\"637\":\"420000\",\"638\":\"430000\",\"639\":\"440000\"}}}","no"),
("10350","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.4.2.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.4.2.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.4.2\";s:7:\"version\";s:5:\"6.4.2\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1702295543;s:15:\"version_checked\";s:5:\"6.4.2\";s:12:\"translations\";a:0:{}}","no"),
("10352","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1702300599;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:5:{s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.8.4\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.4.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.2\";}s:53:\"nextend-facebook-connect/nextend-facebook-connect.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"w.org/plugins/nextend-facebook-connect\";s:4:\"slug\";s:24:\"nextend-facebook-connect\";s:6:\"plugin\";s:53:\"nextend-facebook-connect/nextend-facebook-connect.php\";s:11:\"new_version\";s:6:\"3.1.11\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/nextend-facebook-connect/\";s:7:\"package\";s:74:\"https://downloads.wordpress.org/plugin/nextend-facebook-connect.3.1.11.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:69:\"https://ps.w.org/nextend-facebook-connect/assets/icon.svg?rev=1825061\";s:3:\"svg\";s:69:\"https://ps.w.org/nextend-facebook-connect/assets/icon.svg?rev=1825061\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/nextend-facebook-connect/assets/banner-1544x500.png?rev=2159749\";s:2:\"1x\";s:79:\"https://ps.w.org/nextend-facebook-connect/assets/banner-772x250.png?rev=2159749\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:27:\"woocommerce/woocommerce.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:6:\"plugin\";s:27:\"woocommerce/woocommerce.php\";s:11:\"new_version\";s:5:\"8.3.1\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/woocommerce/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/woocommerce/assets/icon-256x256.gif?rev=2869506\";s:2:\"1x\";s:64:\"https://ps.w.org/woocommerce/assets/icon-128x128.gif?rev=2869506\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3000842\";s:2:\"1x\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3000842\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.3\";}s:34:\"yith-woocommerce-wishlist/init.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"w.org/plugins/yith-woocommerce-wishlist\";s:4:\"slug\";s:25:\"yith-woocommerce-wishlist\";s:6:\"plugin\";s:34:\"yith-woocommerce-wishlist/init.php\";s:11:\"new_version\";s:6:\"3.27.0\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/yith-woocommerce-wishlist/\";s:7:\"package\";s:75:\"https://downloads.wordpress.org/plugin/yith-woocommerce-wishlist.3.27.0.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:78:\"https://ps.w.org/yith-woocommerce-wishlist/assets/icon-128x128.jpg?rev=2215573\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:81:\"https://ps.w.org/yith-woocommerce-wishlist/assets/banner-1544x500.jpg?rev=2209192\";s:2:\"1x\";s:80:\"https://ps.w.org/yith-woocommerce-wishlist/assets/banner-772x250.jpg?rev=2209192\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.2\";}}s:7:\"checked\";a:6:{s:33:\"classic-editor/classic-editor.php\";s:5:\"1.6.3\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.8.4\";s:33:\"duplicator-pro/duplicator-pro.php\";s:8:\"4.5.14.2\";s:53:\"nextend-facebook-connect/nextend-facebook-connect.php\";s:6:\"3.1.11\";s:27:\"woocommerce/woocommerce.php\";s:5:\"8.3.1\";s:34:\"yith-woocommerce-wishlist/init.php\";s:6:\"3.27.0\";}}","no"),
("10628","_transient_timeout_yith_wcwl_hidden_products","1704615005","no"),
("10629","_transient_yith_wcwl_hidden_products","a:0:{}","no"),
("10630","_transient_timeout_woocommerce_admin_payment_method_promotion_specs","1702627807","no"),
("10631","_transient_woocommerce_admin_payment_method_promotion_specs","a:1:{s:5:\"fa_IR\";a:2:{s:27:\"woocommerce_payments:woopay\";O:8:\"stdClass\":8:{s:2:\"id\";s:27:\"woocommerce_payments:woopay\";s:5:\"title\";s:20:\"WooCommerce Payments\";s:7:\"content\";s:393:\"Payments made simple — including WooPay, a new express checkout feature.<br/><br/>By using WooPayments you agree to the <a href=\"https://wordpress.com/tos/\" target=\"_blank\">Terms of Service</a> (including WooPay <a href=\"https://wordpress.com/tos/#more-woopay-specifically\" target=\"_blank\">merchant terms</a>) and <a href=\"https://automattic.com/privacy/\" target=\"_blank\">Privacy Policy</a>.\";s:5:\"image\";s:93:\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"8.1.0-dev\";s:8:\"operator\";s:2:\">=\";}}s:9:\"sub_title\";s:825:\"<img class=\"wcpay-visa-icon wcpay-icon\" src=\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/visa.svg\" alt=\"Visa\"><img class=\"wcpay-mastercard-icon wcpay-icon\" src=\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/mastercard.svg\" alt=\"Mastercard\"><img class=\"wcpay-amex-icon wcpay-icon\" src=\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/amex.svg\" alt=\"Amex\"><img class=\"wcpay-googlepay-icon wcpay-icon\" src=\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/googlepay.svg\" alt=\"Googlepay\"><img class=\"wcpay-applepay-icon wcpay-icon\" src=\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/applepay.svg\" alt=\"Applepay\">\";s:15:\"additional_info\";O:8:\"stdClass\":1:{s:18:\"experiment_version\";s:2:\"v2\";}}s:20:\"woocommerce_payments\";O:8:\"stdClass\":8:{s:2:\"id\";s:20:\"woocommerce_payments\";s:5:\"title\";s:20:\"WooCommerce Payments\";s:7:\"content\";s:369:\"Payments made simple, with no monthly fees – designed exclusively for WooCommerce stores. Accept credit cards, debit cards, and other popular payment methods.<br/><br/>By clicking “Install”, you agree to the <a href=\"https://wordpress.com/tos/\" target=\"_blank\">Terms of Service</a> and <a href=\"https://automattic.com/privacy/\" target=\"_blank\">Privacy policy</a>.\";s:5:\"image\";s:93:\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}}s:9:\"sub_title\";s:825:\"<img class=\"wcpay-visa-icon wcpay-icon\" src=\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/visa.svg\" alt=\"Visa\"><img class=\"wcpay-mastercard-icon wcpay-icon\" src=\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/mastercard.svg\" alt=\"Mastercard\"><img class=\"wcpay-amex-icon wcpay-icon\" src=\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/amex.svg\" alt=\"Amex\"><img class=\"wcpay-googlepay-icon wcpay-icon\" src=\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/googlepay.svg\" alt=\"Googlepay\"><img class=\"wcpay-applepay-icon wcpay-icon\" src=\"https://woo.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/applepay.svg\" alt=\"Applepay\">\";s:15:\"additional_info\";O:8:\"stdClass\":1:{s:18:\"experiment_version\";s:2:\"v2\";}}}}","no"),
("10632","_transient_timeout_wc_product_children_448","1704615012","no"),
("10633","_transient_wc_product_children_448","a:2:{s:3:\"all\";a:2:{i:0;i:449;i:1;i:450;}s:7:\"visible\";a:2:{i:0;i:449;i:1;i:450;}}","no"),
("10634","_transient_timeout_wc_var_prices_448","1704615012","no"),
("10635","_transient_wc_var_prices_448","{\"version\":\"1698789138\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"449\":\"350000\",\"450\":\"260000\"},\"regular_price\":{\"449\":\"350000\",\"450\":\"260000\"},\"sale_price\":{\"449\":\"350000\",\"450\":\"260000\"}}}","no"),
("10636","_transient_timeout_wc_product_children_437","1704615012","no"),
("10637","_transient_wc_product_children_437","a:2:{s:3:\"all\";a:2:{i:0;i:447;i:1;i:456;}s:7:\"visible\";a:2:{i:0;i:447;i:1;i:456;}}","no"),
("10638","_transient_timeout_wc_var_prices_437","1704615012","no"),
("10639","_transient_wc_var_prices_437","{\"version\":\"1698789138\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"447\":\"350000\",\"456\":\"330000\"},\"regular_price\":{\"447\":\"350000\",\"456\":\"330000\"},\"sale_price\":{\"447\":\"350000\",\"456\":\"330000\"}}}","no"),
("10684","_transient_timeout_woocommerce_blocks_asset_api_script_data","1704678444","no"),
("10685","_transient_woocommerce_blocks_asset_api_script_data","{\"script_data\":{\"build\\/wc-settings.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-settings.js\",\"version\":\"811714876abd43a87bd7\",\"dependencies\":[\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/wc-blocks-middleware.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-middleware.js\",\"version\":\"ca04183222edaf8a26be\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\"]},\"build\\/wc-blocks-data.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-data.js\",\"version\":\"44400df383376f8b7fe7\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"build\\/wc-blocks-vendors.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-vendors.js\",\"version\":\"e52cee08054e9f3ffe1d\",\"dependencies\":[\"wp-polyfill\"]},\"build\\/wc-blocks-registry.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-registry.js\",\"version\":\"e7d9da2af6eda520ea57\",\"dependencies\":[\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-polyfill\"]},\"build\\/wc-blocks.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks.js\",\"version\":\"ac61343ba386c5afa166\",\"dependencies\":[\"wp-blocks\",\"wp-compose\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/wc-blocks-shared-context.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-shared-context.js\",\"version\":\"20ec2364dc7f9fed72cb\",\"dependencies\":[\"wp-element\",\"wp-polyfill\"]},\"build\\/wc-blocks-shared-hocs.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-blocks-shared-hocs.js\",\"version\":\"e9b159d0b79d44581eed\",\"dependencies\":[\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"build\\/price-format.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/price-format.js\",\"version\":\"eb7a7398126f71912b09\",\"dependencies\":[\"wc-settings\",\"wp-polyfill\"]},\"build\\/blocks-checkout.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/blocks-checkout.js\",\"version\":\"36cac271dc32d663ff9b\",\"dependencies\":[\"lodash\",\"react\",\"react-dom\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"build\\/blocks-components.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/blocks-components.js\",\"version\":\"dcff128e74cd87c473f2\",\"dependencies\":[\"react\",\"wc-blocks-checkout\",\"wp-compose\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/active-filters.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/active-filters.js\",\"version\":\"b6e9eb3e0f960c24d528\",\"dependencies\":[\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/active-filters-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/active-filters-frontend.js\",\"version\":\"7f19935b45ec0abc002a\",\"dependencies\":[\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wp-data\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/all-products.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/all-products.js\",\"version\":\"c05b4f546fab76a9051a\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/all-products-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/all-products-frontend.js\",\"version\":\"e24250707c907b8c41b7\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/all-reviews.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/all-reviews.js\",\"version\":\"725ec7bbe34d892261d9\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/reviews-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/reviews-frontend.js\",\"version\":\"48f4e2a59ddf8a675ce0\",\"dependencies\":[\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-compose\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"build\\/attribute-filter.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/attribute-filter.js\",\"version\":\"f0d6ac9c7b1e1f55e2f1\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"build\\/attribute-filter-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/attribute-filter-frontend.js\",\"version\":\"f920c3b56ef5b551b1b3\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"build\\/breadcrumbs.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/breadcrumbs.js\",\"version\":\"6b45dded020303f67506\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/catalog-sorting.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/catalog-sorting.js\",\"version\":\"4391eb36f5cb037f64d3\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/legacy-template.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/legacy-template.js\",\"version\":\"7745f71e7318b0f01255\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/classic-shortcode.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/classic-shortcode.js\",\"version\":\"c713b514a992a9e664a4\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/customer-account.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/customer-account.js\",\"version\":\"ee155a26a7cc78f028c2\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/featured-category.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/featured-category.js\",\"version\":\"711c1faf465cb5effd56\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\"]},\"build\\/featured-product.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/featured-product.js\",\"version\":\"6db6e325a0711c102b7f\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\"]},\"build\\/filter-wrapper.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/filter-wrapper.js\",\"version\":\"b19921517c7b9147d2f4\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/filter-wrapper-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/filter-wrapper-frontend.js\",\"version\":\"d5947ab32f460fff899d\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\"]},\"build\\/handpicked-products.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/handpicked-products.js\",\"version\":\"1e3f000920b15a3e91fc\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/mini-cart.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart.js\",\"version\":\"4b72a71f1e0d037a371d\",\"dependencies\":[\"react\",\"wc-price-format\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/mini-cart-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-frontend.js\",\"version\":\"61e99d9cd2611bcf7267\",\"dependencies\":[\"wc-price-format\",\"wc-settings\",\"wp-api-fetch\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/store-notices.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/store-notices.js\",\"version\":\"38316b7a9eee1b7f1a6e\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/price-filter.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/price-filter.js\",\"version\":\"ec8ae11fcdb9b959892e\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/price-filter-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/price-filter-frontend.js\",\"version\":\"dd4e55aad706b6d82855\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-url\"]},\"build\\/product-add-to-cart.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-add-to-cart.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-add-to-cart-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-add-to-cart-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-best-sellers.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-best-sellers.js\",\"version\":\"5c11d140749a960416d6\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/product-button.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-button.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-button-interactivity-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-button-interactivity-frontend.js\",\"version\":\"13791a2a13bd09d17cdc\",\"dependencies\":[\"lodash\",\"wc-blocks-data-store\",\"wc-interactivity\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"build\\/product-categories.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-categories.js\",\"version\":\"5ad643e9636e7e993ffe\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\"]},\"build\\/product-category.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-category.js\",\"version\":\"9edc688d083a77d71c75\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/product-collection.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-collection.js\",\"version\":\"5fbe8b2630e60f0004f1\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/product-new.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-new.js\",\"version\":\"111fb1795b522aeec9a2\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/product-on-sale.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-on-sale.js\",\"version\":\"951afd2329ccd655925c\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/product-template.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-template.js\",\"version\":\"360717558cb56501fe69\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/product-query.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-query.js\",\"version\":\"b1fb9bec1006abd8ca00\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/product-query-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-query-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-results-count.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-results-count.js\",\"version\":\"13825f464c6c45d5afae\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/product-search.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-search.js\",\"version\":\"c4b9e7d6160ef89018bd\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/product-summary.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-summary.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-tag.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-tag.js\",\"version\":\"4d7388028f36ca8fcf09\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/product-title.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-title.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-title-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-title-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/product-top-rated.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/product-top-rated.js\",\"version\":\"cdcf2e54dd95a5c33334\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/products-by-attribute.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/products-by-attribute.js\",\"version\":\"a95f41882a3500ba3537\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"build\\/rating-filter.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/rating-filter.js\",\"version\":\"8cdf324c59f3341eab0b\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"build\\/reviews-by-category.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/reviews-by-category.js\",\"version\":\"b65caad230120481d78b\",\"dependencies\":[\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/reviews-by-product.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/reviews-by-product.js\",\"version\":\"8b7e33547559684a790c\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"build\\/single-product.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/single-product.js\",\"version\":\"42ed58e087043e17bf85\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-store-data\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/stock-filter.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/stock-filter.js\",\"version\":\"10519f8d8fd3e66a1827\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"build\\/stock-filter-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/stock-filter-frontend.js\",\"version\":\"e4069417fcbb0f97d59b\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"build\\/page-content-wrapper.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/page-content-wrapper.js\",\"version\":\"56bb47464c0ff5b7a604\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-status.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-status.js\",\"version\":\"f14c86bad8f5cf0da65a\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-summary.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-summary.js\",\"version\":\"f46fd23fcdbc82d84cbe\",\"dependencies\":[\"wc-price-format\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-date\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-totals.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-totals.js\",\"version\":\"e80e47bfcd02246ca77c\",\"dependencies\":[\"wc-price-format\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-totals-wrapper.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-totals-wrapper.js\",\"version\":\"e121effbe218d09adf50\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-downloads.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-downloads.js\",\"version\":\"8c8aa7f060e385c78076\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-downloads-wrapper.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-downloads-wrapper.js\",\"version\":\"2066976a0b58ca359f42\",\"dependencies\":[\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-billing-address.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-billing-address.js\",\"version\":\"fe9f414caddf75cfa681\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-shipping-address.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-shipping-address.js\",\"version\":\"59a5f6ef042b626de44a\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-billing-wrapper.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-billing-wrapper.js\",\"version\":\"547a513a64eb92dfa993\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-shipping-wrapper.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-shipping-wrapper.js\",\"version\":\"88815ce3d06c68e335b1\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/order-confirmation-additional-information.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/order-confirmation-additional-information.js\",\"version\":\"4e371b569d26db536166\",\"dependencies\":[\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-polyfill\",\"wp-primitives\"]},\"build\\/cart.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart.js\",\"version\":\"d442e3988df8ace1acd0\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-editor\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/wc-payment-method-cheque.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-payment-method-cheque.js\",\"version\":\"77fd104213f608200fcf\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/wc-payment-method-bacs.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-payment-method-bacs.js\",\"version\":\"5e2505172bd7b5886aaf\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/wc-payment-method-cod.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/wc-payment-method-cod.js\",\"version\":\"313cf2de9481109290e2\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\"]},\"build\\/cart-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-frontend.js\",\"version\":\"ccaa02b19a06f8bcd7c5\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-blocks\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/cart-blocks\\/cart-accepted-payment-methods-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-accepted-payment-methods-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-accepted-payment-methods-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-accepted-payment-methods-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-cross-sells-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-cross-sells-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-cross-sells-products-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-cross-sells-products-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-cross-sells-products-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-cross-sells-products-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-cross-sells-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-cross-sells-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-express-payment-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-express-payment-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-express-payment-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-express-payment-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-items-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-items-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-items-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-items-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-line-items-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-line-items-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-line-items-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-line-items-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-order-summary-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-order-summary-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-order-summary-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-order-summary-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-totals-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-totals-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-totals-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-totals-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/empty-cart-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/empty-cart-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/empty-cart-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/empty-cart-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/filled-cart-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/filled-cart-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/filled-cart-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/filled-cart-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-coupon-form-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-coupon-form-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-coupon-form-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-coupon-form-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-discount-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-discount-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-discount-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-discount-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-fee-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-fee-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-fee-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-fee-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-heading-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-heading-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-heading-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-heading-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-shipping-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-shipping-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-shipping-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-shipping-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-subtotal-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-subtotal-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-subtotal-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-subtotal-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-taxes-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-taxes-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/order-summary-taxes-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/order-summary-taxes-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/proceed-to-checkout-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/proceed-to-checkout-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/proceed-to-checkout-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/proceed-to-checkout-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-taxes-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-taxes-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-subtotal-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-subtotal-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/filled-cart-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/filled-cart-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/empty-cart-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/empty-cart-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-totals-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-totals-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-items-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-items-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-line-items-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-line-items-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-express-payment-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-express-payment-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/proceed-to-checkout-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/proceed-to-checkout-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-accepted-payment-methods-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-accepted-payment-methods-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-coupon-form-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-coupon-form-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-discount-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-discount-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-fee-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-fee-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-heading-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-heading-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-order-summary-shipping-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-order-summary-shipping-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-cross-sells-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-cross-sells-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-cross-sells-products-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-cross-sells-products-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout.js\",\"version\":\"a9fdc8d8792a40805ed6\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-editor\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/checkout-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-frontend.js\",\"version\":\"6e00ea8fc9060a4d0444\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/checkout-blocks\\/actions-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/actions-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/actions-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/actions-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/billing-address-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/billing-address-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/billing-address-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/billing-address-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/contact-information-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/contact-information-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/contact-information-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/contact-information-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/express-payment-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/express-payment-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/fields-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/fields-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/fields-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/fields-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-note-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-note-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-cart-items-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-cart-items-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-cart-items-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-cart-items-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-coupon-form-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-coupon-form-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-coupon-form-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-coupon-form-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-discount-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-discount-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-discount-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-discount-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-fee-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-fee-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-fee-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-fee-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-shipping-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-shipping-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-shipping-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-shipping-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-subtotal-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-subtotal-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-subtotal-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-subtotal-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-taxes-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-taxes-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/order-summary-taxes-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/order-summary-taxes-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/payment-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/payment-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/payment-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/payment-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/pickup-options-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/pickup-options-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/pickup-options-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/pickup-options-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-address-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-address-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-address-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-address-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-method-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-method-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-methods-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-methods-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-methods-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-methods-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/shipping-method-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/shipping-method-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/terms-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/terms-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/terms-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/terms-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/totals-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/totals-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-blocks\\/totals-style.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-blocks\\/totals-style.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/cart-blocks\\/cart-express-payment--checkout-blocks\\/express-payment-frontend.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/cart-blocks\\/cart-express-payment--checkout-blocks\\/express-payment-frontend.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-actions-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-actions-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-billing-address-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-billing-address-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-contact-information-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-contact-information-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-express-payment-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-express-payment-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-fields-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-fields-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-note-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-note-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-cart-items-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-cart-items-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-coupon-form-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-coupon-form-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-discount-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-discount-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-fee-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-fee-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-shipping-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-shipping-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-subtotal-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-subtotal-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-order-summary-taxes-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-order-summary-taxes-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-payment-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-payment-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-shipping-address-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-shipping-address-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-shipping-methods-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-shipping-methods-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-shipping-method-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-shipping-method-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-pickup-options-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-pickup-options-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-terms-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-terms-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/checkout-totals-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/checkout-totals-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-contents.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-contents.js\",\"version\":\"60d7c3a553a736a6130f\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wp-a11y\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"build\\/empty-mini-cart-contents-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/empty-mini-cart-contents-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/filled-mini-cart-contents-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/filled-mini-cart-contents-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-footer-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-footer-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-items-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-items-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-products-table-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-products-table-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-shopping-button-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-shopping-button-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-cart-button-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-cart-button-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-checkout-button-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-checkout-button-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-title-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-title-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-title-items-counter-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-title-items-counter-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]},\"build\\/mini-cart-title-label-block.js\":{\"src\":\"http:\\/\\/theme-samandon.ir\\/flatsome\\/wp-content\\/plugins\\/woocommerce\\/packages\\/woocommerce-blocks\\/build\\/mini-cart-title-label-block.js\",\"version\":\"11.4.9\",\"dependencies\":[]}},\"version\":\"11.4.9\",\"hash\":\"1f30642b53866fe76ee7afd19d4b59b9\"}","no"),
("10690","_site_transient_timeout_browser_f529a32073a22388a8370c39e9b93c86","1702691264","no"),
("10691","_site_transient_browser_f529a32073a22388a8370c39e9b93c86","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"119.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no"),
("10692","_site_transient_timeout_php_check_4e65496a675acbae70f7731b62fe9fd1","1702691265","no"),
("10693","_site_transient_php_check_4e65496a675acbae70f7731b62fe9fd1","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","no"),
("10748","_transient_timeout_wc_products_onsale","1704680637","no"),
("10749","_transient_wc_products_onsale","a:10:{i:0;i:174;i:1;i:183;i:2;i:187;i:3;i:188;i:4;i:206;i:5;i:207;i:6;i:213;i:7;i:215;i:8;i:216;i:9;i:221;}","no"),
("10771","secret_key","XD0Ow[JC0Myd=LaD@>YK_|MOk2;eu>f]Z,mI#,o;6lzTYbz uuR_UBw7T_|+qYOY","no"),
("10831","_transient_timeout_wc_product_loop_d436802f2c160df9b596c8ec7767cc30","1704685697","no"),
("10832","_transient_wc_product_loop_d436802f2c160df9b596c8ec7767cc30","a:2:{s:7:\"version\";s:10:\"1702086466\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:12:{i:0;i:595;i:1;i:592;i:2;i:588;i:3;i:466;i:4;i:457;i:5;i:448;i:6;i:437;i:7;i:430;i:8;i:424;i:9;i:171;i:10;i:172;i:11;i:173;}s:5:\"total\";i:12;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:12;s:12:\"current_page\";i:1;}}","no"),
("10833","_transient_timeout_wc_product_loop_7037f26286e6ef0fbb763f649fb56634","1704875253","no"),
("10834","_transient_wc_product_loop_7037f26286e6ef0fbb763f649fb56634","a:2:{s:7:\"version\";s:10:\"1702237825\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:8:{i:0;i:595;i:1;i:592;i:2;i:588;i:3;i:466;i:4;i:457;i:5;i:448;i:6;i:437;i:7;i:430;}s:5:\"total\";i:8;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:8;s:12:\"current_page\";i:1;}}","no"),
("10867","_transient_timeout_wc_product_loop_cd4ceb08a6a3e9bac7f4260a4e03a47f","1704874460","no"),
("10868","_transient_wc_product_loop_cd4ceb08a6a3e9bac7f4260a4e03a47f","a:2:{s:7:\"version\";s:10:\"1702237825\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:4:{i:0;i:190;i:1;i:200;i:2;i:203;i:3;i:199;}s:5:\"total\";i:4;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:4;s:12:\"current_page\";i:1;}}","no"),
("10869","_transient_timeout_wc_product_loop_cfb00defdda27bfe058197bc6e9778d7","1704874460","no"),
("10870","_transient_wc_product_loop_cfb00defdda27bfe058197bc6e9778d7","a:2:{s:7:\"version\";s:10:\"1702237825\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:4:{i:0;i:171;i:1;i:177;i:2;i:179;i:3;i:181;}s:5:\"total\";i:4;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:4;s:12:\"current_page\";i:1;}}","no"),
("10872","_transient_timeout_wc_layered_nav_counts_pa_%d8%b1%d9%86%da%af","1702300531","no");

INSERT IGNORE INTO `wp_options` VALUES 
("10873","_transient_wc_layered_nav_counts_pa_%d8%b1%d9%86%da%af","a:5:{i:0;b:0;s:32:\"94c8e6af3f84935de9309a83fac1293b\";a:0:{}s:32:\"a02d427d6b5fd7d658a1d65f62a81523\";a:0:{}s:32:\"6850fdff2d2b2af756ce28d6dbf0cd20\";a:0:{}s:32:\"1324e5e137e38eb7634c9186f21e9187\";a:3:{i:120;i:4;i:121;i:3;i:125;i:2;}}","no"),
("10894","_transient_timeout_wc_product_children_191","1704722023","no"),
("10895","_transient_wc_product_children_191","a:2:{s:3:\"all\";a:10:{i:0;i:669;i:1;i:670;i:2;i:671;i:3;i:672;i:4;i:673;i:5;i:674;i:6;i:675;i:7;i:676;i:8;i:677;i:9;i:678;}s:7:\"visible\";a:10:{i:0;i:669;i:1;i:670;i:2;i:671;i:3;i:672;i:4;i:673;i:5;i:674;i:6;i:675;i:7;i:676;i:8;i:677;i:9;i:678;}}","no"),
("10896","_transient_timeout_wc_var_prices_191","1704722023","no"),
("10897","_transient_wc_var_prices_191","{\"version\":\"1698789138\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"669\":\"250000\",\"670\":\"260000\",\"671\":\"270000\",\"672\":\"280000\",\"673\":\"290000\",\"674\":\"300000\",\"675\":\"310000\",\"676\":\"320000\",\"677\":\"330000\",\"678\":\"340000\"},\"regular_price\":{\"669\":\"250000\",\"670\":\"260000\",\"671\":\"270000\",\"672\":\"280000\",\"673\":\"290000\",\"674\":\"300000\",\"675\":\"310000\",\"676\":\"320000\",\"677\":\"330000\",\"678\":\"340000\"},\"sale_price\":{\"669\":\"250000\",\"670\":\"260000\",\"671\":\"270000\",\"672\":\"280000\",\"673\":\"290000\",\"674\":\"300000\",\"675\":\"310000\",\"676\":\"320000\",\"677\":\"330000\",\"678\":\"340000\"}}}","no"),
("10898","_transient_timeout_wc_product_children_192","1704722023","no"),
("10899","_transient_wc_product_children_192","a:2:{s:3:\"all\";a:0:{}s:7:\"visible\";a:0:{}}","no"),
("10900","_transient_timeout_wc_var_prices_192","1704722023","no"),
("10901","_transient_wc_var_prices_192","{\"version\":\"1698789138\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":[],\"regular_price\":[],\"sale_price\":[]}}","no"),
("10902","_transient_timeout_wc_product_children_196","1704722023","no"),
("10903","_transient_wc_product_children_196","a:2:{s:3:\"all\";a:10:{i:0;i:684;i:1;i:685;i:2;i:686;i:3;i:687;i:4;i:688;i:5;i:689;i:6;i:690;i:7;i:691;i:8;i:692;i:9;i:693;}s:7:\"visible\";a:10:{i:0;i:684;i:1;i:685;i:2;i:686;i:3;i:687;i:4;i:688;i:5;i:689;i:6;i:690;i:7;i:691;i:8;i:692;i:9;i:693;}}","no"),
("10904","_transient_timeout_wc_var_prices_196","1704722023","no"),
("10905","_transient_wc_var_prices_196","{\"version\":\"1698789138\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"684\":\"310000\",\"685\":\"320000\",\"686\":\"330000\",\"687\":\"340000\",\"688\":\"350000\",\"689\":\"360000\",\"690\":\"370000\",\"691\":\"380000\",\"692\":\"390000\",\"693\":\"400000\"},\"regular_price\":{\"684\":\"310000\",\"685\":\"320000\",\"686\":\"330000\",\"687\":\"340000\",\"688\":\"350000\",\"689\":\"360000\",\"690\":\"370000\",\"691\":\"380000\",\"692\":\"390000\",\"693\":\"400000\"},\"sale_price\":{\"684\":\"310000\",\"685\":\"320000\",\"686\":\"330000\",\"687\":\"340000\",\"688\":\"350000\",\"689\":\"360000\",\"690\":\"370000\",\"691\":\"380000\",\"692\":\"390000\",\"693\":\"400000\"}}}","no"),
("10906","_transient_timeout_wc_product_children_208","1704722023","no"),
("10907","_transient_wc_product_children_208","a:2:{s:3:\"all\";a:2:{i:0;i:755;i:1;i:756;}s:7:\"visible\";a:2:{i:0;i:755;i:1;i:756;}}","no"),
("10908","_transient_timeout_wc_var_prices_208","1704722023","no"),
("10909","_transient_wc_var_prices_208","{\"version\":\"1698789138\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"755\":\"780000\",\"756\":\"980000\"},\"regular_price\":{\"755\":\"780000\",\"756\":\"980000\"},\"sale_price\":{\"755\":\"780000\",\"756\":\"980000\"}}}","no"),
("10910","_transient_timeout_wc_product_children_222","1704722023","no"),
("10911","_transient_wc_product_children_222","a:2:{s:3:\"all\";a:0:{}s:7:\"visible\";a:0:{}}","no"),
("10912","_transient_timeout_wc_var_prices_222","1704722023","no"),
("10913","_transient_wc_var_prices_222","{\"version\":\"1698789138\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":[],\"regular_price\":[],\"sale_price\":[]}}","no"),
("10918","_transient_wc_count_comments","O:8:\"stdClass\":7:{s:14:\"total_comments\";i:2;s:3:\"all\";i:2;s:8:\"approved\";s:1:\"2\";s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}","yes"),
("11254","_transient_timeout_wc_product_loop_b28206b002de88fd912763c93a6ad102","1704797555","no"),
("11255","_transient_wc_product_loop_b28206b002de88fd912763c93a6ad102","a:2:{s:7:\"version\";s:10:\"1702086466\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:12:{i:0;i:218;i:1;i:217;i:2;i:216;i:3;i:214;i:4;i:205;i:5;i:197;i:6;i:203;i:7;i:202;i:8;i:201;i:9;i:200;i:10;i:173;i:11;i:199;}s:5:\"total\";i:12;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:12;s:12:\"current_page\";i:1;}}","no"),
("11257","_transient_timeout_wc_product_loop_8812086b7a5977b25bf93a4566c0dd6b","1704797587","no"),
("11258","_transient_wc_product_loop_8812086b7a5977b25bf93a4566c0dd6b","a:2:{s:7:\"version\";s:10:\"1702086466\";s:5:\"value\";O:8:\"stdClass\":5:{s:3:\"ids\";a:8:{i:0;i:218;i:1;i:217;i:2;i:216;i:3;i:214;i:4;i:205;i:5;i:197;i:6;i:203;i:7;i:202;}s:5:\"total\";i:8;s:11:\"total_pages\";i:1;s:8:\"per_page\";i:8;s:12:\"current_page\";i:1;}}","no"),
("11463","_transient_timeout_flatsome_instagram_stylechild_no_scrape_3_17_7","1702231426","no"),
("11464","_transient_flatsome_instagram_stylechild_no_scrape_3_17_7","YTowOnt9","no"),
("11468","_transient_timeout_flatsome_instagram_topshop_scrape_3_17_7","1702231604","no"),
("11469","_transient_flatsome_instagram_topshop_scrape_3_17_7","YTowOnt9","no"),
("11482","_transient_timeout_flatsome_instagram_surfer_magazine_scrape_3_17_7","1702232262","no"),
("11483","_transient_flatsome_instagram_surfer_magazine_scrape_3_17_7","YTowOnt9","no"),
("11595","theme_mods_twentytwentyfour","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:19:\"wp_classic_sidebars\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1702237894;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:75:{i:0;s:31:\"woocommerce_product_tag_cloud-8\";i:1;s:7:\"block-2\";i:2;s:7:\"block-3\";i:3;s:7:\"block-4\";i:4;s:7:\"block-5\";i:5;s:7:\"block-6\";i:6;s:7:\"pages-3\";i:7;s:7:\"pages-5\";i:8;s:7:\"pages-6\";i:9;s:7:\"pages-8\";i:10;s:10:\"calendar-3\";i:11;s:10:\"calendar-5\";i:12;s:10:\"archives-4\";i:13;s:10:\"archives-6\";i:14;s:8:\"search-4\";i:15;s:6:\"text-4\";i:16;s:12:\"categories-5\";i:17;s:12:\"categories-7\";i:18;s:14:\"recent-posts-4\";i:19;s:14:\"recent-posts-6\";i:20;s:14:\"recent-posts-8\";i:21;s:17:\"recent-comments-4\";i:22;s:11:\"tag_cloud-3\";i:23;s:11:\"tag_cloud-8\";i:24;s:25:\"woocommerce_widget_cart-3\";i:25;s:25:\"woocommerce_widget_cart-5\";i:26;s:33:\"woocommerce_layered_nav_filters-3\";i:27;s:33:\"woocommerce_layered_nav_filters-5\";i:28;s:33:\"woocommerce_layered_nav_filters-7\";i:29;s:33:\"woocommerce_layered_nav_filters-9\";i:30;s:25:\"woocommerce_layered_nav-3\";i:31;s:25:\"woocommerce_layered_nav-5\";i:32;s:25:\"woocommerce_layered_nav-7\";i:33;s:26:\"woocommerce_layered_nav-10\";i:34;s:26:\"woocommerce_price_filter-3\";i:35;s:26:\"woocommerce_price_filter-5\";i:36;s:26:\"woocommerce_price_filter-7\";i:37;s:27:\"woocommerce_price_filter-11\";i:38;s:32:\"woocommerce_product_categories-5\";i:39;s:32:\"woocommerce_product_categories-7\";i:40;s:32:\"woocommerce_product_categories-9\";i:41;s:33:\"woocommerce_product_categories-10\";i:42;s:33:\"woocommerce_product_categories-12\";i:43;s:31:\"woocommerce_product_tag_cloud-3\";i:44;s:31:\"woocommerce_product_tag_cloud-5\";i:45;s:31:\"woocommerce_product_tag_cloud-6\";i:46;s:31:\"woocommerce_product_tag_cloud-7\";i:47;s:22:\"woocommerce_products-3\";i:48;s:22:\"woocommerce_products-4\";i:49;s:22:\"woocommerce_products-5\";i:50;s:22:\"woocommerce_products-7\";i:51;s:22:\"woocommerce_products-9\";i:52;s:23:\"woocommerce_products-10\";i:53;s:27:\"woocommerce_rating_filter-2\";i:54;s:27:\"woocommerce_rating_filter-3\";i:55;s:28:\"woocommerce_recent_reviews-3\";i:56;s:38:\"woocommerce_recently_viewed_products-3\";i:57;s:38:\"woocommerce_recently_viewed_products-5\";i:58;s:38:\"woocommerce_recently_viewed_products-7\";i:59;s:32:\"woocommerce_top_rated_products-2\";i:60;s:7:\"text-13\";i:61;s:17:\"recent-comments-5\";i:62;s:11:\"tag_cloud-9\";i:63;s:13:\"categories-14\";i:64;s:10:\"archives-7\";i:65;s:23:\"woocommerce_products-12\";i:66;s:23:\"woocommerce_products-11\";i:67;s:23:\"woocommerce_products-13\";i:68;s:32:\"woocommerce_top_rated_products-3\";i:69;s:12:\"tag_cloud-11\";i:70;s:34:\"woocommerce_layered_nav_filters-10\";i:71;s:33:\"woocommerce_product_categories-13\";i:72;s:26:\"woocommerce_layered_nav-11\";i:73;s:26:\"woocommerce_price_filter-9\";i:74;s:38:\"woocommerce_recently_viewed_products-8\";}}}}","yes"),
("11596","has_migrated_cart","success","yes"),
("11597","has_migrated_checkout","success","yes"),
("11606","_transient_timeout__woocommerce_upload_directory_status","1702324294","no"),
("11607","_transient__woocommerce_upload_directory_status","protected","no"),
("11608","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1702295542;s:7:\"checked\";a:2:{s:14:\"flatsome-child\";s:3:\"3.0\";s:8:\"flatsome\";s:6:\"3.18.2\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:1:{s:8:\"flatsome\";a:4:{s:5:\"theme\";s:8:\"flatsome\";s:11:\"new_version\";s:6:\"3.18.2\";s:3:\"url\";s:95:\"https://theme-samandon.ir/flatsome/wp-admin/admin.php?page=flatsome-version-info&version=3.18.2\";s:7:\"package\";s:117:\"https://theme-samandon.ir/flatsome/wp-admin/admin.php?page=flatsome-panel&flatsome_version=3.18.2&flatsome_download=1\";}}s:12:\"translations\";a:0:{}}","no"),
("11662","_site_transient_timeout_kirki_googlefonts_cache","1702350963","no"),
("11663","_site_transient_kirki_googlefonts_cache","a:1539:{s:7:\"ABeeZee\";a:3:{s:5:\"label\";s:7:\"ABeeZee\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Abel\";a:3:{s:5:\"label\";s:4:\"Abel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Abhaya Libre\";a:3:{s:5:\"label\";s:12:\"Abhaya Libre\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Aboreto\";a:3:{s:5:\"label\";s:7:\"Aboreto\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Abril Fatface\";a:3:{s:5:\"label\";s:13:\"Abril Fatface\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Abyssinica SIL\";a:3:{s:5:\"label\";s:14:\"Abyssinica SIL\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Aclonica\";a:3:{s:5:\"label\";s:8:\"Aclonica\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Acme\";a:3:{s:5:\"label\";s:4:\"Acme\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Actor\";a:3:{s:5:\"label\";s:5:\"Actor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Adamina\";a:3:{s:5:\"label\";s:7:\"Adamina\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Advent Pro\";a:3:{s:5:\"label\";s:10:\"Advent Pro\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Aguafina Script\";a:3:{s:5:\"label\";s:15:\"Aguafina Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Akaya Kanadaka\";a:3:{s:5:\"label\";s:14:\"Akaya Kanadaka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Akaya Telivigala\";a:3:{s:5:\"label\";s:16:\"Akaya Telivigala\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Akronim\";a:3:{s:5:\"label\";s:7:\"Akronim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Akshar\";a:3:{s:5:\"label\";s:6:\"Akshar\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Aladin\";a:3:{s:5:\"label\";s:6:\"Aladin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Alata\";a:3:{s:5:\"label\";s:5:\"Alata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Alatsi\";a:3:{s:5:\"label\";s:6:\"Alatsi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Albert Sans\";a:3:{s:5:\"label\";s:11:\"Albert Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Aldrich\";a:3:{s:5:\"label\";s:7:\"Aldrich\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Alef\";a:3:{s:5:\"label\";s:4:\"Alef\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Alegreya\";a:3:{s:5:\"label\";s:8:\"Alegreya\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Alegreya SC\";a:3:{s:5:\"label\";s:11:\"Alegreya SC\";s:8:\"variants\";a:10:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"800\";i:5;s:9:\"800italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Alegreya Sans\";a:3:{s:5:\"label\";s:13:\"Alegreya Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Alegreya Sans SC\";a:3:{s:5:\"label\";s:16:\"Alegreya Sans SC\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Aleo\";a:3:{s:5:\"label\";s:4:\"Aleo\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Alex Brush\";a:3:{s:5:\"label\";s:10:\"Alex Brush\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Alexandria\";a:3:{s:5:\"label\";s:10:\"Alexandria\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Alfa Slab One\";a:3:{s:5:\"label\";s:13:\"Alfa Slab One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Alice\";a:3:{s:5:\"label\";s:5:\"Alice\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Alike\";a:3:{s:5:\"label\";s:5:\"Alike\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Alike Angular\";a:3:{s:5:\"label\";s:13:\"Alike Angular\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Alkalami\";a:3:{s:5:\"label\";s:8:\"Alkalami\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Alkatra\";a:3:{s:5:\"label\";s:7:\"Alkatra\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Allan\";a:3:{s:5:\"label\";s:5:\"Allan\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Allerta\";a:3:{s:5:\"label\";s:7:\"Allerta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Allerta Stencil\";a:3:{s:5:\"label\";s:15:\"Allerta Stencil\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Allison\";a:3:{s:5:\"label\";s:7:\"Allison\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Allura\";a:3:{s:5:\"label\";s:6:\"Allura\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Almarai\";a:3:{s:5:\"label\";s:7:\"Almarai\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:3:\"800\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Almendra\";a:3:{s:5:\"label\";s:8:\"Almendra\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Almendra Display\";a:3:{s:5:\"label\";s:16:\"Almendra Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Almendra SC\";a:3:{s:5:\"label\";s:11:\"Almendra SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Alumni Sans\";a:3:{s:5:\"label\";s:11:\"Alumni Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:26:\"Alumni Sans Collegiate One\";a:3:{s:5:\"label\";s:26:\"Alumni Sans Collegiate One\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:22:\"Alumni Sans Inline One\";a:3:{s:5:\"label\";s:22:\"Alumni Sans Inline One\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:21:\"Alumni Sans Pinstripe\";a:3:{s:5:\"label\";s:21:\"Alumni Sans Pinstripe\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Amarante\";a:3:{s:5:\"label\";s:8:\"Amarante\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Amaranth\";a:3:{s:5:\"label\";s:8:\"Amaranth\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Amatic SC\";a:3:{s:5:\"label\";s:9:\"Amatic SC\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Amethysta\";a:3:{s:5:\"label\";s:9:\"Amethysta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Amiko\";a:3:{s:5:\"label\";s:5:\"Amiko\";s:8:\"variants\";a:3:{i:0;s:3:\"600\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Amiri\";a:3:{s:5:\"label\";s:5:\"Amiri\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Amiri Quran\";a:3:{s:5:\"label\";s:11:\"Amiri Quran\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Amita\";a:3:{s:5:\"label\";s:5:\"Amita\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Anaheim\";a:3:{s:5:\"label\";s:7:\"Anaheim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Andada Pro\";a:3:{s:5:\"label\";s:10:\"Andada Pro\";s:8:\"variants\";a:10:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Andika\";a:3:{s:5:\"label\";s:6:\"Andika\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Anek Bangla\";a:3:{s:5:\"label\";s:11:\"Anek Bangla\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Anek Devanagari\";a:3:{s:5:\"label\";s:15:\"Anek Devanagari\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Anek Gujarati\";a:3:{s:5:\"label\";s:13:\"Anek Gujarati\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Anek Gurmukhi\";a:3:{s:5:\"label\";s:13:\"Anek Gurmukhi\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Anek Kannada\";a:3:{s:5:\"label\";s:12:\"Anek Kannada\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Anek Latin\";a:3:{s:5:\"label\";s:10:\"Anek Latin\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Anek Malayalam\";a:3:{s:5:\"label\";s:14:\"Anek Malayalam\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Anek Odia\";a:3:{s:5:\"label\";s:9:\"Anek Odia\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Anek Tamil\";a:3:{s:5:\"label\";s:10:\"Anek Tamil\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Anek Telugu\";a:3:{s:5:\"label\";s:11:\"Anek Telugu\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Angkor\";a:3:{s:5:\"label\";s:6:\"Angkor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:24:\"Annie Use Your Telescope\";a:3:{s:5:\"label\";s:24:\"Annie Use Your Telescope\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Anonymous Pro\";a:3:{s:5:\"label\";s:13:\"Anonymous Pro\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:5:\"Antic\";a:3:{s:5:\"label\";s:5:\"Antic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Antic Didone\";a:3:{s:5:\"label\";s:12:\"Antic Didone\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Antic Slab\";a:3:{s:5:\"label\";s:10:\"Antic Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Anton\";a:3:{s:5:\"label\";s:5:\"Anton\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Antonio\";a:3:{s:5:\"label\";s:7:\"Antonio\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Anuphan\";a:3:{s:5:\"label\";s:7:\"Anuphan\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Anybody\";a:3:{s:5:\"label\";s:7:\"Anybody\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Aoboshi One\";a:3:{s:5:\"label\";s:11:\"Aoboshi One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Arapey\";a:3:{s:5:\"label\";s:6:\"Arapey\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Arbutus\";a:3:{s:5:\"label\";s:7:\"Arbutus\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Arbutus Slab\";a:3:{s:5:\"label\";s:12:\"Arbutus Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Architects Daughter\";a:3:{s:5:\"label\";s:19:\"Architects Daughter\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Archivo\";a:3:{s:5:\"label\";s:7:\"Archivo\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Archivo Black\";a:3:{s:5:\"label\";s:13:\"Archivo Black\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Archivo Narrow\";a:3:{s:5:\"label\";s:14:\"Archivo Narrow\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Are You Serious\";a:3:{s:5:\"label\";s:15:\"Are You Serious\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Aref Ruqaa\";a:3:{s:5:\"label\";s:10:\"Aref Ruqaa\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Aref Ruqaa Ink\";a:3:{s:5:\"label\";s:14:\"Aref Ruqaa Ink\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Arima\";a:3:{s:5:\"label\";s:5:\"Arima\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Arimo\";a:3:{s:5:\"label\";s:5:\"Arimo\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Arizonia\";a:3:{s:5:\"label\";s:8:\"Arizonia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Armata\";a:3:{s:5:\"label\";s:6:\"Armata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Arsenal\";a:3:{s:5:\"label\";s:7:\"Arsenal\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Artifika\";a:3:{s:5:\"label\";s:8:\"Artifika\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Arvo\";a:3:{s:5:\"label\";s:4:\"Arvo\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Arya\";a:3:{s:5:\"label\";s:4:\"Arya\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Asap\";a:3:{s:5:\"label\";s:4:\"Asap\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Asap Condensed\";a:3:{s:5:\"label\";s:14:\"Asap Condensed\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Asar\";a:3:{s:5:\"label\";s:4:\"Asar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Asset\";a:3:{s:5:\"label\";s:5:\"Asset\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Assistant\";a:3:{s:5:\"label\";s:9:\"Assistant\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Astloch\";a:3:{s:5:\"label\";s:7:\"Astloch\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Asul\";a:3:{s:5:\"label\";s:4:\"Asul\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Athiti\";a:3:{s:5:\"label\";s:6:\"Athiti\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Atkinson Hyperlegible\";a:3:{s:5:\"label\";s:21:\"Atkinson Hyperlegible\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Atma\";a:3:{s:5:\"label\";s:4:\"Atma\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Atomic Age\";a:3:{s:5:\"label\";s:10:\"Atomic Age\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Aubrey\";a:3:{s:5:\"label\";s:6:\"Aubrey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Audiowide\";a:3:{s:5:\"label\";s:9:\"Audiowide\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Autour One\";a:3:{s:5:\"label\";s:10:\"Autour One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Average\";a:3:{s:5:\"label\";s:7:\"Average\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Average Sans\";a:3:{s:5:\"label\";s:12:\"Average Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Averia Gruesa Libre\";a:3:{s:5:\"label\";s:19:\"Averia Gruesa Libre\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Averia Libre\";a:3:{s:5:\"label\";s:12:\"Averia Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Averia Sans Libre\";a:3:{s:5:\"label\";s:17:\"Averia Sans Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Averia Serif Libre\";a:3:{s:5:\"label\";s:18:\"Averia Serif Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Azeret Mono\";a:3:{s:5:\"label\";s:11:\"Azeret Mono\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:4:\"B612\";a:3:{s:5:\"label\";s:4:\"B612\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"B612 Mono\";a:3:{s:5:\"label\";s:9:\"B612 Mono\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:12:\"BIZ UDGothic\";a:3:{s:5:\"label\";s:12:\"BIZ UDGothic\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"BIZ UDMincho\";a:3:{s:5:\"label\";s:12:\"BIZ UDMincho\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"BIZ UDPGothic\";a:3:{s:5:\"label\";s:13:\"BIZ UDPGothic\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"BIZ UDPMincho\";a:3:{s:5:\"label\";s:13:\"BIZ UDPMincho\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Babylonica\";a:3:{s:5:\"label\";s:10:\"Babylonica\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Bad Script\";a:3:{s:5:\"label\";s:10:\"Bad Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Bagel Fat One\";a:3:{s:5:\"label\";s:13:\"Bagel Fat One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Bahiana\";a:3:{s:5:\"label\";s:7:\"Bahiana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Bahianita\";a:3:{s:5:\"label\";s:9:\"Bahianita\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Bai Jamjuree\";a:3:{s:5:\"label\";s:12:\"Bai Jamjuree\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Bakbak One\";a:3:{s:5:\"label\";s:10:\"Bakbak One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Ballet\";a:3:{s:5:\"label\";s:6:\"Ballet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Baloo 2\";a:3:{s:5:\"label\";s:7:\"Baloo 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Baloo Bhai 2\";a:3:{s:5:\"label\";s:12:\"Baloo Bhai 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Baloo Bhaijaan 2\";a:3:{s:5:\"label\";s:16:\"Baloo Bhaijaan 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Baloo Bhaina 2\";a:3:{s:5:\"label\";s:14:\"Baloo Bhaina 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Baloo Chettan 2\";a:3:{s:5:\"label\";s:15:\"Baloo Chettan 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Baloo Da 2\";a:3:{s:5:\"label\";s:10:\"Baloo Da 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Baloo Paaji 2\";a:3:{s:5:\"label\";s:13:\"Baloo Paaji 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Baloo Tamma 2\";a:3:{s:5:\"label\";s:13:\"Baloo Tamma 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Baloo Tammudu 2\";a:3:{s:5:\"label\";s:15:\"Baloo Tammudu 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Baloo Thambi 2\";a:3:{s:5:\"label\";s:14:\"Baloo Thambi 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Balsamiq Sans\";a:3:{s:5:\"label\";s:13:\"Balsamiq Sans\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Balthazar\";a:3:{s:5:\"label\";s:9:\"Balthazar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Bangers\";a:3:{s:5:\"label\";s:7:\"Bangers\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Barlow\";a:3:{s:5:\"label\";s:6:\"Barlow\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Barlow Condensed\";a:3:{s:5:\"label\";s:16:\"Barlow Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Barlow Semi Condensed\";a:3:{s:5:\"label\";s:21:\"Barlow Semi Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Barriecito\";a:3:{s:5:\"label\";s:10:\"Barriecito\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Barrio\";a:3:{s:5:\"label\";s:6:\"Barrio\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Basic\";a:3:{s:5:\"label\";s:5:\"Basic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Baskervville\";a:3:{s:5:\"label\";s:12:\"Baskervville\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Battambang\";a:3:{s:5:\"label\";s:10:\"Battambang\";s:8:\"variants\";a:5:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"900\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Baumans\";a:3:{s:5:\"label\";s:7:\"Baumans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Bayon\";a:3:{s:5:\"label\";s:5:\"Bayon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Be Vietnam Pro\";a:3:{s:5:\"label\";s:14:\"Be Vietnam Pro\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Beau Rivage\";a:3:{s:5:\"label\";s:11:\"Beau Rivage\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Bebas Neue\";a:3:{s:5:\"label\";s:10:\"Bebas Neue\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Belgrano\";a:3:{s:5:\"label\";s:8:\"Belgrano\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Bellefair\";a:3:{s:5:\"label\";s:9:\"Bellefair\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Belleza\";a:3:{s:5:\"label\";s:7:\"Belleza\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Bellota\";a:3:{s:5:\"label\";s:7:\"Bellota\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Bellota Text\";a:3:{s:5:\"label\";s:12:\"Bellota Text\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"BenchNine\";a:3:{s:5:\"label\";s:9:\"BenchNine\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Benne\";a:3:{s:5:\"label\";s:5:\"Benne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Bentham\";a:3:{s:5:\"label\";s:7:\"Bentham\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Berkshire Swash\";a:3:{s:5:\"label\";s:15:\"Berkshire Swash\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Besley\";a:3:{s:5:\"label\";s:6:\"Besley\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Beth Ellen\";a:3:{s:5:\"label\";s:10:\"Beth Ellen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Bevan\";a:3:{s:5:\"label\";s:5:\"Bevan\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"BhuTuka Expanded One\";a:3:{s:5:\"label\";s:20:\"BhuTuka Expanded One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:21:\"Big Shoulders Display\";a:3:{s:5:\"label\";s:21:\"Big Shoulders Display\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:28:\"Big Shoulders Inline Display\";a:3:{s:5:\"label\";s:28:\"Big Shoulders Inline Display\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:25:\"Big Shoulders Inline Text\";a:3:{s:5:\"label\";s:25:\"Big Shoulders Inline Text\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:29:\"Big Shoulders Stencil Display\";a:3:{s:5:\"label\";s:29:\"Big Shoulders Stencil Display\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:26:\"Big Shoulders Stencil Text\";a:3:{s:5:\"label\";s:26:\"Big Shoulders Stencil Text\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Big Shoulders Text\";a:3:{s:5:\"label\";s:18:\"Big Shoulders Text\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Bigelow Rules\";a:3:{s:5:\"label\";s:13:\"Bigelow Rules\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Bigshot One\";a:3:{s:5:\"label\";s:11:\"Bigshot One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Bilbo\";a:3:{s:5:\"label\";s:5:\"Bilbo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Bilbo Swash Caps\";a:3:{s:5:\"label\";s:16:\"Bilbo Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"BioRhyme\";a:3:{s:5:\"label\";s:8:\"BioRhyme\";s:8:\"variants\";a:5:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"BioRhyme Expanded\";a:3:{s:5:\"label\";s:17:\"BioRhyme Expanded\";s:8:\"variants\";a:5:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Birthstone\";a:3:{s:5:\"label\";s:10:\"Birthstone\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:17:\"Birthstone Bounce\";a:3:{s:5:\"label\";s:17:\"Birthstone Bounce\";s:8:\"variants\";a:2:{i:0;s:3:\"500\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Biryani\";a:3:{s:5:\"label\";s:7:\"Biryani\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Bitter\";a:3:{s:5:\"label\";s:6:\"Bitter\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"Black And White Picture\";a:3:{s:5:\"label\";s:23:\"Black And White Picture\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Black Han Sans\";a:3:{s:5:\"label\";s:14:\"Black Han Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Black Ops One\";a:3:{s:5:\"label\";s:13:\"Black Ops One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Blaka\";a:3:{s:5:\"label\";s:5:\"Blaka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Blaka Hollow\";a:3:{s:5:\"label\";s:12:\"Blaka Hollow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Blaka Ink\";a:3:{s:5:\"label\";s:9:\"Blaka Ink\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Blinker\";a:3:{s:5:\"label\";s:7:\"Blinker\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Bodoni Moda\";a:3:{s:5:\"label\";s:11:\"Bodoni Moda\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Bokor\";a:3:{s:5:\"label\";s:5:\"Bokor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Bona Nova\";a:3:{s:5:\"label\";s:9:\"Bona Nova\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Bonbon\";a:3:{s:5:\"label\";s:6:\"Bonbon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Bonheur Royale\";a:3:{s:5:\"label\";s:14:\"Bonheur Royale\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Boogaloo\";a:3:{s:5:\"label\";s:8:\"Boogaloo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Bowlby One\";a:3:{s:5:\"label\";s:10:\"Bowlby One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Bowlby One SC\";a:3:{s:5:\"label\";s:13:\"Bowlby One SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Braah One\";a:3:{s:5:\"label\";s:9:\"Braah One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Brawler\";a:3:{s:5:\"label\";s:7:\"Brawler\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Bree Serif\";a:3:{s:5:\"label\";s:10:\"Bree Serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Bruno Ace\";a:3:{s:5:\"label\";s:9:\"Bruno Ace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Bruno Ace SC\";a:3:{s:5:\"label\";s:12:\"Bruno Ace SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Brygada 1918\";a:3:{s:5:\"label\";s:12:\"Brygada 1918\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Bubblegum Sans\";a:3:{s:5:\"label\";s:14:\"Bubblegum Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Bubbler One\";a:3:{s:5:\"label\";s:11:\"Bubbler One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Buda\";a:3:{s:5:\"label\";s:4:\"Buda\";s:8:\"variants\";a:1:{i:0;s:3:\"300\";}s:8:\"category\";s:7:\"display\";}s:7:\"Buenard\";a:3:{s:5:\"label\";s:7:\"Buenard\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Bungee\";a:3:{s:5:\"label\";s:6:\"Bungee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Bungee Hairline\";a:3:{s:5:\"label\";s:15:\"Bungee Hairline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Bungee Inline\";a:3:{s:5:\"label\";s:13:\"Bungee Inline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Bungee Outline\";a:3:{s:5:\"label\";s:14:\"Bungee Outline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Bungee Shade\";a:3:{s:5:\"label\";s:12:\"Bungee Shade\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Bungee Spice\";a:3:{s:5:\"label\";s:12:\"Bungee Spice\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Butcherman\";a:3:{s:5:\"label\";s:10:\"Butcherman\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Butterfly Kids\";a:3:{s:5:\"label\";s:14:\"Butterfly Kids\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Cabin\";a:3:{s:5:\"label\";s:5:\"Cabin\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Cabin Condensed\";a:3:{s:5:\"label\";s:15:\"Cabin Condensed\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Cabin Sketch\";a:3:{s:5:\"label\";s:12:\"Cabin Sketch\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Caesar Dressing\";a:3:{s:5:\"label\";s:15:\"Caesar Dressing\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Cagliostro\";a:3:{s:5:\"label\";s:10:\"Cagliostro\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Cairo\";a:3:{s:5:\"label\";s:5:\"Cairo\";s:8:\"variants\";a:8:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Cairo Play\";a:3:{s:5:\"label\";s:10:\"Cairo Play\";s:8:\"variants\";a:8:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Caladea\";a:3:{s:5:\"label\";s:7:\"Caladea\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Calistoga\";a:3:{s:5:\"label\";s:9:\"Calistoga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Calligraffitti\";a:3:{s:5:\"label\";s:14:\"Calligraffitti\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Cambay\";a:3:{s:5:\"label\";s:6:\"Cambay\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Cambo\";a:3:{s:5:\"label\";s:5:\"Cambo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Candal\";a:3:{s:5:\"label\";s:6:\"Candal\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Cantarell\";a:3:{s:5:\"label\";s:9:\"Cantarell\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Cantata One\";a:3:{s:5:\"label\";s:11:\"Cantata One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Cantora One\";a:3:{s:5:\"label\";s:11:\"Cantora One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Capriola\";a:3:{s:5:\"label\";s:8:\"Capriola\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Caramel\";a:3:{s:5:\"label\";s:7:\"Caramel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Carattere\";a:3:{s:5:\"label\";s:9:\"Carattere\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Cardo\";a:3:{s:5:\"label\";s:5:\"Cardo\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Carlito\";a:3:{s:5:\"label\";s:7:\"Carlito\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Carme\";a:3:{s:5:\"label\";s:5:\"Carme\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Carrois Gothic\";a:3:{s:5:\"label\";s:14:\"Carrois Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Carrois Gothic SC\";a:3:{s:5:\"label\";s:17:\"Carrois Gothic SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Carter One\";a:3:{s:5:\"label\";s:10:\"Carter One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Castoro\";a:3:{s:5:\"label\";s:7:\"Castoro\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Castoro Titling\";a:3:{s:5:\"label\";s:15:\"Castoro Titling\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Catamaran\";a:3:{s:5:\"label\";s:9:\"Catamaran\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Caudex\";a:3:{s:5:\"label\";s:6:\"Caudex\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Caveat\";a:3:{s:5:\"label\";s:6:\"Caveat\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Caveat Brush\";a:3:{s:5:\"label\";s:12:\"Caveat Brush\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:18:\"Cedarville Cursive\";a:3:{s:5:\"label\";s:18:\"Cedarville Cursive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Ceviche One\";a:3:{s:5:\"label\";s:11:\"Ceviche One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Chakra Petch\";a:3:{s:5:\"label\";s:12:\"Chakra Petch\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Changa\";a:3:{s:5:\"label\";s:6:\"Changa\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Changa One\";a:3:{s:5:\"label\";s:10:\"Changa One\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Chango\";a:3:{s:5:\"label\";s:6:\"Chango\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Charis SIL\";a:3:{s:5:\"label\";s:10:\"Charis SIL\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Charm\";a:3:{s:5:\"label\";s:5:\"Charm\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Charmonman\";a:3:{s:5:\"label\";s:10:\"Charmonman\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Chathura\";a:3:{s:5:\"label\";s:8:\"Chathura\";s:8:\"variants\";a:5:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Chau Philomene One\";a:3:{s:5:\"label\";s:18:\"Chau Philomene One\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Chela One\";a:3:{s:5:\"label\";s:9:\"Chela One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Chelsea Market\";a:3:{s:5:\"label\";s:14:\"Chelsea Market\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Chenla\";a:3:{s:5:\"label\";s:6:\"Chenla\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Cherish\";a:3:{s:5:\"label\";s:7:\"Cherish\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Cherry Bomb One\";a:3:{s:5:\"label\";s:15:\"Cherry Bomb One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Cherry Cream Soda\";a:3:{s:5:\"label\";s:17:\"Cherry Cream Soda\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Cherry Swash\";a:3:{s:5:\"label\";s:12:\"Cherry Swash\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Chewy\";a:3:{s:5:\"label\";s:5:\"Chewy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Chicle\";a:3:{s:5:\"label\";s:6:\"Chicle\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Chilanka\";a:3:{s:5:\"label\";s:8:\"Chilanka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Chivo\";a:3:{s:5:\"label\";s:5:\"Chivo\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Chivo Mono\";a:3:{s:5:\"label\";s:10:\"Chivo Mono\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:10:\"Chokokutai\";a:3:{s:5:\"label\";s:10:\"Chokokutai\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Chonburi\";a:3:{s:5:\"label\";s:8:\"Chonburi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Cinzel\";a:3:{s:5:\"label\";s:6:\"Cinzel\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Cinzel Decorative\";a:3:{s:5:\"label\";s:17:\"Cinzel Decorative\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"900\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Clicker Script\";a:3:{s:5:\"label\";s:14:\"Clicker Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Climate Crisis\";a:3:{s:5:\"label\";s:14:\"Climate Crisis\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Coda\";a:3:{s:5:\"label\";s:4:\"Coda\";s:8:\"variants\";a:2:{i:0;s:3:\"800\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Codystar\";a:3:{s:5:\"label\";s:8:\"Codystar\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Coiny\";a:3:{s:5:\"label\";s:5:\"Coiny\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Combo\";a:3:{s:5:\"label\";s:5:\"Combo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Comfortaa\";a:3:{s:5:\"label\";s:9:\"Comfortaa\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Comforter\";a:3:{s:5:\"label\";s:9:\"Comforter\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Comforter Brush\";a:3:{s:5:\"label\";s:15:\"Comforter Brush\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Comic Neue\";a:3:{s:5:\"label\";s:10:\"Comic Neue\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Coming Soon\";a:3:{s:5:\"label\";s:11:\"Coming Soon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Comme\";a:3:{s:5:\"label\";s:5:\"Comme\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Commissioner\";a:3:{s:5:\"label\";s:12:\"Commissioner\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Concert One\";a:3:{s:5:\"label\";s:11:\"Concert One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Condiment\";a:3:{s:5:\"label\";s:9:\"Condiment\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Content\";a:3:{s:5:\"label\";s:7:\"Content\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Contrail One\";a:3:{s:5:\"label\";s:12:\"Contrail One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Convergence\";a:3:{s:5:\"label\";s:11:\"Convergence\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Cookie\";a:3:{s:5:\"label\";s:6:\"Cookie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Copse\";a:3:{s:5:\"label\";s:5:\"Copse\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Corben\";a:3:{s:5:\"label\";s:6:\"Corben\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Corinthia\";a:3:{s:5:\"label\";s:9:\"Corinthia\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Cormorant\";a:3:{s:5:\"label\";s:9:\"Cormorant\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Cormorant Garamond\";a:3:{s:5:\"label\";s:18:\"Cormorant Garamond\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Cormorant Infant\";a:3:{s:5:\"label\";s:16:\"Cormorant Infant\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Cormorant SC\";a:3:{s:5:\"label\";s:12:\"Cormorant SC\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Cormorant Unicase\";a:3:{s:5:\"label\";s:17:\"Cormorant Unicase\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Cormorant Upright\";a:3:{s:5:\"label\";s:17:\"Cormorant Upright\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Courgette\";a:3:{s:5:\"label\";s:9:\"Courgette\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Courier Prime\";a:3:{s:5:\"label\";s:13:\"Courier Prime\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"Cousine\";a:3:{s:5:\"label\";s:7:\"Cousine\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:8:\"Coustard\";a:3:{s:5:\"label\";s:8:\"Coustard\";s:8:\"variants\";a:2:{i:0;s:3:\"900\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:21:\"Covered By Your Grace\";a:3:{s:5:\"label\";s:21:\"Covered By Your Grace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Crafty Girls\";a:3:{s:5:\"label\";s:12:\"Crafty Girls\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Creepster\";a:3:{s:5:\"label\";s:9:\"Creepster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Crete Round\";a:3:{s:5:\"label\";s:11:\"Crete Round\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Crimson Pro\";a:3:{s:5:\"label\";s:11:\"Crimson Pro\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Crimson Text\";a:3:{s:5:\"label\";s:12:\"Crimson Text\";s:8:\"variants\";a:6:{i:0;s:3:\"600\";i:1;s:9:\"600italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Croissant One\";a:3:{s:5:\"label\";s:13:\"Croissant One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Crushed\";a:3:{s:5:\"label\";s:7:\"Crushed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Cuprum\";a:3:{s:5:\"label\";s:6:\"Cuprum\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Cute Font\";a:3:{s:5:\"label\";s:9:\"Cute Font\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Cutive\";a:3:{s:5:\"label\";s:6:\"Cutive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Cutive Mono\";a:3:{s:5:\"label\";s:11:\"Cutive Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"DM Mono\";a:3:{s:5:\"label\";s:7:\"DM Mono\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"DM Sans\";a:3:{s:5:\"label\";s:7:\"DM Sans\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"DM Serif Display\";a:3:{s:5:\"label\";s:16:\"DM Serif Display\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"DM Serif Text\";a:3:{s:5:\"label\";s:13:\"DM Serif Text\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Damion\";a:3:{s:5:\"label\";s:6:\"Damion\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Dancing Script\";a:3:{s:5:\"label\";s:14:\"Dancing Script\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Dangrek\";a:3:{s:5:\"label\";s:7:\"Dangrek\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Darker Grotesque\";a:3:{s:5:\"label\";s:16:\"Darker Grotesque\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Darumadrop One\";a:3:{s:5:\"label\";s:14:\"Darumadrop One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"David Libre\";a:3:{s:5:\"label\";s:11:\"David Libre\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Dawning of a New Day\";a:3:{s:5:\"label\";s:20:\"Dawning of a New Day\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Days One\";a:3:{s:5:\"label\";s:8:\"Days One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dekko\";a:3:{s:5:\"label\";s:5:\"Dekko\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Dela Gothic One\";a:3:{s:5:\"label\";s:15:\"Dela Gothic One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Delicious Handrawn\";a:3:{s:5:\"label\";s:18:\"Delicious Handrawn\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Delius\";a:3:{s:5:\"label\";s:6:\"Delius\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:17:\"Delius Swash Caps\";a:3:{s:5:\"label\";s:17:\"Delius Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Delius Unicase\";a:3:{s:5:\"label\";s:14:\"Delius Unicase\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Della Respira\";a:3:{s:5:\"label\";s:13:\"Della Respira\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Denk One\";a:3:{s:5:\"label\";s:8:\"Denk One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Devonshire\";a:3:{s:5:\"label\";s:10:\"Devonshire\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Dhurjati\";a:3:{s:5:\"label\";s:8:\"Dhurjati\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Didact Gothic\";a:3:{s:5:\"label\";s:13:\"Didact Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Diphylleia\";a:3:{s:5:\"label\";s:10:\"Diphylleia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Diplomata\";a:3:{s:5:\"label\";s:9:\"Diplomata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Diplomata SC\";a:3:{s:5:\"label\";s:12:\"Diplomata SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Do Hyeon\";a:3:{s:5:\"label\";s:8:\"Do Hyeon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dokdo\";a:3:{s:5:\"label\";s:5:\"Dokdo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Domine\";a:3:{s:5:\"label\";s:6:\"Domine\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Donegal One\";a:3:{s:5:\"label\";s:11:\"Donegal One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Dongle\";a:3:{s:5:\"label\";s:6:\"Dongle\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Doppio One\";a:3:{s:5:\"label\";s:10:\"Doppio One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dorsa\";a:3:{s:5:\"label\";s:5:\"Dorsa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dosis\";a:3:{s:5:\"label\";s:5:\"Dosis\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"DotGothic16\";a:3:{s:5:\"label\";s:11:\"DotGothic16\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Dr Sugiyama\";a:3:{s:5:\"label\";s:11:\"Dr Sugiyama\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Duru Sans\";a:3:{s:5:\"label\";s:9:\"Duru Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"DynaPuff\";a:3:{s:5:\"label\";s:8:\"DynaPuff\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Dynalight\";a:3:{s:5:\"label\";s:9:\"Dynalight\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"EB Garamond\";a:3:{s:5:\"label\";s:11:\"EB Garamond\";s:8:\"variants\";a:10:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Eagle Lake\";a:3:{s:5:\"label\";s:10:\"Eagle Lake\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"East Sea Dokdo\";a:3:{s:5:\"label\";s:14:\"East Sea Dokdo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Eater\";a:3:{s:5:\"label\";s:5:\"Eater\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Economica\";a:3:{s:5:\"label\";s:9:\"Economica\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Eczar\";a:3:{s:5:\"label\";s:5:\"Eczar\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:22:\"Edu NSW ACT Foundation\";a:3:{s:5:\"label\";s:22:\"Edu NSW ACT Foundation\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Edu QLD Beginner\";a:3:{s:5:\"label\";s:16:\"Edu QLD Beginner\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Edu SA Beginner\";a:3:{s:5:\"label\";s:15:\"Edu SA Beginner\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Edu TAS Beginner\";a:3:{s:5:\"label\";s:16:\"Edu TAS Beginner\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:22:\"Edu VIC WA NT Beginner\";a:3:{s:5:\"label\";s:22:\"Edu VIC WA NT Beginner\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"El Messiri\";a:3:{s:5:\"label\";s:10:\"El Messiri\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Electrolize\";a:3:{s:5:\"label\";s:11:\"Electrolize\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Elsie\";a:3:{s:5:\"label\";s:5:\"Elsie\";s:8:\"variants\";a:2:{i:0;s:3:\"900\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Elsie Swash Caps\";a:3:{s:5:\"label\";s:16:\"Elsie Swash Caps\";s:8:\"variants\";a:2:{i:0;s:3:\"900\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Emblema One\";a:3:{s:5:\"label\";s:11:\"Emblema One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Emilys Candy\";a:3:{s:5:\"label\";s:12:\"Emilys Candy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Encode Sans\";a:3:{s:5:\"label\";s:11:\"Encode Sans\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Encode Sans Condensed\";a:3:{s:5:\"label\";s:21:\"Encode Sans Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Encode Sans Expanded\";a:3:{s:5:\"label\";s:20:\"Encode Sans Expanded\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Encode Sans SC\";a:3:{s:5:\"label\";s:14:\"Encode Sans SC\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:26:\"Encode Sans Semi Condensed\";a:3:{s:5:\"label\";s:26:\"Encode Sans Semi Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:25:\"Encode Sans Semi Expanded\";a:3:{s:5:\"label\";s:25:\"Encode Sans Semi Expanded\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Engagement\";a:3:{s:5:\"label\";s:10:\"Engagement\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Englebert\";a:3:{s:5:\"label\";s:9:\"Englebert\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Enriqueta\";a:3:{s:5:\"label\";s:9:\"Enriqueta\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Ephesis\";a:3:{s:5:\"label\";s:7:\"Ephesis\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Epilogue\";a:3:{s:5:\"label\";s:8:\"Epilogue\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Erica One\";a:3:{s:5:\"label\";s:9:\"Erica One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Esteban\";a:3:{s:5:\"label\";s:7:\"Esteban\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Estonia\";a:3:{s:5:\"label\";s:7:\"Estonia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Euphoria Script\";a:3:{s:5:\"label\";s:15:\"Euphoria Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Ewert\";a:3:{s:5:\"label\";s:5:\"Ewert\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:3:\"Exo\";a:3:{s:5:\"label\";s:3:\"Exo\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Exo 2\";a:3:{s:5:\"label\";s:5:\"Exo 2\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Expletus Sans\";a:3:{s:5:\"label\";s:13:\"Expletus Sans\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Explora\";a:3:{s:5:\"label\";s:7:\"Explora\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Fahkwang\";a:3:{s:5:\"label\";s:8:\"Fahkwang\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Familjen Grotesk\";a:3:{s:5:\"label\";s:16:\"Familjen Grotesk\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Fanwood Text\";a:3:{s:5:\"label\";s:12:\"Fanwood Text\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Farro\";a:3:{s:5:\"label\";s:5:\"Farro\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Farsan\";a:3:{s:5:\"label\";s:6:\"Farsan\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Fascinate\";a:3:{s:5:\"label\";s:9:\"Fascinate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Fascinate Inline\";a:3:{s:5:\"label\";s:16:\"Fascinate Inline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Faster One\";a:3:{s:5:\"label\";s:10:\"Faster One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Fasthand\";a:3:{s:5:\"label\";s:8:\"Fasthand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Fauna One\";a:3:{s:5:\"label\";s:9:\"Fauna One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Faustina\";a:3:{s:5:\"label\";s:8:\"Faustina\";s:8:\"variants\";a:12:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Federant\";a:3:{s:5:\"label\";s:8:\"Federant\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Federo\";a:3:{s:5:\"label\";s:6:\"Federo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Felipa\";a:3:{s:5:\"label\";s:6:\"Felipa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Fenix\";a:3:{s:5:\"label\";s:5:\"Fenix\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Festive\";a:3:{s:5:\"label\";s:7:\"Festive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Figtree\";a:3:{s:5:\"label\";s:7:\"Figtree\";s:8:\"variants\";a:14:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Finger Paint\";a:3:{s:5:\"label\";s:12:\"Finger Paint\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Finlandica\";a:3:{s:5:\"label\";s:10:\"Finlandica\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Fira Code\";a:3:{s:5:\"label\";s:9:\"Fira Code\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:9:\"Fira Mono\";a:3:{s:5:\"label\";s:9:\"Fira Mono\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:9:\"Fira Sans\";a:3:{s:5:\"label\";s:9:\"Fira Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Fira Sans Condensed\";a:3:{s:5:\"label\";s:19:\"Fira Sans Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:25:\"Fira Sans Extra Condensed\";a:3:{s:5:\"label\";s:25:\"Fira Sans Extra Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Fjalla One\";a:3:{s:5:\"label\";s:10:\"Fjalla One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Fjord One\";a:3:{s:5:\"label\";s:9:\"Fjord One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Flamenco\";a:3:{s:5:\"label\";s:8:\"Flamenco\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Flavors\";a:3:{s:5:\"label\";s:7:\"Flavors\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Fleur De Leah\";a:3:{s:5:\"label\";s:13:\"Fleur De Leah\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Flow Block\";a:3:{s:5:\"label\";s:10:\"Flow Block\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Flow Circular\";a:3:{s:5:\"label\";s:13:\"Flow Circular\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Flow Rounded\";a:3:{s:5:\"label\";s:12:\"Flow Rounded\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Foldit\";a:3:{s:5:\"label\";s:6:\"Foldit\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Fondamento\";a:3:{s:5:\"label\";s:10:\"Fondamento\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Fontdiner Swanky\";a:3:{s:5:\"label\";s:16:\"Fontdiner Swanky\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Forum\";a:3:{s:5:\"label\";s:5:\"Forum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Fragment Mono\";a:3:{s:5:\"label\";s:13:\"Fragment Mono\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:12:\"Francois One\";a:3:{s:5:\"label\";s:12:\"Francois One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Frank Ruhl Libre\";a:3:{s:5:\"label\";s:16:\"Frank Ruhl Libre\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Fraunces\";a:3:{s:5:\"label\";s:8:\"Fraunces\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Freckle Face\";a:3:{s:5:\"label\";s:12:\"Freckle Face\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"Fredericka the Great\";a:3:{s:5:\"label\";s:20:\"Fredericka the Great\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Fredoka\";a:3:{s:5:\"label\";s:7:\"Fredoka\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Freehand\";a:3:{s:5:\"label\";s:8:\"Freehand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Fresca\";a:3:{s:5:\"label\";s:6:\"Fresca\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Frijole\";a:3:{s:5:\"label\";s:7:\"Frijole\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Fruktur\";a:3:{s:5:\"label\";s:7:\"Fruktur\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Fugaz One\";a:3:{s:5:\"label\";s:9:\"Fugaz One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Fuggles\";a:3:{s:5:\"label\";s:7:\"Fuggles\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Fuzzy Bubbles\";a:3:{s:5:\"label\";s:13:\"Fuzzy Bubbles\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"GFS Didot\";a:3:{s:5:\"label\";s:9:\"GFS Didot\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"GFS Neohellenic\";a:3:{s:5:\"label\";s:15:\"GFS Neohellenic\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Gabriela\";a:3:{s:5:\"label\";s:8:\"Gabriela\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Gaegu\";a:3:{s:5:\"label\";s:5:\"Gaegu\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Gafata\";a:3:{s:5:\"label\";s:6:\"Gafata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Gajraj One\";a:3:{s:5:\"label\";s:10:\"Gajraj One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Galada\";a:3:{s:5:\"label\";s:6:\"Galada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Galdeano\";a:3:{s:5:\"label\";s:8:\"Galdeano\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Galindo\";a:3:{s:5:\"label\";s:7:\"Galindo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Gamja Flower\";a:3:{s:5:\"label\";s:12:\"Gamja Flower\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Gantari\";a:3:{s:5:\"label\";s:7:\"Gantari\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Gasoek One\";a:3:{s:5:\"label\";s:10:\"Gasoek One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Gayathri\";a:3:{s:5:\"label\";s:8:\"Gayathri\";s:8:\"variants\";a:3:{i:0;s:3:\"100\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Gelasio\";a:3:{s:5:\"label\";s:7:\"Gelasio\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Gemunu Libre\";a:3:{s:5:\"label\";s:12:\"Gemunu Libre\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Genos\";a:3:{s:5:\"label\";s:5:\"Genos\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Gentium Book Plus\";a:3:{s:5:\"label\";s:17:\"Gentium Book Plus\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Gentium Plus\";a:3:{s:5:\"label\";s:12:\"Gentium Plus\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:3:\"Geo\";a:3:{s:5:\"label\";s:3:\"Geo\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Geologica\";a:3:{s:5:\"label\";s:9:\"Geologica\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Georama\";a:3:{s:5:\"label\";s:7:\"Georama\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Geostar\";a:3:{s:5:\"label\";s:7:\"Geostar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Geostar Fill\";a:3:{s:5:\"label\";s:12:\"Geostar Fill\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Germania One\";a:3:{s:5:\"label\";s:12:\"Germania One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Gideon Roman\";a:3:{s:5:\"label\";s:12:\"Gideon Roman\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Gidugu\";a:3:{s:5:\"label\";s:6:\"Gidugu\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Gilda Display\";a:3:{s:5:\"label\";s:13:\"Gilda Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Girassol\";a:3:{s:5:\"label\";s:8:\"Girassol\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Give You Glory\";a:3:{s:5:\"label\";s:14:\"Give You Glory\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Glass Antiqua\";a:3:{s:5:\"label\";s:13:\"Glass Antiqua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Glegoo\";a:3:{s:5:\"label\";s:6:\"Glegoo\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Gloock\";a:3:{s:5:\"label\";s:6:\"Gloock\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Gloria Hallelujah\";a:3:{s:5:\"label\";s:17:\"Gloria Hallelujah\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Glory\";a:3:{s:5:\"label\";s:5:\"Glory\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Gluten\";a:3:{s:5:\"label\";s:6:\"Gluten\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Goblin One\";a:3:{s:5:\"label\";s:10:\"Goblin One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Gochi Hand\";a:3:{s:5:\"label\";s:10:\"Gochi Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Goldman\";a:3:{s:5:\"label\";s:7:\"Goldman\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Golos Text\";a:3:{s:5:\"label\";s:10:\"Golos Text\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Gorditas\";a:3:{s:5:\"label\";s:8:\"Gorditas\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Gothic A1\";a:3:{s:5:\"label\";s:9:\"Gothic A1\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Gotu\";a:3:{s:5:\"label\";s:4:\"Gotu\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Goudy Bookletter 1911\";a:3:{s:5:\"label\";s:21:\"Goudy Bookletter 1911\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Gowun Batang\";a:3:{s:5:\"label\";s:12:\"Gowun Batang\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Gowun Dodum\";a:3:{s:5:\"label\";s:11:\"Gowun Dodum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Graduate\";a:3:{s:5:\"label\";s:8:\"Graduate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Grand Hotel\";a:3:{s:5:\"label\";s:11:\"Grand Hotel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Grandiflora One\";a:3:{s:5:\"label\";s:15:\"Grandiflora One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Grandstander\";a:3:{s:5:\"label\";s:12:\"Grandstander\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Grape Nuts\";a:3:{s:5:\"label\";s:10:\"Grape Nuts\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Gravitas One\";a:3:{s:5:\"label\";s:12:\"Gravitas One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Great Vibes\";a:3:{s:5:\"label\";s:11:\"Great Vibes\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Grechen Fuemen\";a:3:{s:5:\"label\";s:14:\"Grechen Fuemen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Grenze\";a:3:{s:5:\"label\";s:6:\"Grenze\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Grenze Gotisch\";a:3:{s:5:\"label\";s:14:\"Grenze Gotisch\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Grey Qo\";a:3:{s:5:\"label\";s:7:\"Grey Qo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Griffy\";a:3:{s:5:\"label\";s:6:\"Griffy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Gruppo\";a:3:{s:5:\"label\";s:6:\"Gruppo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Gudea\";a:3:{s:5:\"label\";s:5:\"Gudea\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Gugi\";a:3:{s:5:\"label\";s:4:\"Gugi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Gulzar\";a:3:{s:5:\"label\";s:6:\"Gulzar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Gupter\";a:3:{s:5:\"label\";s:6:\"Gupter\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Gurajada\";a:3:{s:5:\"label\";s:8:\"Gurajada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Gwendolyn\";a:3:{s:5:\"label\";s:9:\"Gwendolyn\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Habibi\";a:3:{s:5:\"label\";s:6:\"Habibi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Hachi Maru Pop\";a:3:{s:5:\"label\";s:14:\"Hachi Maru Pop\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Hahmlet\";a:3:{s:5:\"label\";s:7:\"Hahmlet\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Halant\";a:3:{s:5:\"label\";s:6:\"Halant\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Hammersmith One\";a:3:{s:5:\"label\";s:15:\"Hammersmith One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Hanalei\";a:3:{s:5:\"label\";s:7:\"Hanalei\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Hanalei Fill\";a:3:{s:5:\"label\";s:12:\"Hanalei Fill\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Handlee\";a:3:{s:5:\"label\";s:7:\"Handlee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Hanken Grotesk\";a:3:{s:5:\"label\";s:14:\"Hanken Grotesk\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Hanuman\";a:3:{s:5:\"label\";s:7:\"Hanuman\";s:8:\"variants\";a:5:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"900\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Happy Monkey\";a:3:{s:5:\"label\";s:12:\"Happy Monkey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Harmattan\";a:3:{s:5:\"label\";s:9:\"Harmattan\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Headland One\";a:3:{s:5:\"label\";s:12:\"Headland One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Heebo\";a:3:{s:5:\"label\";s:5:\"Heebo\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Henny Penny\";a:3:{s:5:\"label\";s:11:\"Henny Penny\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Hepta Slab\";a:3:{s:5:\"label\";s:10:\"Hepta Slab\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Herr Von Muellerhoff\";a:3:{s:5:\"label\";s:20:\"Herr Von Muellerhoff\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Hi Melody\";a:3:{s:5:\"label\";s:9:\"Hi Melody\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Hina Mincho\";a:3:{s:5:\"label\";s:11:\"Hina Mincho\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Hind\";a:3:{s:5:\"label\";s:4:\"Hind\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Hind Guntur\";a:3:{s:5:\"label\";s:11:\"Hind Guntur\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Hind Madurai\";a:3:{s:5:\"label\";s:12:\"Hind Madurai\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Hind Siliguri\";a:3:{s:5:\"label\";s:13:\"Hind Siliguri\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Hind Vadodara\";a:3:{s:5:\"label\";s:13:\"Hind Vadodara\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Holtwood One SC\";a:3:{s:5:\"label\";s:15:\"Holtwood One SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Homemade Apple\";a:3:{s:5:\"label\";s:14:\"Homemade Apple\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Homenaje\";a:3:{s:5:\"label\";s:8:\"Homenaje\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Hubballi\";a:3:{s:5:\"label\";s:8:\"Hubballi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Hurricane\";a:3:{s:5:\"label\";s:9:\"Hurricane\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"IBM Plex Mono\";a:3:{s:5:\"label\";s:13:\"IBM Plex Mono\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:13:\"IBM Plex Sans\";a:3:{s:5:\"label\";s:13:\"IBM Plex Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"IBM Plex Sans Arabic\";a:3:{s:5:\"label\";s:20:\"IBM Plex Sans Arabic\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:23:\"IBM Plex Sans Condensed\";a:3:{s:5:\"label\";s:23:\"IBM Plex Sans Condensed\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:24:\"IBM Plex Sans Devanagari\";a:3:{s:5:\"label\";s:24:\"IBM Plex Sans Devanagari\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"IBM Plex Sans Hebrew\";a:3:{s:5:\"label\";s:20:\"IBM Plex Sans Hebrew\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"IBM Plex Sans JP\";a:3:{s:5:\"label\";s:16:\"IBM Plex Sans JP\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"IBM Plex Sans KR\";a:3:{s:5:\"label\";s:16:\"IBM Plex Sans KR\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"IBM Plex Sans Thai\";a:3:{s:5:\"label\";s:18:\"IBM Plex Sans Thai\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:25:\"IBM Plex Sans Thai Looped\";a:3:{s:5:\"label\";s:25:\"IBM Plex Sans Thai Looped\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"IBM Plex Serif\";a:3:{s:5:\"label\";s:14:\"IBM Plex Serif\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"IM Fell DW Pica\";a:3:{s:5:\"label\";s:15:\"IM Fell DW Pica\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"IM Fell DW Pica SC\";a:3:{s:5:\"label\";s:18:\"IM Fell DW Pica SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"IM Fell Double Pica\";a:3:{s:5:\"label\";s:19:\"IM Fell Double Pica\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:22:\"IM Fell Double Pica SC\";a:3:{s:5:\"label\";s:22:\"IM Fell Double Pica SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"IM Fell English\";a:3:{s:5:\"label\";s:15:\"IM Fell English\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"IM Fell English SC\";a:3:{s:5:\"label\";s:18:\"IM Fell English SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"IM Fell French Canon\";a:3:{s:5:\"label\";s:20:\"IM Fell French Canon\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"IM Fell French Canon SC\";a:3:{s:5:\"label\";s:23:\"IM Fell French Canon SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"IM Fell Great Primer\";a:3:{s:5:\"label\";s:20:\"IM Fell Great Primer\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"IM Fell Great Primer SC\";a:3:{s:5:\"label\";s:23:\"IM Fell Great Primer SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Ibarra Real Nova\";a:3:{s:5:\"label\";s:16:\"Ibarra Real Nova\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Iceberg\";a:3:{s:5:\"label\";s:7:\"Iceberg\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Iceland\";a:3:{s:5:\"label\";s:7:\"Iceland\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Imbue\";a:3:{s:5:\"label\";s:5:\"Imbue\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Imperial Script\";a:3:{s:5:\"label\";s:15:\"Imperial Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Imprima\";a:3:{s:5:\"label\";s:7:\"Imprima\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Inconsolata\";a:3:{s:5:\"label\";s:11:\"Inconsolata\";s:8:\"variants\";a:8:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:5:\"Inder\";a:3:{s:5:\"label\";s:5:\"Inder\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Indie Flower\";a:3:{s:5:\"label\";s:12:\"Indie Flower\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Ingrid Darling\";a:3:{s:5:\"label\";s:14:\"Ingrid Darling\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Inika\";a:3:{s:5:\"label\";s:5:\"Inika\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Inknut Antiqua\";a:3:{s:5:\"label\";s:14:\"Inknut Antiqua\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Inria Sans\";a:3:{s:5:\"label\";s:10:\"Inria Sans\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Inria Serif\";a:3:{s:5:\"label\";s:11:\"Inria Serif\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Inspiration\";a:3:{s:5:\"label\";s:11:\"Inspiration\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Instrument Sans\";a:3:{s:5:\"label\";s:15:\"Instrument Sans\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Instrument Serif\";a:3:{s:5:\"label\";s:16:\"Instrument Serif\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Inter\";a:3:{s:5:\"label\";s:5:\"Inter\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Inter Tight\";a:3:{s:5:\"label\";s:11:\"Inter Tight\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Irish Grover\";a:3:{s:5:\"label\";s:12:\"Irish Grover\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Island Moments\";a:3:{s:5:\"label\";s:14:\"Island Moments\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Istok Web\";a:3:{s:5:\"label\";s:9:\"Istok Web\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Italiana\";a:3:{s:5:\"label\";s:8:\"Italiana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Italianno\";a:3:{s:5:\"label\";s:9:\"Italianno\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Itim\";a:3:{s:5:\"label\";s:4:\"Itim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Jacques Francois\";a:3:{s:5:\"label\";s:16:\"Jacques Francois\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"Jacques Francois Shadow\";a:3:{s:5:\"label\";s:23:\"Jacques Francois Shadow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Jaldi\";a:3:{s:5:\"label\";s:5:\"Jaldi\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"JetBrains Mono\";a:3:{s:5:\"label\";s:14:\"JetBrains Mono\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:14:\"Jim Nightshade\";a:3:{s:5:\"label\";s:14:\"Jim Nightshade\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Joan\";a:3:{s:5:\"label\";s:4:\"Joan\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Jockey One\";a:3:{s:5:\"label\";s:10:\"Jockey One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Jolly Lodger\";a:3:{s:5:\"label\";s:12:\"Jolly Lodger\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Jomhuria\";a:3:{s:5:\"label\";s:8:\"Jomhuria\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Jomolhari\";a:3:{s:5:\"label\";s:9:\"Jomolhari\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Josefin Sans\";a:3:{s:5:\"label\";s:12:\"Josefin Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Josefin Slab\";a:3:{s:5:\"label\";s:12:\"Josefin Slab\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Jost\";a:3:{s:5:\"label\";s:4:\"Jost\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Joti One\";a:3:{s:5:\"label\";s:8:\"Joti One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:3:\"Jua\";a:3:{s:5:\"label\";s:3:\"Jua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Judson\";a:3:{s:5:\"label\";s:6:\"Judson\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Julee\";a:3:{s:5:\"label\";s:5:\"Julee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Julius Sans One\";a:3:{s:5:\"label\";s:15:\"Julius Sans One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Junge\";a:3:{s:5:\"label\";s:5:\"Junge\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Jura\";a:3:{s:5:\"label\";s:4:\"Jura\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Just Another Hand\";a:3:{s:5:\"label\";s:17:\"Just Another Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:23:\"Just Me Again Down Here\";a:3:{s:5:\"label\";s:23:\"Just Me Again Down Here\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:3:\"K2D\";a:3:{s:5:\"label\";s:3:\"K2D\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Kablammo\";a:3:{s:5:\"label\";s:8:\"Kablammo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Kadwa\";a:3:{s:5:\"label\";s:5:\"Kadwa\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Kaisei Decol\";a:3:{s:5:\"label\";s:12:\"Kaisei Decol\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Kaisei HarunoUmi\";a:3:{s:5:\"label\";s:16:\"Kaisei HarunoUmi\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Kaisei Opti\";a:3:{s:5:\"label\";s:11:\"Kaisei Opti\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Kaisei Tokumin\";a:3:{s:5:\"label\";s:14:\"Kaisei Tokumin\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:3:\"800\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Kalam\";a:3:{s:5:\"label\";s:5:\"Kalam\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Kameron\";a:3:{s:5:\"label\";s:7:\"Kameron\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Kanit\";a:3:{s:5:\"label\";s:5:\"Kanit\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Kantumruy Pro\";a:3:{s:5:\"label\";s:13:\"Kantumruy Pro\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Karantina\";a:3:{s:5:\"label\";s:9:\"Karantina\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Karla\";a:3:{s:5:\"label\";s:5:\"Karla\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Karma\";a:3:{s:5:\"label\";s:5:\"Karma\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Katibeh\";a:3:{s:5:\"label\";s:7:\"Katibeh\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Kaushan Script\";a:3:{s:5:\"label\";s:14:\"Kaushan Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Kavivanar\";a:3:{s:5:\"label\";s:9:\"Kavivanar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Kavoon\";a:3:{s:5:\"label\";s:6:\"Kavoon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Kdam Thmor Pro\";a:3:{s:5:\"label\";s:14:\"Kdam Thmor Pro\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Keania One\";a:3:{s:5:\"label\";s:10:\"Keania One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Kelly Slab\";a:3:{s:5:\"label\";s:10:\"Kelly Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Kenia\";a:3:{s:5:\"label\";s:5:\"Kenia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Khand\";a:3:{s:5:\"label\";s:5:\"Khand\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Khmer\";a:3:{s:5:\"label\";s:5:\"Khmer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Khula\";a:3:{s:5:\"label\";s:5:\"Khula\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Kings\";a:3:{s:5:\"label\";s:5:\"Kings\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Kirang Haerang\";a:3:{s:5:\"label\";s:14:\"Kirang Haerang\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Kite One\";a:3:{s:5:\"label\";s:8:\"Kite One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kiwi Maru\";a:3:{s:5:\"label\";s:9:\"Kiwi Maru\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Klee One\";a:3:{s:5:\"label\";s:8:\"Klee One\";s:8:\"variants\";a:2:{i:0;s:3:\"600\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Knewave\";a:3:{s:5:\"label\";s:7:\"Knewave\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"KoHo\";a:3:{s:5:\"label\";s:4:\"KoHo\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kodchasan\";a:3:{s:5:\"label\";s:9:\"Kodchasan\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Koh Santepheap\";a:3:{s:5:\"label\";s:14:\"Koh Santepheap\";s:8:\"variants\";a:5:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"900\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Kolker Brush\";a:3:{s:5:\"label\";s:12:\"Kolker Brush\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:19:\"Konkhmer Sleokchher\";a:3:{s:5:\"label\";s:19:\"Konkhmer Sleokchher\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Kosugi\";a:3:{s:5:\"label\";s:6:\"Kosugi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Kosugi Maru\";a:3:{s:5:\"label\";s:11:\"Kosugi Maru\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kotta One\";a:3:{s:5:\"label\";s:9:\"Kotta One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Koulen\";a:3:{s:5:\"label\";s:6:\"Koulen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Kranky\";a:3:{s:5:\"label\";s:6:\"Kranky\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Kreon\";a:3:{s:5:\"label\";s:5:\"Kreon\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Kristi\";a:3:{s:5:\"label\";s:6:\"Kristi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Krona One\";a:3:{s:5:\"label\";s:9:\"Krona One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Krub\";a:3:{s:5:\"label\";s:4:\"Krub\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Kufam\";a:3:{s:5:\"label\";s:5:\"Kufam\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Kulim Park\";a:3:{s:5:\"label\";s:10:\"Kulim Park\";s:8:\"variants\";a:10:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kumar One\";a:3:{s:5:\"label\";s:9:\"Kumar One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Kumar One Outline\";a:3:{s:5:\"label\";s:17:\"Kumar One Outline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Kumbh Sans\";a:3:{s:5:\"label\";s:10:\"Kumbh Sans\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Kurale\";a:3:{s:5:\"label\";s:6:\"Kurale\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"La Belle Aurore\";a:3:{s:5:\"label\";s:15:\"La Belle Aurore\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Labrada\";a:3:{s:5:\"label\";s:7:\"Labrada\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Lacquer\";a:3:{s:5:\"label\";s:7:\"Lacquer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Laila\";a:3:{s:5:\"label\";s:5:\"Laila\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lakki Reddy\";a:3:{s:5:\"label\";s:11:\"Lakki Reddy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Lalezar\";a:3:{s:5:\"label\";s:7:\"Lalezar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Lancelot\";a:3:{s:5:\"label\";s:8:\"Lancelot\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Langar\";a:3:{s:5:\"label\";s:6:\"Langar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Lateef\";a:3:{s:5:\"label\";s:6:\"Lateef\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Lato\";a:3:{s:5:\"label\";s:4:\"Lato\";s:8:\"variants\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Lavishly Yours\";a:3:{s:5:\"label\";s:14:\"Lavishly Yours\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"League Gothic\";a:3:{s:5:\"label\";s:13:\"League Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"League Script\";a:3:{s:5:\"label\";s:13:\"League Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"League Spartan\";a:3:{s:5:\"label\";s:14:\"League Spartan\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Leckerli One\";a:3:{s:5:\"label\";s:12:\"Leckerli One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Ledger\";a:3:{s:5:\"label\";s:6:\"Ledger\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Lekton\";a:3:{s:5:\"label\";s:6:\"Lekton\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Lemon\";a:3:{s:5:\"label\";s:5:\"Lemon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Lemonada\";a:3:{s:5:\"label\";s:8:\"Lemonada\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Lexend\";a:3:{s:5:\"label\";s:6:\"Lexend\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Deca\";a:3:{s:5:\"label\";s:11:\"Lexend Deca\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Lexend Exa\";a:3:{s:5:\"label\";s:10:\"Lexend Exa\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Giga\";a:3:{s:5:\"label\";s:11:\"Lexend Giga\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Mega\";a:3:{s:5:\"label\";s:11:\"Lexend Mega\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Peta\";a:3:{s:5:\"label\";s:11:\"Lexend Peta\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Tera\";a:3:{s:5:\"label\";s:11:\"Lexend Tera\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Lexend Zetta\";a:3:{s:5:\"label\";s:12:\"Lexend Zetta\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Libre Barcode 128\";a:3:{s:5:\"label\";s:17:\"Libre Barcode 128\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:22:\"Libre Barcode 128 Text\";a:3:{s:5:\"label\";s:22:\"Libre Barcode 128 Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Libre Barcode 39\";a:3:{s:5:\"label\";s:16:\"Libre Barcode 39\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:25:\"Libre Barcode 39 Extended\";a:3:{s:5:\"label\";s:25:\"Libre Barcode 39 Extended\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:30:\"Libre Barcode 39 Extended Text\";a:3:{s:5:\"label\";s:30:\"Libre Barcode 39 Extended Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:21:\"Libre Barcode 39 Text\";a:3:{s:5:\"label\";s:21:\"Libre Barcode 39 Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:24:\"Libre Barcode EAN13 Text\";a:3:{s:5:\"label\";s:24:\"Libre Barcode EAN13 Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Libre Baskerville\";a:3:{s:5:\"label\";s:17:\"Libre Baskerville\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Libre Bodoni\";a:3:{s:5:\"label\";s:12:\"Libre Bodoni\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Libre Caslon Display\";a:3:{s:5:\"label\";s:20:\"Libre Caslon Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Libre Caslon Text\";a:3:{s:5:\"label\";s:17:\"Libre Caslon Text\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Libre Franklin\";a:3:{s:5:\"label\";s:14:\"Libre Franklin\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Licorice\";a:3:{s:5:\"label\";s:8:\"Licorice\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Life Savers\";a:3:{s:5:\"label\";s:11:\"Life Savers\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Lilita One\";a:3:{s:5:\"label\";s:10:\"Lilita One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Lily Script One\";a:3:{s:5:\"label\";s:15:\"Lily Script One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Limelight\";a:3:{s:5:\"label\";s:9:\"Limelight\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Linden Hill\";a:3:{s:5:\"label\";s:11:\"Linden Hill\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Literata\";a:3:{s:5:\"label\";s:8:\"Literata\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Liu Jian Mao Cao\";a:3:{s:5:\"label\";s:16:\"Liu Jian Mao Cao\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Livvic\";a:3:{s:5:\"label\";s:6:\"Livvic\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Lobster\";a:3:{s:5:\"label\";s:7:\"Lobster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Lobster Two\";a:3:{s:5:\"label\";s:11:\"Lobster Two\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Londrina Outline\";a:3:{s:5:\"label\";s:16:\"Londrina Outline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Londrina Shadow\";a:3:{s:5:\"label\";s:15:\"Londrina Shadow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Londrina Sketch\";a:3:{s:5:\"label\";s:15:\"Londrina Sketch\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Londrina Solid\";a:3:{s:5:\"label\";s:14:\"Londrina Solid\";s:8:\"variants\";a:4:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"900\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Long Cang\";a:3:{s:5:\"label\";s:9:\"Long Cang\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Lora\";a:3:{s:5:\"label\";s:4:\"Lora\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Love Light\";a:3:{s:5:\"label\";s:10:\"Love Light\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:21:\"Love Ya Like A Sister\";a:3:{s:5:\"label\";s:21:\"Love Ya Like A Sister\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Loved by the King\";a:3:{s:5:\"label\";s:17:\"Loved by the King\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Lovers Quarrel\";a:3:{s:5:\"label\";s:14:\"Lovers Quarrel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Luckiest Guy\";a:3:{s:5:\"label\";s:12:\"Luckiest Guy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Lusitana\";a:3:{s:5:\"label\";s:8:\"Lusitana\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Lustria\";a:3:{s:5:\"label\";s:7:\"Lustria\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Luxurious Roman\";a:3:{s:5:\"label\";s:15:\"Luxurious Roman\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Luxurious Script\";a:3:{s:5:\"label\";s:16:\"Luxurious Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"M PLUS 1\";a:3:{s:5:\"label\";s:8:\"M PLUS 1\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"M PLUS 1 Code\";a:3:{s:5:\"label\";s:13:\"M PLUS 1 Code\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"M PLUS 1p\";a:3:{s:5:\"label\";s:9:\"M PLUS 1p\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"M PLUS 2\";a:3:{s:5:\"label\";s:8:\"M PLUS 2\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"M PLUS Code Latin\";a:3:{s:5:\"label\";s:17:\"M PLUS Code Latin\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"M PLUS Rounded 1c\";a:3:{s:5:\"label\";s:17:\"M PLUS Rounded 1c\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Ma Shan Zheng\";a:3:{s:5:\"label\";s:13:\"Ma Shan Zheng\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Macondo\";a:3:{s:5:\"label\";s:7:\"Macondo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Macondo Swash Caps\";a:3:{s:5:\"label\";s:18:\"Macondo Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Mada\";a:3:{s:5:\"label\";s:4:\"Mada\";s:8:\"variants\";a:8:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Magra\";a:3:{s:5:\"label\";s:5:\"Magra\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Maiden Orange\";a:3:{s:5:\"label\";s:13:\"Maiden Orange\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Maitree\";a:3:{s:5:\"label\";s:7:\"Maitree\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Major Mono Display\";a:3:{s:5:\"label\";s:18:\"Major Mono Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:4:\"Mako\";a:3:{s:5:\"label\";s:4:\"Mako\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Mali\";a:3:{s:5:\"label\";s:4:\"Mali\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Mallanna\";a:3:{s:5:\"label\";s:8:\"Mallanna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Mandali\";a:3:{s:5:\"label\";s:7:\"Mandali\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Manjari\";a:3:{s:5:\"label\";s:7:\"Manjari\";s:8:\"variants\";a:3:{i:0;s:3:\"100\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Manrope\";a:3:{s:5:\"label\";s:7:\"Manrope\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Mansalva\";a:3:{s:5:\"label\";s:8:\"Mansalva\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Manuale\";a:3:{s:5:\"label\";s:7:\"Manuale\";s:8:\"variants\";a:12:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Marcellus\";a:3:{s:5:\"label\";s:9:\"Marcellus\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Marcellus SC\";a:3:{s:5:\"label\";s:12:\"Marcellus SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Marck Script\";a:3:{s:5:\"label\";s:12:\"Marck Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Margarine\";a:3:{s:5:\"label\";s:9:\"Margarine\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Marhey\";a:3:{s:5:\"label\";s:6:\"Marhey\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Markazi Text\";a:3:{s:5:\"label\";s:12:\"Markazi Text\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Marko One\";a:3:{s:5:\"label\";s:9:\"Marko One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Marmelad\";a:3:{s:5:\"label\";s:8:\"Marmelad\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Martel\";a:3:{s:5:\"label\";s:6:\"Martel\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Martel Sans\";a:3:{s:5:\"label\";s:11:\"Martel Sans\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Martian Mono\";a:3:{s:5:\"label\";s:12:\"Martian Mono\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:6:\"Marvel\";a:3:{s:5:\"label\";s:6:\"Marvel\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Mate\";a:3:{s:5:\"label\";s:4:\"Mate\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Mate SC\";a:3:{s:5:\"label\";s:7:\"Mate SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Material Icons\";a:3:{s:5:\"label\";s:14:\"Material Icons\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:23:\"Material Icons Outlined\";a:3:{s:5:\"label\";s:23:\"Material Icons Outlined\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:20:\"Material Icons Round\";a:3:{s:5:\"label\";s:20:\"Material Icons Round\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:20:\"Material Icons Sharp\";a:3:{s:5:\"label\";s:20:\"Material Icons Sharp\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:23:\"Material Icons Two Tone\";a:3:{s:5:\"label\";s:23:\"Material Icons Two Tone\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:25:\"Material Symbols Outlined\";a:3:{s:5:\"label\";s:25:\"Material Symbols Outlined\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:24:\"Material Symbols Rounded\";a:3:{s:5:\"label\";s:24:\"Material Symbols Rounded\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:22:\"Material Symbols Sharp\";a:3:{s:5:\"label\";s:22:\"Material Symbols Sharp\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:9:\"Maven Pro\";a:3:{s:5:\"label\";s:9:\"Maven Pro\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"McLaren\";a:3:{s:5:\"label\";s:7:\"McLaren\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Mea Culpa\";a:3:{s:5:\"label\";s:9:\"Mea Culpa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Meddon\";a:3:{s:5:\"label\";s:6:\"Meddon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"MedievalSharp\";a:3:{s:5:\"label\";s:13:\"MedievalSharp\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Medula One\";a:3:{s:5:\"label\";s:10:\"Medula One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Meera Inimai\";a:3:{s:5:\"label\";s:12:\"Meera Inimai\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Megrim\";a:3:{s:5:\"label\";s:6:\"Megrim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Meie Script\";a:3:{s:5:\"label\";s:11:\"Meie Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Meow Script\";a:3:{s:5:\"label\";s:11:\"Meow Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Merienda\";a:3:{s:5:\"label\";s:8:\"Merienda\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Merriweather\";a:3:{s:5:\"label\";s:12:\"Merriweather\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Merriweather Sans\";a:3:{s:5:\"label\";s:17:\"Merriweather Sans\";s:8:\"variants\";a:12:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Metal\";a:3:{s:5:\"label\";s:5:\"Metal\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Metal Mania\";a:3:{s:5:\"label\";s:11:\"Metal Mania\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Metamorphous\";a:3:{s:5:\"label\";s:12:\"Metamorphous\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Metrophobic\";a:3:{s:5:\"label\";s:11:\"Metrophobic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Michroma\";a:3:{s:5:\"label\";s:8:\"Michroma\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Milonga\";a:3:{s:5:\"label\";s:7:\"Milonga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Miltonian\";a:3:{s:5:\"label\";s:9:\"Miltonian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Miltonian Tattoo\";a:3:{s:5:\"label\";s:16:\"Miltonian Tattoo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Mina\";a:3:{s:5:\"label\";s:4:\"Mina\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Mingzat\";a:3:{s:5:\"label\";s:7:\"Mingzat\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Miniver\";a:3:{s:5:\"label\";s:7:\"Miniver\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Miriam Libre\";a:3:{s:5:\"label\";s:12:\"Miriam Libre\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Mirza\";a:3:{s:5:\"label\";s:5:\"Mirza\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Miss Fajardose\";a:3:{s:5:\"label\";s:14:\"Miss Fajardose\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Mitr\";a:3:{s:5:\"label\";s:4:\"Mitr\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Mochiy Pop One\";a:3:{s:5:\"label\";s:14:\"Mochiy Pop One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Mochiy Pop P One\";a:3:{s:5:\"label\";s:16:\"Mochiy Pop P One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Modak\";a:3:{s:5:\"label\";s:5:\"Modak\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Modern Antiqua\";a:3:{s:5:\"label\";s:14:\"Modern Antiqua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Mogra\";a:3:{s:5:\"label\";s:5:\"Mogra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Mohave\";a:3:{s:5:\"label\";s:6:\"Mohave\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Moirai One\";a:3:{s:5:\"label\";s:10:\"Moirai One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Molengo\";a:3:{s:5:\"label\";s:7:\"Molengo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Molle\";a:3:{s:5:\"label\";s:5:\"Molle\";s:8:\"variants\";a:1:{i:0;s:6:\"italic\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Monda\";a:3:{s:5:\"label\";s:5:\"Monda\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Monofett\";a:3:{s:5:\"label\";s:8:\"Monofett\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:14:\"Monomaniac One\";a:3:{s:5:\"label\";s:14:\"Monomaniac One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Monoton\";a:3:{s:5:\"label\";s:7:\"Monoton\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"Monsieur La Doulaise\";a:3:{s:5:\"label\";s:20:\"Monsieur La Doulaise\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Montaga\";a:3:{s:5:\"label\";s:7:\"Montaga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Montagu Slab\";a:3:{s:5:\"label\";s:12:\"Montagu Slab\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"MonteCarlo\";a:3:{s:5:\"label\";s:10:\"MonteCarlo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Montez\";a:3:{s:5:\"label\";s:6:\"Montez\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Montserrat\";a:3:{s:5:\"label\";s:10:\"Montserrat\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Montserrat Alternates\";a:3:{s:5:\"label\";s:21:\"Montserrat Alternates\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Montserrat Subrayada\";a:3:{s:5:\"label\";s:20:\"Montserrat Subrayada\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Moo Lah Lah\";a:3:{s:5:\"label\";s:11:\"Moo Lah Lah\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Moon Dance\";a:3:{s:5:\"label\";s:10:\"Moon Dance\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Moul\";a:3:{s:5:\"label\";s:4:\"Moul\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Moulpali\";a:3:{s:5:\"label\";s:8:\"Moulpali\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:22:\"Mountains of Christmas\";a:3:{s:5:\"label\";s:22:\"Mountains of Christmas\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Mouse Memoirs\";a:3:{s:5:\"label\";s:13:\"Mouse Memoirs\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Mr Bedfort\";a:3:{s:5:\"label\";s:10:\"Mr Bedfort\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Mr Dafoe\";a:3:{s:5:\"label\";s:8:\"Mr Dafoe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Mr De Haviland\";a:3:{s:5:\"label\";s:14:\"Mr De Haviland\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:19:\"Mrs Saint Delafield\";a:3:{s:5:\"label\";s:19:\"Mrs Saint Delafield\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Mrs Sheppards\";a:3:{s:5:\"label\";s:13:\"Mrs Sheppards\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Ms Madi\";a:3:{s:5:\"label\";s:7:\"Ms Madi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Mukta\";a:3:{s:5:\"label\";s:5:\"Mukta\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Mukta Mahee\";a:3:{s:5:\"label\";s:11:\"Mukta Mahee\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Mukta Malar\";a:3:{s:5:\"label\";s:11:\"Mukta Malar\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Mukta Vaani\";a:3:{s:5:\"label\";s:11:\"Mukta Vaani\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Mulish\";a:3:{s:5:\"label\";s:6:\"Mulish\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Murecho\";a:3:{s:5:\"label\";s:7:\"Murecho\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"MuseoModerno\";a:3:{s:5:\"label\";s:12:\"MuseoModerno\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"My Soul\";a:3:{s:5:\"label\";s:7:\"My Soul\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Mynerve\";a:3:{s:5:\"label\";s:7:\"Mynerve\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Mystery Quest\";a:3:{s:5:\"label\";s:13:\"Mystery Quest\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:3:\"NTR\";a:3:{s:5:\"label\";s:3:\"NTR\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Nabla\";a:3:{s:5:\"label\";s:5:\"Nabla\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Nanum Brush Script\";a:3:{s:5:\"label\";s:18:\"Nanum Brush Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Nanum Gothic\";a:3:{s:5:\"label\";s:12:\"Nanum Gothic\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Nanum Gothic Coding\";a:3:{s:5:\"label\";s:19:\"Nanum Gothic Coding\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:14:\"Nanum Myeongjo\";a:3:{s:5:\"label\";s:14:\"Nanum Myeongjo\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Nanum Pen Script\";a:3:{s:5:\"label\";s:16:\"Nanum Pen Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Neonderthaw\";a:3:{s:5:\"label\";s:11:\"Neonderthaw\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Nerko One\";a:3:{s:5:\"label\";s:9:\"Nerko One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Neucha\";a:3:{s:5:\"label\";s:6:\"Neucha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Neuton\";a:3:{s:5:\"label\";s:6:\"Neuton\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"New Rocker\";a:3:{s:5:\"label\";s:10:\"New Rocker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"New Tegomin\";a:3:{s:5:\"label\";s:11:\"New Tegomin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"News Cycle\";a:3:{s:5:\"label\";s:10:\"News Cycle\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Newsreader\";a:3:{s:5:\"label\";s:10:\"Newsreader\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Niconne\";a:3:{s:5:\"label\";s:7:\"Niconne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Niramit\";a:3:{s:5:\"label\";s:7:\"Niramit\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Nixie One\";a:3:{s:5:\"label\";s:9:\"Nixie One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Nobile\";a:3:{s:5:\"label\";s:6:\"Nobile\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Nokora\";a:3:{s:5:\"label\";s:6:\"Nokora\";s:8:\"variants\";a:5:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"900\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Norican\";a:3:{s:5:\"label\";s:7:\"Norican\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Nosifer\";a:3:{s:5:\"label\";s:7:\"Nosifer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Notable\";a:3:{s:5:\"label\";s:7:\"Notable\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Nothing You Could Do\";a:3:{s:5:\"label\";s:20:\"Nothing You Could Do\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Noticia Text\";a:3:{s:5:\"label\";s:12:\"Noticia Text\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Noto Color Emoji\";a:3:{s:5:\"label\";s:16:\"Noto Color Emoji\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Noto Emoji\";a:3:{s:5:\"label\";s:10:\"Noto Emoji\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Kufi Arabic\";a:3:{s:5:\"label\";s:16:\"Noto Kufi Arabic\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Noto Music\";a:3:{s:5:\"label\";s:10:\"Noto Music\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Naskh Arabic\";a:3:{s:5:\"label\";s:17:\"Noto Naskh Arabic\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Noto Nastaliq Urdu\";a:3:{s:5:\"label\";s:18:\"Noto Nastaliq Urdu\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Noto Rashi Hebrew\";a:3:{s:5:\"label\";s:17:\"Noto Rashi Hebrew\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Noto Sans\";a:3:{s:5:\"label\";s:9:\"Noto Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Adlam\";a:3:{s:5:\"label\";s:15:\"Noto Sans Adlam\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:24:\"Noto Sans Adlam Unjoined\";a:3:{s:5:\"label\";s:24:\"Noto Sans Adlam Unjoined\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:31:\"Noto Sans Anatolian Hieroglyphs\";a:3:{s:5:\"label\";s:31:\"Noto Sans Anatolian Hieroglyphs\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Arabic\";a:3:{s:5:\"label\";s:16:\"Noto Sans Arabic\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Armenian\";a:3:{s:5:\"label\";s:18:\"Noto Sans Armenian\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Avestan\";a:3:{s:5:\"label\";s:17:\"Noto Sans Avestan\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Balinese\";a:3:{s:5:\"label\";s:18:\"Noto Sans Balinese\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Bamum\";a:3:{s:5:\"label\";s:15:\"Noto Sans Bamum\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Noto Sans Bassa Vah\";a:3:{s:5:\"label\";s:19:\"Noto Sans Bassa Vah\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Batak\";a:3:{s:5:\"label\";s:15:\"Noto Sans Batak\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Bengali\";a:3:{s:5:\"label\";s:17:\"Noto Sans Bengali\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Noto Sans Bhaiksuki\";a:3:{s:5:\"label\";s:19:\"Noto Sans Bhaiksuki\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Brahmi\";a:3:{s:5:\"label\";s:16:\"Noto Sans Brahmi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Buginese\";a:3:{s:5:\"label\";s:18:\"Noto Sans Buginese\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Buhid\";a:3:{s:5:\"label\";s:15:\"Noto Sans Buhid\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:29:\"Noto Sans Canadian Aboriginal\";a:3:{s:5:\"label\";s:29:\"Noto Sans Canadian Aboriginal\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Carian\";a:3:{s:5:\"label\";s:16:\"Noto Sans Carian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:28:\"Noto Sans Caucasian Albanian\";a:3:{s:5:\"label\";s:28:\"Noto Sans Caucasian Albanian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Chakma\";a:3:{s:5:\"label\";s:16:\"Noto Sans Chakma\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Noto Sans Cham\";a:3:{s:5:\"label\";s:14:\"Noto Sans Cham\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Cherokee\";a:3:{s:5:\"label\";s:18:\"Noto Sans Cherokee\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Noto Sans Chorasmian\";a:3:{s:5:\"label\";s:20:\"Noto Sans Chorasmian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Coptic\";a:3:{s:5:\"label\";s:16:\"Noto Sans Coptic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Noto Sans Cuneiform\";a:3:{s:5:\"label\";s:19:\"Noto Sans Cuneiform\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Cypriot\";a:3:{s:5:\"label\";s:17:\"Noto Sans Cypriot\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Deseret\";a:3:{s:5:\"label\";s:17:\"Noto Sans Deseret\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Noto Sans Devanagari\";a:3:{s:5:\"label\";s:20:\"Noto Sans Devanagari\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Display\";a:3:{s:5:\"label\";s:17:\"Noto Sans Display\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Duployan\";a:3:{s:5:\"label\";s:18:\"Noto Sans Duployan\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:30:\"Noto Sans Egyptian Hieroglyphs\";a:3:{s:5:\"label\";s:30:\"Noto Sans Egyptian Hieroglyphs\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Elbasan\";a:3:{s:5:\"label\";s:17:\"Noto Sans Elbasan\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Elymaic\";a:3:{s:5:\"label\";s:17:\"Noto Sans Elymaic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Ethiopic\";a:3:{s:5:\"label\";s:18:\"Noto Sans Ethiopic\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Georgian\";a:3:{s:5:\"label\";s:18:\"Noto Sans Georgian\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Noto Sans Glagolitic\";a:3:{s:5:\"label\";s:20:\"Noto Sans Glagolitic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Gothic\";a:3:{s:5:\"label\";s:16:\"Noto Sans Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Grantha\";a:3:{s:5:\"label\";s:17:\"Noto Sans Grantha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Gujarati\";a:3:{s:5:\"label\";s:18:\"Noto Sans Gujarati\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:23:\"Noto Sans Gunjala Gondi\";a:3:{s:5:\"label\";s:23:\"Noto Sans Gunjala Gondi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Gurmukhi\";a:3:{s:5:\"label\";s:18:\"Noto Sans Gurmukhi\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans HK\";a:3:{s:5:\"label\";s:12:\"Noto Sans HK\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:25:\"Noto Sans Hanifi Rohingya\";a:3:{s:5:\"label\";s:25:\"Noto Sans Hanifi Rohingya\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Hanunoo\";a:3:{s:5:\"label\";s:17:\"Noto Sans Hanunoo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Hatran\";a:3:{s:5:\"label\";s:16:\"Noto Sans Hatran\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Hebrew\";a:3:{s:5:\"label\";s:16:\"Noto Sans Hebrew\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:26:\"Noto Sans Imperial Aramaic\";a:3:{s:5:\"label\";s:26:\"Noto Sans Imperial Aramaic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:29:\"Noto Sans Indic Siyaq Numbers\";a:3:{s:5:\"label\";s:29:\"Noto Sans Indic Siyaq Numbers\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:31:\"Noto Sans Inscriptional Pahlavi\";a:3:{s:5:\"label\";s:31:\"Noto Sans Inscriptional Pahlavi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:32:\"Noto Sans Inscriptional Parthian\";a:3:{s:5:\"label\";s:32:\"Noto Sans Inscriptional Parthian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans JP\";a:3:{s:5:\"label\";s:12:\"Noto Sans JP\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Javanese\";a:3:{s:5:\"label\";s:18:\"Noto Sans Javanese\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans KR\";a:3:{s:5:\"label\";s:12:\"Noto Sans KR\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Kaithi\";a:3:{s:5:\"label\";s:16:\"Noto Sans Kaithi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Kannada\";a:3:{s:5:\"label\";s:17:\"Noto Sans Kannada\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Kayah Li\";a:3:{s:5:\"label\";s:18:\"Noto Sans Kayah Li\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Noto Sans Kharoshthi\";a:3:{s:5:\"label\";s:20:\"Noto Sans Kharoshthi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Khmer\";a:3:{s:5:\"label\";s:15:\"Noto Sans Khmer\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Khojki\";a:3:{s:5:\"label\";s:16:\"Noto Sans Khojki\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Noto Sans Khudawadi\";a:3:{s:5:\"label\";s:19:\"Noto Sans Khudawadi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Noto Sans Lao\";a:3:{s:5:\"label\";s:13:\"Noto Sans Lao\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Noto Sans Lao Looped\";a:3:{s:5:\"label\";s:20:\"Noto Sans Lao Looped\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Lepcha\";a:3:{s:5:\"label\";s:16:\"Noto Sans Lepcha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Limbu\";a:3:{s:5:\"label\";s:15:\"Noto Sans Limbu\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Linear A\";a:3:{s:5:\"label\";s:18:\"Noto Sans Linear A\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Linear B\";a:3:{s:5:\"label\";s:18:\"Noto Sans Linear B\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Noto Sans Lisu\";a:3:{s:5:\"label\";s:14:\"Noto Sans Lisu\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Lycian\";a:3:{s:5:\"label\";s:16:\"Noto Sans Lycian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Lydian\";a:3:{s:5:\"label\";s:16:\"Noto Sans Lydian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Mahajani\";a:3:{s:5:\"label\";s:18:\"Noto Sans Mahajani\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Noto Sans Malayalam\";a:3:{s:5:\"label\";s:19:\"Noto Sans Malayalam\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Mandaic\";a:3:{s:5:\"label\";s:17:\"Noto Sans Mandaic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Noto Sans Manichaean\";a:3:{s:5:\"label\";s:20:\"Noto Sans Manichaean\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Marchen\";a:3:{s:5:\"label\";s:17:\"Noto Sans Marchen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:23:\"Noto Sans Masaram Gondi\";a:3:{s:5:\"label\";s:23:\"Noto Sans Masaram Gondi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Noto Sans Math\";a:3:{s:5:\"label\";s:14:\"Noto Sans Math\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:24:\"Noto Sans Mayan Numerals\";a:3:{s:5:\"label\";s:24:\"Noto Sans Mayan Numerals\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Noto Sans Medefaidrin\";a:3:{s:5:\"label\";s:21:\"Noto Sans Medefaidrin\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:22:\"Noto Sans Meetei Mayek\";a:3:{s:5:\"label\";s:22:\"Noto Sans Meetei Mayek\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:23:\"Noto Sans Mende Kikakui\";a:3:{s:5:\"label\";s:23:\"Noto Sans Mende Kikakui\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Meroitic\";a:3:{s:5:\"label\";s:18:\"Noto Sans Meroitic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Noto Sans Miao\";a:3:{s:5:\"label\";s:14:\"Noto Sans Miao\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Noto Sans Modi\";a:3:{s:5:\"label\";s:14:\"Noto Sans Modi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Noto Sans Mongolian\";a:3:{s:5:\"label\";s:19:\"Noto Sans Mongolian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Noto Sans Mono\";a:3:{s:5:\"label\";s:14:\"Noto Sans Mono\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:13:\"Noto Sans Mro\";a:3:{s:5:\"label\";s:13:\"Noto Sans Mro\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Multani\";a:3:{s:5:\"label\";s:17:\"Noto Sans Multani\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Myanmar\";a:3:{s:5:\"label\";s:17:\"Noto Sans Myanmar\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Noto Sans NKo\";a:3:{s:5:\"label\";s:13:\"Noto Sans NKo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Noto Sans Nabataean\";a:3:{s:5:\"label\";s:19:\"Noto Sans Nabataean\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Noto Sans Nag Mundari\";a:3:{s:5:\"label\";s:21:\"Noto Sans Nag Mundari\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Noto Sans Nandinagari\";a:3:{s:5:\"label\";s:21:\"Noto Sans Nandinagari\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Noto Sans New Tai Lue\";a:3:{s:5:\"label\";s:21:\"Noto Sans New Tai Lue\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Noto Sans Newa\";a:3:{s:5:\"label\";s:14:\"Noto Sans Newa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Nushu\";a:3:{s:5:\"label\";s:15:\"Noto Sans Nushu\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Ogham\";a:3:{s:5:\"label\";s:15:\"Noto Sans Ogham\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Ol Chiki\";a:3:{s:5:\"label\";s:18:\"Noto Sans Ol Chiki\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:23:\"Noto Sans Old Hungarian\";a:3:{s:5:\"label\";s:23:\"Noto Sans Old Hungarian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Noto Sans Old Italic\";a:3:{s:5:\"label\";s:20:\"Noto Sans Old Italic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:27:\"Noto Sans Old North Arabian\";a:3:{s:5:\"label\";s:27:\"Noto Sans Old North Arabian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Noto Sans Old Permic\";a:3:{s:5:\"label\";s:20:\"Noto Sans Old Permic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Noto Sans Old Persian\";a:3:{s:5:\"label\";s:21:\"Noto Sans Old Persian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Noto Sans Old Sogdian\";a:3:{s:5:\"label\";s:21:\"Noto Sans Old Sogdian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:27:\"Noto Sans Old South Arabian\";a:3:{s:5:\"label\";s:27:\"Noto Sans Old South Arabian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Noto Sans Old Turkic\";a:3:{s:5:\"label\";s:20:\"Noto Sans Old Turkic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Oriya\";a:3:{s:5:\"label\";s:15:\"Noto Sans Oriya\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Osage\";a:3:{s:5:\"label\";s:15:\"Noto Sans Osage\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Osmanya\";a:3:{s:5:\"label\";s:17:\"Noto Sans Osmanya\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:22:\"Noto Sans Pahawh Hmong\";a:3:{s:5:\"label\";s:22:\"Noto Sans Pahawh Hmong\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Noto Sans Palmyrene\";a:3:{s:5:\"label\";s:19:\"Noto Sans Palmyrene\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Noto Sans Pau Cin Hau\";a:3:{s:5:\"label\";s:21:\"Noto Sans Pau Cin Hau\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Phags Pa\";a:3:{s:5:\"label\";s:18:\"Noto Sans Phags Pa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Noto Sans Phoenician\";a:3:{s:5:\"label\";s:20:\"Noto Sans Phoenician\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:25:\"Noto Sans Psalter Pahlavi\";a:3:{s:5:\"label\";s:25:\"Noto Sans Psalter Pahlavi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Rejang\";a:3:{s:5:\"label\";s:16:\"Noto Sans Rejang\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Runic\";a:3:{s:5:\"label\";s:15:\"Noto Sans Runic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans SC\";a:3:{s:5:\"label\";s:12:\"Noto Sans SC\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Noto Sans Samaritan\";a:3:{s:5:\"label\";s:19:\"Noto Sans Samaritan\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Noto Sans Saurashtra\";a:3:{s:5:\"label\";s:20:\"Noto Sans Saurashtra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Sharada\";a:3:{s:5:\"label\";s:17:\"Noto Sans Sharada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Shavian\";a:3:{s:5:\"label\";s:17:\"Noto Sans Shavian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Siddham\";a:3:{s:5:\"label\";s:17:\"Noto Sans Siddham\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Noto Sans SignWriting\";a:3:{s:5:\"label\";s:21:\"Noto Sans SignWriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Sinhala\";a:3:{s:5:\"label\";s:17:\"Noto Sans Sinhala\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Sogdian\";a:3:{s:5:\"label\";s:17:\"Noto Sans Sogdian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:22:\"Noto Sans Sora Sompeng\";a:3:{s:5:\"label\";s:22:\"Noto Sans Sora Sompeng\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Soyombo\";a:3:{s:5:\"label\";s:17:\"Noto Sans Soyombo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Noto Sans Sundanese\";a:3:{s:5:\"label\";s:19:\"Noto Sans Sundanese\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:22:\"Noto Sans Syloti Nagri\";a:3:{s:5:\"label\";s:22:\"Noto Sans Syloti Nagri\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Symbols\";a:3:{s:5:\"label\";s:17:\"Noto Sans Symbols\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Noto Sans Symbols 2\";a:3:{s:5:\"label\";s:19:\"Noto Sans Symbols 2\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Syriac\";a:3:{s:5:\"label\";s:16:\"Noto Sans Syriac\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans TC\";a:3:{s:5:\"label\";s:12:\"Noto Sans TC\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Tagalog\";a:3:{s:5:\"label\";s:17:\"Noto Sans Tagalog\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Tagbanwa\";a:3:{s:5:\"label\";s:18:\"Noto Sans Tagbanwa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Tai Le\";a:3:{s:5:\"label\";s:16:\"Noto Sans Tai Le\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Tai Tham\";a:3:{s:5:\"label\";s:18:\"Noto Sans Tai Tham\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Tai Viet\";a:3:{s:5:\"label\";s:18:\"Noto Sans Tai Viet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Takri\";a:3:{s:5:\"label\";s:15:\"Noto Sans Takri\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Noto Sans Tamil\";a:3:{s:5:\"label\";s:15:\"Noto Sans Tamil\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:26:\"Noto Sans Tamil Supplement\";a:3:{s:5:\"label\";s:26:\"Noto Sans Tamil Supplement\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Tangsa\";a:3:{s:5:\"label\";s:16:\"Noto Sans Tangsa\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Telugu\";a:3:{s:5:\"label\";s:16:\"Noto Sans Telugu\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Thaana\";a:3:{s:5:\"label\";s:16:\"Noto Sans Thaana\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Noto Sans Thai\";a:3:{s:5:\"label\";s:14:\"Noto Sans Thai\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Noto Sans Thai Looped\";a:3:{s:5:\"label\";s:21:\"Noto Sans Thai Looped\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Tifinagh\";a:3:{s:5:\"label\";s:18:\"Noto Sans Tifinagh\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Noto Sans Tirhuta\";a:3:{s:5:\"label\";s:17:\"Noto Sans Tirhuta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Noto Sans Ugaritic\";a:3:{s:5:\"label\";s:18:\"Noto Sans Ugaritic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Noto Sans Vai\";a:3:{s:5:\"label\";s:13:\"Noto Sans Vai\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Noto Sans Wancho\";a:3:{s:5:\"label\";s:16:\"Noto Sans Wancho\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Noto Sans Warang Citi\";a:3:{s:5:\"label\";s:21:\"Noto Sans Warang Citi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans Yi\";a:3:{s:5:\"label\";s:12:\"Noto Sans Yi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:26:\"Noto Sans Zanabazar Square\";a:3:{s:5:\"label\";s:26:\"Noto Sans Zanabazar Square\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Noto Serif\";a:3:{s:5:\"label\";s:10:\"Noto Serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Noto Serif Ahom\";a:3:{s:5:\"label\";s:15:\"Noto Serif Ahom\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Noto Serif Armenian\";a:3:{s:5:\"label\";s:19:\"Noto Serif Armenian\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Noto Serif Balinese\";a:3:{s:5:\"label\";s:19:\"Noto Serif Balinese\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Noto Serif Bengali\";a:3:{s:5:\"label\";s:18:\"Noto Serif Bengali\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:21:\"Noto Serif Devanagari\";a:3:{s:5:\"label\";s:21:\"Noto Serif Devanagari\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Noto Serif Display\";a:3:{s:5:\"label\";s:18:\"Noto Serif Display\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Noto Serif Dogra\";a:3:{s:5:\"label\";s:16:\"Noto Serif Dogra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Noto Serif Ethiopic\";a:3:{s:5:\"label\";s:19:\"Noto Serif Ethiopic\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Noto Serif Georgian\";a:3:{s:5:\"label\";s:19:\"Noto Serif Georgian\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Noto Serif Grantha\";a:3:{s:5:\"label\";s:18:\"Noto Serif Grantha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Noto Serif Gujarati\";a:3:{s:5:\"label\";s:19:\"Noto Serif Gujarati\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Noto Serif Gurmukhi\";a:3:{s:5:\"label\";s:19:\"Noto Serif Gurmukhi\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif HK\";a:3:{s:5:\"label\";s:13:\"Noto Serif HK\";s:8:\"variants\";a:8:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Noto Serif Hebrew\";a:3:{s:5:\"label\";s:17:\"Noto Serif Hebrew\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif JP\";a:3:{s:5:\"label\";s:13:\"Noto Serif JP\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif KR\";a:3:{s:5:\"label\";s:13:\"Noto Serif KR\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Noto Serif Kannada\";a:3:{s:5:\"label\";s:18:\"Noto Serif Kannada\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Noto Serif Khmer\";a:3:{s:5:\"label\";s:16:\"Noto Serif Khmer\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Noto Serif Khojki\";a:3:{s:5:\"label\";s:17:\"Noto Serif Khojki\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Noto Serif Lao\";a:3:{s:5:\"label\";s:14:\"Noto Serif Lao\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Noto Serif Malayalam\";a:3:{s:5:\"label\";s:20:\"Noto Serif Malayalam\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Noto Serif Myanmar\";a:3:{s:5:\"label\";s:18:\"Noto Serif Myanmar\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Noto Serif NP Hmong\";a:3:{s:5:\"label\";s:19:\"Noto Serif NP Hmong\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Noto Serif Oriya\";a:3:{s:5:\"label\";s:16:\"Noto Serif Oriya\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif SC\";a:3:{s:5:\"label\";s:13:\"Noto Serif SC\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Noto Serif Sinhala\";a:3:{s:5:\"label\";s:18:\"Noto Serif Sinhala\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif TC\";a:3:{s:5:\"label\";s:13:\"Noto Serif TC\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Noto Serif Tamil\";a:3:{s:5:\"label\";s:16:\"Noto Serif Tamil\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Noto Serif Tangut\";a:3:{s:5:\"label\";s:17:\"Noto Serif Tangut\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Noto Serif Telugu\";a:3:{s:5:\"label\";s:17:\"Noto Serif Telugu\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Noto Serif Thai\";a:3:{s:5:\"label\";s:15:\"Noto Serif Thai\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Noto Serif Tibetan\";a:3:{s:5:\"label\";s:18:\"Noto Serif Tibetan\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Noto Serif Toto\";a:3:{s:5:\"label\";s:15:\"Noto Serif Toto\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Noto Serif Yezidi\";a:3:{s:5:\"label\";s:17:\"Noto Serif Yezidi\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:22:\"Noto Traditional Nushu\";a:3:{s:5:\"label\";s:22:\"Noto Traditional Nushu\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Nova Cut\";a:3:{s:5:\"label\";s:8:\"Nova Cut\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Nova Flat\";a:3:{s:5:\"label\";s:9:\"Nova Flat\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Nova Mono\";a:3:{s:5:\"label\";s:9:\"Nova Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:9:\"Nova Oval\";a:3:{s:5:\"label\";s:9:\"Nova Oval\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Nova Round\";a:3:{s:5:\"label\";s:10:\"Nova Round\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Nova Script\";a:3:{s:5:\"label\";s:11:\"Nova Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Nova Slim\";a:3:{s:5:\"label\";s:9:\"Nova Slim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Nova Square\";a:3:{s:5:\"label\";s:11:\"Nova Square\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Numans\";a:3:{s:5:\"label\";s:6:\"Numans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Nunito\";a:3:{s:5:\"label\";s:6:\"Nunito\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Nunito Sans\";a:3:{s:5:\"label\";s:11:\"Nunito Sans\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Nuosu SIL\";a:3:{s:5:\"label\";s:9:\"Nuosu SIL\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Odibee Sans\";a:3:{s:5:\"label\";s:11:\"Odibee Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Odor Mean Chey\";a:3:{s:5:\"label\";s:14:\"Odor Mean Chey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Offside\";a:3:{s:5:\"label\";s:7:\"Offside\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:2:\"Oi\";a:3:{s:5:\"label\";s:2:\"Oi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Old Standard TT\";a:3:{s:5:\"label\";s:15:\"Old Standard TT\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Oldenburg\";a:3:{s:5:\"label\";s:9:\"Oldenburg\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:3:\"Ole\";a:3:{s:5:\"label\";s:3:\"Ole\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Oleo Script\";a:3:{s:5:\"label\";s:11:\"Oleo Script\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:22:\"Oleo Script Swash Caps\";a:3:{s:5:\"label\";s:22:\"Oleo Script Swash Caps\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Oooh Baby\";a:3:{s:5:\"label\";s:9:\"Oooh Baby\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Open Sans\";a:3:{s:5:\"label\";s:9:\"Open Sans\";s:8:\"variants\";a:12:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Oranienbaum\";a:3:{s:5:\"label\";s:11:\"Oranienbaum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Orbit\";a:3:{s:5:\"label\";s:5:\"Orbit\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Orbitron\";a:3:{s:5:\"label\";s:8:\"Orbitron\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Oregano\";a:3:{s:5:\"label\";s:7:\"Oregano\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Orelega One\";a:3:{s:5:\"label\";s:11:\"Orelega One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Orienta\";a:3:{s:5:\"label\";s:7:\"Orienta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Original Surfer\";a:3:{s:5:\"label\";s:15:\"Original Surfer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Oswald\";a:3:{s:5:\"label\";s:6:\"Oswald\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Outfit\";a:3:{s:5:\"label\";s:6:\"Outfit\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Over the Rainbow\";a:3:{s:5:\"label\";s:16:\"Over the Rainbow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Overlock\";a:3:{s:5:\"label\";s:8:\"Overlock\";s:8:\"variants\";a:6:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:3:\"900\";i:3;s:9:\"900italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Overlock SC\";a:3:{s:5:\"label\";s:11:\"Overlock SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Overpass\";a:3:{s:5:\"label\";s:8:\"Overpass\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Overpass Mono\";a:3:{s:5:\"label\";s:13:\"Overpass Mono\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:3:\"Ovo\";a:3:{s:5:\"label\";s:3:\"Ovo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Oxanium\";a:3:{s:5:\"label\";s:7:\"Oxanium\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Oxygen\";a:3:{s:5:\"label\";s:6:\"Oxygen\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Oxygen Mono\";a:3:{s:5:\"label\";s:11:\"Oxygen Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"PT Mono\";a:3:{s:5:\"label\";s:7:\"PT Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"PT Sans\";a:3:{s:5:\"label\";s:7:\"PT Sans\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"PT Sans Caption\";a:3:{s:5:\"label\";s:15:\"PT Sans Caption\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"PT Sans Narrow\";a:3:{s:5:\"label\";s:14:\"PT Sans Narrow\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"PT Serif\";a:3:{s:5:\"label\";s:8:\"PT Serif\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"PT Serif Caption\";a:3:{s:5:\"label\";s:16:\"PT Serif Caption\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Pacifico\";a:3:{s:5:\"label\";s:8:\"Pacifico\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Padauk\";a:3:{s:5:\"label\";s:6:\"Padauk\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Padyakke Expanded One\";a:3:{s:5:\"label\";s:21:\"Padyakke Expanded One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Palanquin\";a:3:{s:5:\"label\";s:9:\"Palanquin\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Palanquin Dark\";a:3:{s:5:\"label\";s:14:\"Palanquin Dark\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Palette Mosaic\";a:3:{s:5:\"label\";s:14:\"Palette Mosaic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Pangolin\";a:3:{s:5:\"label\";s:8:\"Pangolin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Paprika\";a:3:{s:5:\"label\";s:7:\"Paprika\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Parisienne\";a:3:{s:5:\"label\";s:10:\"Parisienne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Passero One\";a:3:{s:5:\"label\";s:11:\"Passero One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Passion One\";a:3:{s:5:\"label\";s:11:\"Passion One\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"900\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Passions Conflict\";a:3:{s:5:\"label\";s:17:\"Passions Conflict\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Pathway Extreme\";a:3:{s:5:\"label\";s:15:\"Pathway Extreme\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Pathway Gothic One\";a:3:{s:5:\"label\";s:18:\"Pathway Gothic One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Patrick Hand\";a:3:{s:5:\"label\";s:12:\"Patrick Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Patrick Hand SC\";a:3:{s:5:\"label\";s:15:\"Patrick Hand SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Pattaya\";a:3:{s:5:\"label\";s:7:\"Pattaya\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Patua One\";a:3:{s:5:\"label\";s:9:\"Patua One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Pavanam\";a:3:{s:5:\"label\";s:7:\"Pavanam\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Paytone One\";a:3:{s:5:\"label\";s:11:\"Paytone One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Peddana\";a:3:{s:5:\"label\";s:7:\"Peddana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Peralta\";a:3:{s:5:\"label\";s:7:\"Peralta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Permanent Marker\";a:3:{s:5:\"label\";s:16:\"Permanent Marker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Petemoss\";a:3:{s:5:\"label\";s:8:\"Petemoss\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:19:\"Petit Formal Script\";a:3:{s:5:\"label\";s:19:\"Petit Formal Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Petrona\";a:3:{s:5:\"label\";s:7:\"Petrona\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Philosopher\";a:3:{s:5:\"label\";s:11:\"Philosopher\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Phudu\";a:3:{s:5:\"label\";s:5:\"Phudu\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Piazzolla\";a:3:{s:5:\"label\";s:9:\"Piazzolla\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Piedra\";a:3:{s:5:\"label\";s:6:\"Piedra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Pinyon Script\";a:3:{s:5:\"label\";s:13:\"Pinyon Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Pirata One\";a:3:{s:5:\"label\";s:10:\"Pirata One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Plaster\";a:3:{s:5:\"label\";s:7:\"Plaster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Play\";a:3:{s:5:\"label\";s:4:\"Play\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Playball\";a:3:{s:5:\"label\";s:8:\"Playball\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Playfair\";a:3:{s:5:\"label\";s:8:\"Playfair\";s:8:\"variants\";a:14:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Playfair Display\";a:3:{s:5:\"label\";s:16:\"Playfair Display\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Playfair Display SC\";a:3:{s:5:\"label\";s:19:\"Playfair Display SC\";s:8:\"variants\";a:6:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:3:\"900\";i:3;s:9:\"900italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Plus Jakarta Sans\";a:3:{s:5:\"label\";s:17:\"Plus Jakarta Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Podkova\";a:3:{s:5:\"label\";s:7:\"Podkova\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Poiret One\";a:3:{s:5:\"label\";s:10:\"Poiret One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Poller One\";a:3:{s:5:\"label\";s:10:\"Poller One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Poltawski Nowy\";a:3:{s:5:\"label\";s:14:\"Poltawski Nowy\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Poly\";a:3:{s:5:\"label\";s:4:\"Poly\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Pompiere\";a:3:{s:5:\"label\";s:8:\"Pompiere\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Pontano Sans\";a:3:{s:5:\"label\";s:12:\"Pontano Sans\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Poor Story\";a:3:{s:5:\"label\";s:10:\"Poor Story\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Poppins\";a:3:{s:5:\"label\";s:7:\"Poppins\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Port Lligat Sans\";a:3:{s:5:\"label\";s:16:\"Port Lligat Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Port Lligat Slab\";a:3:{s:5:\"label\";s:16:\"Port Lligat Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Potta One\";a:3:{s:5:\"label\";s:9:\"Potta One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Pragati Narrow\";a:3:{s:5:\"label\";s:14:\"Pragati Narrow\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Praise\";a:3:{s:5:\"label\";s:6:\"Praise\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Prata\";a:3:{s:5:\"label\";s:5:\"Prata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Preahvihear\";a:3:{s:5:\"label\";s:11:\"Preahvihear\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Press Start 2P\";a:3:{s:5:\"label\";s:14:\"Press Start 2P\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Pridi\";a:3:{s:5:\"label\";s:5:\"Pridi\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Princess Sofia\";a:3:{s:5:\"label\";s:14:\"Princess Sofia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Prociono\";a:3:{s:5:\"label\";s:8:\"Prociono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Prompt\";a:3:{s:5:\"label\";s:6:\"Prompt\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Prosto One\";a:3:{s:5:\"label\";s:10:\"Prosto One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Proza Libre\";a:3:{s:5:\"label\";s:11:\"Proza Libre\";s:8:\"variants\";a:10:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Public Sans\";a:3:{s:5:\"label\";s:11:\"Public Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Puppies Play\";a:3:{s:5:\"label\";s:12:\"Puppies Play\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Puritan\";a:3:{s:5:\"label\";s:7:\"Puritan\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Purple Purse\";a:3:{s:5:\"label\";s:12:\"Purple Purse\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Qahiri\";a:3:{s:5:\"label\";s:6:\"Qahiri\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Quando\";a:3:{s:5:\"label\";s:6:\"Quando\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Quantico\";a:3:{s:5:\"label\";s:8:\"Quantico\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Quattrocento\";a:3:{s:5:\"label\";s:12:\"Quattrocento\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Quattrocento Sans\";a:3:{s:5:\"label\";s:17:\"Quattrocento Sans\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Questrial\";a:3:{s:5:\"label\";s:9:\"Questrial\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Quicksand\";a:3:{s:5:\"label\";s:9:\"Quicksand\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Quintessential\";a:3:{s:5:\"label\";s:14:\"Quintessential\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Qwigley\";a:3:{s:5:\"label\";s:7:\"Qwigley\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Qwitcher Grypen\";a:3:{s:5:\"label\";s:15:\"Qwitcher Grypen\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Racing Sans One\";a:3:{s:5:\"label\";s:15:\"Racing Sans One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Radio Canada\";a:3:{s:5:\"label\";s:12:\"Radio Canada\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Radley\";a:3:{s:5:\"label\";s:6:\"Radley\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Rajdhani\";a:3:{s:5:\"label\";s:8:\"Rajdhani\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Rakkas\";a:3:{s:5:\"label\";s:6:\"Rakkas\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Raleway\";a:3:{s:5:\"label\";s:7:\"Raleway\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Raleway Dots\";a:3:{s:5:\"label\";s:12:\"Raleway Dots\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Ramabhadra\";a:3:{s:5:\"label\";s:10:\"Ramabhadra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Ramaraja\";a:3:{s:5:\"label\";s:8:\"Ramaraja\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Rambla\";a:3:{s:5:\"label\";s:6:\"Rambla\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Rammetto One\";a:3:{s:5:\"label\";s:12:\"Rammetto One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Rampart One\";a:3:{s:5:\"label\";s:11:\"Rampart One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Ranchers\";a:3:{s:5:\"label\";s:8:\"Ranchers\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Rancho\";a:3:{s:5:\"label\";s:6:\"Rancho\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Ranga\";a:3:{s:5:\"label\";s:5:\"Ranga\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Rasa\";a:3:{s:5:\"label\";s:4:\"Rasa\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Rationale\";a:3:{s:5:\"label\";s:9:\"Rationale\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Ravi Prakash\";a:3:{s:5:\"label\";s:12:\"Ravi Prakash\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Readex Pro\";a:3:{s:5:\"label\";s:10:\"Readex Pro\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Recursive\";a:3:{s:5:\"label\";s:9:\"Recursive\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Red Hat Display\";a:3:{s:5:\"label\";s:15:\"Red Hat Display\";s:8:\"variants\";a:14:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Red Hat Mono\";a:3:{s:5:\"label\";s:12:\"Red Hat Mono\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:12:\"Red Hat Text\";a:3:{s:5:\"label\";s:12:\"Red Hat Text\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Red Rose\";a:3:{s:5:\"label\";s:8:\"Red Rose\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Redacted\";a:3:{s:5:\"label\";s:8:\"Redacted\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Redacted Script\";a:3:{s:5:\"label\";s:15:\"Redacted Script\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Redressed\";a:3:{s:5:\"label\";s:9:\"Redressed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Reem Kufi\";a:3:{s:5:\"label\";s:9:\"Reem Kufi\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Reem Kufi Fun\";a:3:{s:5:\"label\";s:13:\"Reem Kufi Fun\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Reem Kufi Ink\";a:3:{s:5:\"label\";s:13:\"Reem Kufi Ink\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Reenie Beanie\";a:3:{s:5:\"label\";s:13:\"Reenie Beanie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Reggae One\";a:3:{s:5:\"label\";s:10:\"Reggae One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Revalia\";a:3:{s:5:\"label\";s:7:\"Revalia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Rhodium Libre\";a:3:{s:5:\"label\";s:13:\"Rhodium Libre\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Ribeye\";a:3:{s:5:\"label\";s:6:\"Ribeye\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Ribeye Marrow\";a:3:{s:5:\"label\";s:13:\"Ribeye Marrow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Righteous\";a:3:{s:5:\"label\";s:9:\"Righteous\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Risque\";a:3:{s:5:\"label\";s:6:\"Risque\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Road Rage\";a:3:{s:5:\"label\";s:9:\"Road Rage\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Roboto\";a:3:{s:5:\"label\";s:6:\"Roboto\";s:8:\"variants\";a:12:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Roboto Condensed\";a:3:{s:5:\"label\";s:16:\"Roboto Condensed\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Roboto Flex\";a:3:{s:5:\"label\";s:11:\"Roboto Flex\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Roboto Mono\";a:3:{s:5:\"label\";s:11:\"Roboto Mono\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:12:\"Roboto Serif\";a:3:{s:5:\"label\";s:12:\"Roboto Serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Roboto Slab\";a:3:{s:5:\"label\";s:11:\"Roboto Slab\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Rochester\";a:3:{s:5:\"label\";s:9:\"Rochester\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Rock 3D\";a:3:{s:5:\"label\";s:7:\"Rock 3D\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Rock Salt\";a:3:{s:5:\"label\";s:9:\"Rock Salt\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"RocknRoll One\";a:3:{s:5:\"label\";s:13:\"RocknRoll One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Rokkitt\";a:3:{s:5:\"label\";s:7:\"Rokkitt\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Romanesco\";a:3:{s:5:\"label\";s:9:\"Romanesco\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Ropa Sans\";a:3:{s:5:\"label\";s:9:\"Ropa Sans\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Rosario\";a:3:{s:5:\"label\";s:7:\"Rosario\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Rosarivo\";a:3:{s:5:\"label\";s:8:\"Rosarivo\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Rouge Script\";a:3:{s:5:\"label\";s:12:\"Rouge Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Rowdies\";a:3:{s:5:\"label\";s:7:\"Rowdies\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Rozha One\";a:3:{s:5:\"label\";s:9:\"Rozha One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Rubik\";a:3:{s:5:\"label\";s:5:\"Rubik\";s:8:\"variants\";a:14:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Rubik 80s Fade\";a:3:{s:5:\"label\";s:14:\"Rubik 80s Fade\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Rubik Beastly\";a:3:{s:5:\"label\";s:13:\"Rubik Beastly\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Rubik Bubbles\";a:3:{s:5:\"label\";s:13:\"Rubik Bubbles\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Rubik Burned\";a:3:{s:5:\"label\";s:12:\"Rubik Burned\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Rubik Dirt\";a:3:{s:5:\"label\";s:10:\"Rubik Dirt\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Rubik Distressed\";a:3:{s:5:\"label\";s:16:\"Rubik Distressed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Rubik Gemstones\";a:3:{s:5:\"label\";s:15:\"Rubik Gemstones\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Rubik Glitch\";a:3:{s:5:\"label\";s:12:\"Rubik Glitch\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Rubik Iso\";a:3:{s:5:\"label\";s:9:\"Rubik Iso\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Rubik Marker Hatch\";a:3:{s:5:\"label\";s:18:\"Rubik Marker Hatch\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Rubik Maze\";a:3:{s:5:\"label\";s:10:\"Rubik Maze\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Rubik Microbe\";a:3:{s:5:\"label\";s:13:\"Rubik Microbe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Rubik Mono One\";a:3:{s:5:\"label\";s:14:\"Rubik Mono One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Rubik Moonrocks\";a:3:{s:5:\"label\";s:15:\"Rubik Moonrocks\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Rubik Pixels\";a:3:{s:5:\"label\";s:12:\"Rubik Pixels\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Rubik Puddles\";a:3:{s:5:\"label\";s:13:\"Rubik Puddles\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Rubik Spray Paint\";a:3:{s:5:\"label\";s:17:\"Rubik Spray Paint\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Rubik Storm\";a:3:{s:5:\"label\";s:11:\"Rubik Storm\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Rubik Vinyl\";a:3:{s:5:\"label\";s:11:\"Rubik Vinyl\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Rubik Wet Paint\";a:3:{s:5:\"label\";s:15:\"Rubik Wet Paint\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Ruda\";a:3:{s:5:\"label\";s:4:\"Ruda\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Rufina\";a:3:{s:5:\"label\";s:6:\"Rufina\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Ruge Boogie\";a:3:{s:5:\"label\";s:11:\"Ruge Boogie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Ruluko\";a:3:{s:5:\"label\";s:6:\"Ruluko\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Rum Raisin\";a:3:{s:5:\"label\";s:10:\"Rum Raisin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Ruslan Display\";a:3:{s:5:\"label\";s:14:\"Ruslan Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Russo One\";a:3:{s:5:\"label\";s:9:\"Russo One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Ruthie\";a:3:{s:5:\"label\";s:6:\"Ruthie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:3:\"Rye\";a:3:{s:5:\"label\";s:3:\"Rye\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"STIX Two Text\";a:3:{s:5:\"label\";s:13:\"STIX Two Text\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Sacramento\";a:3:{s:5:\"label\";s:10:\"Sacramento\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Sahitya\";a:3:{s:5:\"label\";s:7:\"Sahitya\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Sail\";a:3:{s:5:\"label\";s:4:\"Sail\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Saira\";a:3:{s:5:\"label\";s:5:\"Saira\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Saira Condensed\";a:3:{s:5:\"label\";s:15:\"Saira Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Saira Extra Condensed\";a:3:{s:5:\"label\";s:21:\"Saira Extra Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Saira Semi Condensed\";a:3:{s:5:\"label\";s:20:\"Saira Semi Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Saira Stencil One\";a:3:{s:5:\"label\";s:17:\"Saira Stencil One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Salsa\";a:3:{s:5:\"label\";s:5:\"Salsa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sanchez\";a:3:{s:5:\"label\";s:7:\"Sanchez\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Sancreek\";a:3:{s:5:\"label\";s:8:\"Sancreek\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sansita\";a:3:{s:5:\"label\";s:7:\"Sansita\";s:8:\"variants\";a:8:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:3:\"800\";i:3;s:9:\"800italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Sansita Swashed\";a:3:{s:5:\"label\";s:15:\"Sansita Swashed\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sarabun\";a:3:{s:5:\"label\";s:7:\"Sarabun\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Sarala\";a:3:{s:5:\"label\";s:6:\"Sarala\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Sarina\";a:3:{s:5:\"label\";s:6:\"Sarina\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Sarpanch\";a:3:{s:5:\"label\";s:8:\"Sarpanch\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Sassy Frass\";a:3:{s:5:\"label\";s:11:\"Sassy Frass\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Satisfy\";a:3:{s:5:\"label\";s:7:\"Satisfy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Sawarabi Gothic\";a:3:{s:5:\"label\";s:15:\"Sawarabi Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Sawarabi Mincho\";a:3:{s:5:\"label\";s:15:\"Sawarabi Mincho\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Scada\";a:3:{s:5:\"label\";s:5:\"Scada\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Scheherazade New\";a:3:{s:5:\"label\";s:16:\"Scheherazade New\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Schibsted Grotesk\";a:3:{s:5:\"label\";s:17:\"Schibsted Grotesk\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Schoolbell\";a:3:{s:5:\"label\";s:10:\"Schoolbell\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Scope One\";a:3:{s:5:\"label\";s:9:\"Scope One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Seaweed Script\";a:3:{s:5:\"label\";s:14:\"Seaweed Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Secular One\";a:3:{s:5:\"label\";s:11:\"Secular One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Sedgwick Ave\";a:3:{s:5:\"label\";s:12:\"Sedgwick Ave\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:20:\"Sedgwick Ave Display\";a:3:{s:5:\"label\";s:20:\"Sedgwick Ave Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:3:\"Sen\";a:3:{s:5:\"label\";s:3:\"Sen\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Send Flowers\";a:3:{s:5:\"label\";s:12:\"Send Flowers\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Sevillana\";a:3:{s:5:\"label\";s:9:\"Sevillana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Seymour One\";a:3:{s:5:\"label\";s:11:\"Seymour One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Shadows Into Light\";a:3:{s:5:\"label\";s:18:\"Shadows Into Light\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:22:\"Shadows Into Light Two\";a:3:{s:5:\"label\";s:22:\"Shadows Into Light Two\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Shalimar\";a:3:{s:5:\"label\";s:8:\"Shalimar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Shantell Sans\";a:3:{s:5:\"label\";s:13:\"Shantell Sans\";s:8:\"variants\";a:12:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Shanti\";a:3:{s:5:\"label\";s:6:\"Shanti\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Share\";a:3:{s:5:\"label\";s:5:\"Share\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Share Tech\";a:3:{s:5:\"label\";s:10:\"Share Tech\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Share Tech Mono\";a:3:{s:5:\"label\";s:15:\"Share Tech Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:16:\"Shippori Antique\";a:3:{s:5:\"label\";s:16:\"Shippori Antique\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Shippori Antique B1\";a:3:{s:5:\"label\";s:19:\"Shippori Antique B1\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Shippori Mincho\";a:3:{s:5:\"label\";s:15:\"Shippori Mincho\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Shippori Mincho B1\";a:3:{s:5:\"label\";s:18:\"Shippori Mincho B1\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Shizuru\";a:3:{s:5:\"label\";s:7:\"Shizuru\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Shojumaru\";a:3:{s:5:\"label\";s:9:\"Shojumaru\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Short Stack\";a:3:{s:5:\"label\";s:11:\"Short Stack\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Shrikhand\";a:3:{s:5:\"label\";s:9:\"Shrikhand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Siemreap\";a:3:{s:5:\"label\";s:8:\"Siemreap\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Sigmar\";a:3:{s:5:\"label\";s:6:\"Sigmar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Sigmar One\";a:3:{s:5:\"label\";s:10:\"Sigmar One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Signika\";a:3:{s:5:\"label\";s:7:\"Signika\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Signika Negative\";a:3:{s:5:\"label\";s:16:\"Signika Negative\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Silkscreen\";a:3:{s:5:\"label\";s:10:\"Silkscreen\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Simonetta\";a:3:{s:5:\"label\";s:9:\"Simonetta\";s:8:\"variants\";a:4:{i:0;s:3:\"900\";i:1;s:9:\"900italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Single Day\";a:3:{s:5:\"label\";s:10:\"Single Day\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sintony\";a:3:{s:5:\"label\";s:7:\"Sintony\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Sirin Stencil\";a:3:{s:5:\"label\";s:13:\"Sirin Stencil\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Six Caps\";a:3:{s:5:\"label\";s:8:\"Six Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Skranji\";a:3:{s:5:\"label\";s:7:\"Skranji\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Slabo 13px\";a:3:{s:5:\"label\";s:10:\"Slabo 13px\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Slabo 27px\";a:3:{s:5:\"label\";s:10:\"Slabo 27px\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Slackey\";a:3:{s:5:\"label\";s:7:\"Slackey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Slackside One\";a:3:{s:5:\"label\";s:13:\"Slackside One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Smokum\";a:3:{s:5:\"label\";s:6:\"Smokum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Smooch\";a:3:{s:5:\"label\";s:6:\"Smooch\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Smooch Sans\";a:3:{s:5:\"label\";s:11:\"Smooch Sans\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Smythe\";a:3:{s:5:\"label\";s:6:\"Smythe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sniglet\";a:3:{s:5:\"label\";s:7:\"Sniglet\";s:8:\"variants\";a:2:{i:0;s:3:\"800\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Snippet\";a:3:{s:5:\"label\";s:7:\"Snippet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Snowburst One\";a:3:{s:5:\"label\";s:13:\"Snowburst One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Sofadi One\";a:3:{s:5:\"label\";s:10:\"Sofadi One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Sofia\";a:3:{s:5:\"label\";s:5:\"Sofia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Sofia Sans\";a:3:{s:5:\"label\";s:10:\"Sofia Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Sofia Sans Condensed\";a:3:{s:5:\"label\";s:20:\"Sofia Sans Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:26:\"Sofia Sans Extra Condensed\";a:3:{s:5:\"label\";s:26:\"Sofia Sans Extra Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:25:\"Sofia Sans Semi Condensed\";a:3:{s:5:\"label\";s:25:\"Sofia Sans Semi Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Solitreo\";a:3:{s:5:\"label\";s:8:\"Solitreo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Solway\";a:3:{s:5:\"label\";s:6:\"Solway\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Song Myung\";a:3:{s:5:\"label\";s:10:\"Song Myung\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Sono\";a:3:{s:5:\"label\";s:4:\"Sono\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Sonsie One\";a:3:{s:5:\"label\";s:10:\"Sonsie One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Sora\";a:3:{s:5:\"label\";s:4:\"Sora\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Sorts Mill Goudy\";a:3:{s:5:\"label\";s:16:\"Sorts Mill Goudy\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Source Code Pro\";a:3:{s:5:\"label\";s:15:\"Source Code Pro\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:13:\"Source Sans 3\";a:3:{s:5:\"label\";s:13:\"Source Sans 3\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Source Serif 4\";a:3:{s:5:\"label\";s:14:\"Source Serif 4\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Space Grotesk\";a:3:{s:5:\"label\";s:13:\"Space Grotesk\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Space Mono\";a:3:{s:5:\"label\";s:10:\"Space Mono\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:13:\"Special Elite\";a:3:{s:5:\"label\";s:13:\"Special Elite\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Spectral\";a:3:{s:5:\"label\";s:8:\"Spectral\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Spectral SC\";a:3:{s:5:\"label\";s:11:\"Spectral SC\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Spicy Rice\";a:3:{s:5:\"label\";s:10:\"Spicy Rice\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Spinnaker\";a:3:{s:5:\"label\";s:9:\"Spinnaker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Spirax\";a:3:{s:5:\"label\";s:6:\"Spirax\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Splash\";a:3:{s:5:\"label\";s:6:\"Splash\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Spline Sans\";a:3:{s:5:\"label\";s:11:\"Spline Sans\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Spline Sans Mono\";a:3:{s:5:\"label\";s:16:\"Spline Sans Mono\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:10:\"Squada One\";a:3:{s:5:\"label\";s:10:\"Squada One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Square Peg\";a:3:{s:5:\"label\";s:10:\"Square Peg\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:20:\"Sree Krushnadevaraya\";a:3:{s:5:\"label\";s:20:\"Sree Krushnadevaraya\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Sriracha\";a:3:{s:5:\"label\";s:8:\"Sriracha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Srisakdi\";a:3:{s:5:\"label\";s:8:\"Srisakdi\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Staatliches\";a:3:{s:5:\"label\";s:11:\"Staatliches\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Stalemate\";a:3:{s:5:\"label\";s:9:\"Stalemate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Stalinist One\";a:3:{s:5:\"label\";s:13:\"Stalinist One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Stardos Stencil\";a:3:{s:5:\"label\";s:15:\"Stardos Stencil\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Stick\";a:3:{s:5:\"label\";s:5:\"Stick\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Stick No Bills\";a:3:{s:5:\"label\";s:14:\"Stick No Bills\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Stint Ultra Condensed\";a:3:{s:5:\"label\";s:21:\"Stint Ultra Condensed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"Stint Ultra Expanded\";a:3:{s:5:\"label\";s:20:\"Stint Ultra Expanded\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Stoke\";a:3:{s:5:\"label\";s:5:\"Stoke\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Strait\";a:3:{s:5:\"label\";s:6:\"Strait\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Style Script\";a:3:{s:5:\"label\";s:12:\"Style Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Stylish\";a:3:{s:5:\"label\";s:7:\"Stylish\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Sue Ellen Francisco\";a:3:{s:5:\"label\";s:19:\"Sue Ellen Francisco\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Suez One\";a:3:{s:5:\"label\";s:8:\"Suez One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Sulphur Point\";a:3:{s:5:\"label\";s:13:\"Sulphur Point\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Sumana\";a:3:{s:5:\"label\";s:6:\"Sumana\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Sunflower\";a:3:{s:5:\"label\";s:9:\"Sunflower\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Sunshiney\";a:3:{s:5:\"label\";s:9:\"Sunshiney\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Supermercado One\";a:3:{s:5:\"label\";s:16:\"Supermercado One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Sura\";a:3:{s:5:\"label\";s:4:\"Sura\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Suranna\";a:3:{s:5:\"label\";s:7:\"Suranna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Suravaram\";a:3:{s:5:\"label\";s:9:\"Suravaram\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Suwannaphum\";a:3:{s:5:\"label\";s:11:\"Suwannaphum\";s:8:\"variants\";a:5:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"900\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Swanky and Moo Moo\";a:3:{s:5:\"label\";s:18:\"Swanky and Moo Moo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Syncopate\";a:3:{s:5:\"label\";s:9:\"Syncopate\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Syne\";a:3:{s:5:\"label\";s:4:\"Syne\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Syne Mono\";a:3:{s:5:\"label\";s:9:\"Syne Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:12:\"Syne Tactile\";a:3:{s:5:\"label\";s:12:\"Syne Tactile\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Tai Heritage Pro\";a:3:{s:5:\"label\";s:16:\"Tai Heritage Pro\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Tajawal\";a:3:{s:5:\"label\";s:7:\"Tajawal\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Tangerine\";a:3:{s:5:\"label\";s:9:\"Tangerine\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Tapestry\";a:3:{s:5:\"label\";s:8:\"Tapestry\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Taprom\";a:3:{s:5:\"label\";s:6:\"Taprom\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Tauri\";a:3:{s:5:\"label\";s:5:\"Tauri\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Taviraj\";a:3:{s:5:\"label\";s:7:\"Taviraj\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Teko\";a:3:{s:5:\"label\";s:4:\"Teko\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Telex\";a:3:{s:5:\"label\";s:5:\"Telex\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Tenali Ramakrishna\";a:3:{s:5:\"label\";s:18:\"Tenali Ramakrishna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Tenor Sans\";a:3:{s:5:\"label\";s:10:\"Tenor Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Text Me One\";a:3:{s:5:\"label\";s:11:\"Text Me One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Texturina\";a:3:{s:5:\"label\";s:9:\"Texturina\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Thasadith\";a:3:{s:5:\"label\";s:9:\"Thasadith\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"The Girl Next Door\";a:3:{s:5:\"label\";s:18:\"The Girl Next Door\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"The Nautigal\";a:3:{s:5:\"label\";s:12:\"The Nautigal\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Tienne\";a:3:{s:5:\"label\";s:6:\"Tienne\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"900\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Tillana\";a:3:{s:5:\"label\";s:7:\"Tillana\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Tilt Neon\";a:3:{s:5:\"label\";s:9:\"Tilt Neon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Tilt Prism\";a:3:{s:5:\"label\";s:10:\"Tilt Prism\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Tilt Warp\";a:3:{s:5:\"label\";s:9:\"Tilt Warp\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Timmana\";a:3:{s:5:\"label\";s:7:\"Timmana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Tinos\";a:3:{s:5:\"label\";s:5:\"Tinos\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Tiro Bangla\";a:3:{s:5:\"label\";s:11:\"Tiro Bangla\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:21:\"Tiro Devanagari Hindi\";a:3:{s:5:\"label\";s:21:\"Tiro Devanagari Hindi\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"Tiro Devanagari Marathi\";a:3:{s:5:\"label\";s:23:\"Tiro Devanagari Marathi\";s:8:\"variants\";a:2:{i: