<?php

add_ux_builder_shortcode( 'ux_slider', array(
    'type' => 'container',
    'name' => __( 'اسلایدر' ),
    'category' => __( 'طرح' ),
    'message' => __( 'اسلایدها را در اینجا اضافه کنید' ),
    'directives' => array( 'ux-slider' ),
    'allow' => array( 'ux_banner','ux_image','ux_lottie','section','row','ux_banner_grid','logo'),
    'template' => flatsome_ux_builder_template( 'ux_slider.html' ),
    'thumbnail' =>  flatsome_ux_builder_thumbnail( 'slider' ),
    'tools' => 'shortcodes/ux_slider/ux-slider-tools.directive.html',
    'wrap'   => false,
    'info' => '{{ label }}',
    'priority' => -1,

    'toolbar' => array(
        'show_children_selector' => true,
        'show_on_child_active' => true,
    ),

    'children' => array(
        'inline' => true,
        'addable_spots' => array( 'left', 'right' )
    ),

    /*
    'presets' => array(
        array(
            'name' => __( 'Default' ),
            'content' => '[ux_slider]',
        ),
        array(
            'name' => __( 'Simple Banner' ),
            'content' => '[ux_slider][ux_banner][/ux_slider]',
        ),
    ), */

    'options' => array(
        'label' => array(
            'type' => 'textfield',
            'heading' => 'لیبل ادمین',
            'placeholder' => 'لیبل ادمین را وارد کنید ...'
        ),
        'type' => array(
          'type' => 'select',
          'heading' => 'تایپو',
          'default' => 'slide',
          'options' => array(
            'slide' => 'اسلاید',
            'fade' => 'محو شدن',
          ),
        ),
        'layout_options' => array(
          'type' => 'group',
          'heading' => __( 'طرح' ),
          'options' => array(
            'style' => array(
              'type' => 'select',
              'heading' => 'استایل',
              'default' => 'normal',
              'options' => array(
                  'normal' => 'پیشفرض',
                  'container' => 'کانتینر',
                  'focus' => 'تمرکز',
                  'shadow' => 'سایه',
              ),
              'conditions' => 'type !== "fade"',
            ),
            'slide_width' => array(
              'type' => 'scrubfield',
              'responsive' => true,
              'heading' => 'عرض اسلاید',
              'placeholder' => 'عرض بر حسب Px',
              'default' => '',
              'min' => '0',
              'conditions' => 'type !== "fade"',
            ),

            'slide_align' => array(
              'type' => 'select',
              'heading' => 'تراز اسلاید',
              'default' => 'center',
              'options' => array(
                  'center' => 'مرکز',
                  'left' => 'چپ',
                  'right' => 'راست',
              ),
              'conditions' => 'type !== "fade"',
            ),
            'bg_color' => array(
              'type' => 'colorpicker',
              'heading' => __('رنگ پس زمینه'),
              'format' => 'rgb',
              'position' => 'bottom right',
              'helpers' => require( __DIR__ . '/helpers/colors.php' ),
            ),
            'margin' => array(
              'type' => 'scrubfield',
              'responsive' => true,
              'heading' => __('حاشیه'),
              'default' => '0px',
              'min' => 0,
              'max' => 100,
              'step' => 1
            ),
            'infinitive' => array(
                'type' => 'radio-buttons',
                'heading' => __('Infinitive'),
                'default' => 'true',
                'options' => array(
                    'false'  => array( 'title' => 'غیرفعال'),
                    'true'  => array( 'title' => 'فعال'),
                ),
            ),
            'freescroll' => array(
                'type' => 'radio-buttons',
                'heading' => __('اسکرول آزاد'),
                'default' => 'false',
                'options' => array(
                    'false'  => array( 'title' => 'غیرفعال'),
                    'true'  => array( 'title' => 'فعال'),
                ),
            ),
            'draggable' => array(
                'type' => 'radio-buttons',
                'heading' => __('قابل کشیدن'),
                'default' => 'true',
                'options' => array(
                    'false'  => array( 'title' => 'غیرفعال'),
                    'true'  => array( 'title' => 'فعال'),
                ),
            ),
            'parallax' => array(
                'type' => 'slider',
                'heading' => 'پارالاکس',
                'unit' => '+',
                'default' => 0,
                'max' => 10,
                'min' => 0,
            ),
            'mobile' => array(
                'type' => 'radio-buttons',
                'heading' => __('نمایش برای موبایل'),
                'default' => 'true',
                'options' => array(
                    'false'  => array( 'title' => 'غیرفعال'),
                    'true'  => array( 'title' => 'فعال'),
                ),
            ),
          ),
        ),

        'nav_options' => array(
          'type' => 'group',
          'heading' => __( 'ناوبری' ),
          'options' => array(
            'hide_nav' => array(
                'type' => 'radio-buttons',
                'heading' => __('همیشه قابل مشاهده'),
                'default' => '',
                'options' => array(
                    ''  => array( 'title' => 'غیرفعال'),
                    'true'  => array( 'title' => 'فعال'),
                ),
            ),
            'nav_pos' => array(
              'type' => 'select',
              'heading' => 'موقعیت',
              'default' => '',
              'options' => array(
                  '' => 'سمت داخل',
                  'outside' => 'سمت بیرون',
              )
            ),
           'nav_size' => array(
              'type' => 'select',
              'heading' => 'اندازه',
              'default' => 'large',
              'options' => array(
                  'large' => 'بزرگ',
                  'normal' => 'معمولی',
              )
            ),
            'arrows' => array(
              'type' => 'radio-buttons',
              'heading' => __('فلش ها'),
              'default' => 'true',
              'options' => array(
                'false'  => array( 'title' => 'غیرفعال'),
                'true'  => array( 'title' => 'فعال'),
                ),
            ),
            'nav_style' => array(
              'type' => 'select',
              'heading' => __('استایل فلش'),
              'default' => 'circle',
              'options' => array(
                  'circle' => 'دایره',
                  'simple' => 'ساده',
                  'reveal' => 'آشکار ساختن',
              )
            ),
            'nav_color' => array(
                'type' => 'radio-buttons',
                'heading' => __('رنگ فلش'),
                'default' => 'light',
                'options' => array(
                    'dark'  => array( 'title' => 'تیره'),
                    'light'  => array( 'title' => 'روشن'),
                ),
            ),

            'bullets' => array(
              'type' => 'radio-buttons',
              'heading' => __('گلوله ها'),
              'default' => 'true',
              'options' => array(
                  'false'  => array( 'title' => 'غیرفعال'),
                  'true'  => array( 'title' => 'فعال'),
              ),
            ),
            'bullet_style' => array(
              'type' => 'select',
              'heading' => 'استایل گلوله',
              'default' => 'circle',
              'options' => array(
                'circle' => 'Circle',
                'dashes' => 'Dashes',
                'dashes-spaced' => 'خط تیره (با فاصله)',
                'simple' => 'ساده',
                'square' => 'مربع',
            )
           ),
          ),
        ),
        'slide_options' => array(
          'type' => 'group',
          'heading' => __( 'اسلاید خودکار' ),
          'options' => array(
            'auto_slide' => array(
                'type' => 'radio-buttons',
                'heading' => __('اسلاید خودکار'),
                'default' => 'true',
                'options' => array(
                    'false'  => array( 'title' => 'غیرفعال'),
                    'true'  => array( 'title' => 'فعال'),
                ),
            ),
            'timer' => array(
                'type' => 'textfield',
                'heading' => 'تایمر (ms)',
                'default' => 6000,
            ),
            'pause_hover' => array(
                'type' => 'radio-buttons',
                'heading' => __('مکث در هاور'),
                'default' => 'true',
                'options' => array(
                    'false'  => array( 'title' => 'غیرفعال'),
                    'true'  => array( 'title' => 'فعال'),
                ),
            ),
          ),
        ),
        'advanced_options' => require( __DIR__ . '/commons/advanced.php'),
    ),
) );
