<?php

if ( ! isset( $repeater_posts ) ) $repeater_posts = 'posts';
if ( ! isset( $repeater_post_type ) ) $repeater_post_type = 'post';
if ( ! isset( $repeater_post_cat ) ) $repeater_post_cat = 'category';

return array(
    'type' => 'group',
    'heading' => __( 'پست ها' ),
    'options' => array(

     'ids' => array(
        'type' => 'select',
        'heading' => 'پست های سفارشی',
        'param_name' => 'ids',
		'full_width' => true,
        'config' => array(
            'multiple' => true,
            'placeholder' => 'انتخاب ...',
            'postSelect' => array(
                'post_type' => array($repeater_post_type)
            ),
        )
    ),

    'cat' => array(
        'type' => 'select',
        'heading' => 'دسته',
        'param_name' => 'cat',
		'full_width' => true,
        'conditions' => 'ids == ""',
        'default' => '',
        'config' => array(
            'multiple' => true,
            'placeholder' => 'انتخاب ...',
            'termSelect' => array(
                'post_type' => $repeater_post_cat,
                'taxonomies' => $repeater_post_cat
            ),
        )
    ),

    $repeater_posts => array(
        'type' => 'textfield',
        'heading' => 'مجموع پست ها',
        'conditions' => 'ids == ""',
        'default' => '8',
    ),

    'offset' => array(
        'type' => 'textfield',
        'heading' => 'افست',
        'conditions' => 'ids == ""',
        'default' => '',
    ),

     'orderby'       => array(
	     'type'       => 'select',
	     'heading'    => 'ترتیب بر اساس',
	     'conditions' => 'ids == ""',
	     'default'    => 'date',
	     'options'    => array(
		     'ID'            => 'ID یا شناسه',
		     'title'         => 'عنوان',
		     'name'          => 'نام',
		     'date'          => 'تاریخ انتشار',
		     'modified'      => 'تاریخ بروزرسانی',
		     'rand'          => 'تصادفی',
		     'comment_count' => 'تعداد نظرات',
		     'menu_order'    => 'ترتیب منو',
	     ),
     ),

     'order'         => array(
	     'type'       => 'select',
	     'heading'    => 'ترتیب',
	     'conditions' => 'ids == ""',
	     'default'    => 'نزولی',
	     'options'    => array(
		     'ASC'  => 'wu,nd',
		     'DESC' => 'نزولی',
	     ),
     ),

    'tags' => array(
	    'type'       => 'select',
	    'heading'    => 'برچسب',
	    'conditions' => 'ids == ""',
	    'full_width' => true,
	    'default'    => '',
	    'config'     => array(
		    'multiple'    => true,
		    'placeholder' => 'انتخاب ...',
		    'termSelect'  => array(
			    'post_type'  => $repeater_post_type,
			    'taxonomies' => 'post_tag',
		    ),
	    ),
    ),

)
);
