<?php
/**
 * Advanced Theme Options
 *
 * @package Flatsome/Admin/Options/Advanced
 */

add_action( 'init', 'of_options' );

if ( ! function_exists( 'of_options' ) ) {
	/**
	 * Advance Theme Options.
	 *
	 * @global array $of_options Description.
	 *
	 * @return void.
	 */
	function of_options() {
		// Access the WordPress Categories via an Array.
		$of_categories     = array();
		$of_categories_obj = get_categories( 'hide_empty=0' );
		foreach ( $of_categories_obj as $of_cat ) {
			$of_categories[ $of_cat->cat_ID ] = $of_cat->cat_name;
		}

		// Access the WordPress Pages via an Array.
		$of_pages      = array();
		$of_pages_obj  = get_pages( 'sort_column=post_parent,menu_order' );
		$of_pages['0'] = 'انتخاب یک صفحه:';
		foreach ( $of_pages_obj as $of_page ) {
			$of_pages[ $of_page->ID ] = $of_page->post_title;
		}

		// Set the Options Array.
		global $of_options;
		$of_options = array();

		$of_options[] = array(
			'name' => 'تنظیمات سراسری',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'اسکریپت های هدر',
			'desc' => 'اسکریپت های سفارشی را داخل تگ HEAD اضافه کنید. شما باید یک تگ SCRIPT در اطراف اسکریپت ها داشته باشید.',
			'id'   => 'html_scripts_header',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'اسکریپت های فوتر',
			'desc' => 'اسکریپت های سفارشی را که ممکن است بخواهید در فوتر وبسایت خود بارگذاری شوند، اضافه کنید. شما باید یک تگ SCRIPT در اطراف اسکریپت ها داشته باشید.',
			'id'   => 'html_scripts_footer',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'اسکریپت های بدنه - بالا',
			'desc' => 'اسکریپت های سفارشی را درست بعد از باز شدن تگ BODY اضافه کنید. شما باید یک تگ SCRIPT در اطراف اسکریپت ها داشته باشید.',
			'id'   => 'html_scripts_after_body',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'اسکریپت های بدنه - پایین',
			'desc' => 'اسکریپت های سفارشی را درست قبل از بسته شدن تگ BODY اضافه کنید. شما باید یک تگ SCRIPT در اطراف اسکریپت ها داشته باشید.',
			'id'   => 'html_scripts_before_body',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'پشتیبانی از محتوای FLATSOME 2.0',
			'id'   => 'flatsome_fallback',
			'desc' => 'پشتیبانی از محتوای ساخته شده در Flatsome 2.0. برای افزایش سرعت سایت غیر فعال کنید.',
			'std'  => 1,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => 'CSS سفارشی',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'همه صفحه نمایش',
			'desc' => 'CSS سفارشی را در اینجا اضافه کنید',
			'id'   => 'html_custom_css',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'تبلت ها و پایین',
			'desc' => 'CSS سفارشی را اینجا برای تبلت و موبایل اضافه کنید',
			'id'   => 'html_custom_css_tablet',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'فقط موبایل',
			'desc' => 'CSS سفارشی را اینجا برای نمایش موبایل اضافه کنید',
			'id'   => 'html_custom_css_mobile',
			'std'  => '',
			'type' => 'textarea',
		);

		// Performance.
		$of_options[] = array(
			'name' => 'Performance',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => '',
			'type' => 'info',
			'desc' => '<p style="font-size:14px">با احتیاط استفاده کنید! اگر مشکل سازگاری افزونه دارید غیرفعال کنید.</p>',
		);

		$of_options[] = array(
			'name' => 'از پیش بارگذاری صفحات',
			'id'   => 'perf_instant_page',
			'desc' => 'برای مرور سریع بین صفحات، درست قبل از اینکه کاربر روی آن کلیک کند، صفحات را پیش بارگذاری کنید.',
			'std'  => 0,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => 'بارگذاری تنبل بنر و پس زمینه بخش',
			'id'   => 'lazy_load_backgrounds',
			'desc' => 'فعال کردن بارگذاری تنبل پس زمینه بنر و بخش.',
			'std'  => 1,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => 'بارگذاری تنبل تصاویر',
			'id'   => 'lazy_load_images',
			'desc' => 'بارگذاری تنبل را برای تصاویر فعال کنید. این یک تصویر خالی Base64 با نسبت تصویر مشابه با تصویر اصلی ایجاد می کند.',
			'std'  => 0,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => 'غیرفعال کردن style.css قالب',
			'type' => 'checkbox',
			'id'   => 'flatsome_disable_style_css',
			'std'  => 0,
			'desc' => 'بارگیری style.css قالب را غیرفعال کنید. این فایل تنها زمانی مورد نیاز است که CSS سفارشی را به آن فایل اضافه کرده باشید.',
		);

		$of_options[] = array(
			'name' => 'غیرفعال کردن اسکریپت ایموجی',
			'type' => 'checkbox',
			'id'   => 'disable_emoji',
			'std'  => 0,
			'desc' => 'حذف اسکریپت های ایموجی WP از سمت کاربری.',
		);

		$of_options[] = array(
			'name' => 'غیرفعال کردن css کتابخانه بلوک',
			'type' => 'checkbox',
			'id'   => 'disable_blockcss',
			'std'  => 0,
			'desc' => 'حذف css کتابخانه بلوک پیشفرض که از وردپرس می‌آید',
		);

		$of_options[] = array(
			'name' => 'غیرفعال کردن انتقال جی کوئری',
			'type' => 'checkbox',
			'id'   => 'jquery_migrate',
			'std'  => 0,
			'desc' => 'jQuery انتقال را حذف کنید. اکثر کدهای فرانت اند به روز و افزونه ها به jquery-migrate.min.js نیاز ندارند. اغلب اوقات، حفظ این - به سادگی بار غیر ضروری را به سایت شما اضافه می کند.',
		);

		// Content delivery.
		$of_options[] = array(
			'name' => 'Content Delivery',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => '',
			'type' => 'info',
			'desc' => '<h2 style="font-size:1rem; margin-top: 40px;">بارگذاری ایجکس<span class="of-tag">تجربی</span></h2><p style="font-size:14px">بدون بارگیری مجدد کل صفحه، محتوا را از سرور واکشی کنید. این یک ویژگی آزمایشی است و ممکن است تغییر کند. <b>اگر با مشکلات سازگاری افزونه مواجه شدید، غیرفعال کنید.</b></p><p><a target="_blank" rel="noopener" href="https://docs.uxthemes.com/article/430-pjax">بیشتر بدانید</a></p>',
		);

		$of_options[] = array(
			'name'    => 'صفحه بندی وبلاگ',
			'id'      => 'blog_pagination',
			'std'     => '',
			'type'    => 'select',
			'options' => array(
				''     => 'ناوبری معمولی',
				'ajax' => 'AJAX navigation',
			),
		);

		if ( is_woocommerce_activated() ) {
			$of_options[] = array(
				'name'    => 'صفحه بندی فروشگاه',
				'id'      => 'shop_pagination',
				'std'     => '',
				'type'    => 'select',
				'options' => array(
					''                => 'ناوبری معمولی',
					'ajax'            => 'ناوبری ایجکس',
					'infinite-scroll' => 'اسکرول بینهایت',
				),
			);

			$of_options[] = array(
				'name' => 'آرشیو فروشگاه',
				'id'   => 'shop_filter_widgets_pjax',
				'desc' => 'فعال کردن ایجکس برای ابزارک دسته محصول و ابزارک های فیلتر',
				'std'  => 0,
				'type' => 'checkbox',
			);
		}

		$of_options[] = array(
			'name' => 'اسکرول به بالا',
			'id'   => 'pjax_scroll_to_top',
			'desc' => 'اسکرول به بالا بعد ا زپیشمایش ایجکس',
			'std'  => 0,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => '',
			'type' => '',
			'desc' => '<h2 style="font-size:1rem; margin-top: 40px;">تنظیمات اسکرول بی نهایت</h2>',
		);

		$of_options[] = array(
			'name'    => 'نوع بارگذاری',
			'id'      => 'infinite_scroll_loader_type',
			'desc'    => 'انیمیشن نوع بارگذاری را انتخاب کنید یا روی دکمه کلیک کنید.',
			'std'     => 'spinner',
			'type'    => 'select',
			'options' => array(
				'button'  => 'دکمه (در کلیک)',
				'spinner' => 'اسپینر',
				'image'   => 'تصویر سفارشی',
			),
		);

		$of_options[] = array(
			'name' => 'تصویر لودر سفارشی',
			'desc' => "یک تصویر بارگیری سفارشی را آپلود یا انتخاب کنید (برای بارگذاری نوع 'تصویر سفارشی'",
			'id'   => 'infinite_scroll_loader_img',
			'std'  => '',
			'type' => 'upload',
		);

		$of_options[] = array(
			'name' => 'Site Loader',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name'    => 'بارگذاری کننده سایت',
			'id'      => 'site_loader',
			'desc'    => 'فعال کردن پوشش لودر سایت هنگام بارگذاری سایت.',
			'type'    => 'select',
			'std'     => '',
			'options' => array(
				''     => 'غیرفعال',
				'home' => 'فعال کردن در صفحه اصلی',
				'all'  => 'فعال کردن در همه صفحات',
			),
		);

		$of_options[] = array(
			'name'    => 'رنگ',
			'id'      => 'site_loader_color',
			'type'    => 'select',
			'std'     => 'light',
			'options' => array(
				'light' => 'روشن',
				'dark'  => 'تیره',
			),
		);

		$of_options[] = array(
			'name' => 'رنگ پس زمینه',
			'id'   => 'site_loader_bg',
			'std'  => '',
			'type' => 'color',
		);

		$of_options[] = array(
			'name' => 'Site Search',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'جستجو زنده',
			'id'   => 'live_search',
			'desc' => 'فعال کردن جستجو زنده برای محصولات، صفحات و پست ها.',
			'std'  => 1,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => 'متن نگهدارنده جستجو',
			'desc' => 'تغییر متن نگهدارنده فیلد جستجو.',
			'id'   => 'search_placeholder',
			'type' => 'text',
		);

		$of_options[] = array(
			'name'    => 'تأخیر نتایج جستجو',
			'desc'    => 'تنظیم تأخیر برای نتایج جستجو زنده.',
			'id'      => 'search_result_latency',
			'std'     => '0',
			'type'    => 'select',
			'options' => array(
					'0'    => 'فوری',
					'500'  => '500 ms',
					'1000' => '1000 ms',
					'1500' => '1500 ms',
					'2000' => '2000 ms',
				),
		);

		if ( is_woocommerce_activated() ) {

			$of_options[] = array(
				'name' => 'نمایش وبلاگ و صفحات در نتایج جستجو',
				'id'   => 'search_result',
				'desc' => 'فعال کردن وبلاگ و صفحات در نتایج جستجو.',
				'std'  => 1,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name'    => 'استایل لیست پست ها و صفحات',
				'id'      => 'search_result_style',
				'desc'    => 'نمایش نتایج به صورت ردیف، masonry یا استایل اسلایدر.',
				'type'    => 'select',
				'std'     => 'slider',
				'options' => array(
					'row'     => 'ردیف',
					'masonry' => 'Masonry',
					'slider'  => 'اسلایدر',
				),
			);

			$of_options[] = array(
				'name'    => 'جستجوی محصولات بر اساس',
				'id'      => 'search_products_order_by',
				'type'    => 'select',
				'std'     => 'relevance',
				'options' => array(
					'relevance' => 'Relevance',
					'title'     => 'عنوان',
					'price'     => 'قیمت',
				),
			);

			$of_options[] = array(
				'name' => 'جستجو SKU محصول',
				'desc' => 'امکان جستجو بر اساس SKU در جستجوی زنده.',
				'id'   => 'search_by_sku',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'جستجو برچسب محصول',
				'desc' => 'امکان جستجو بر اساس برچسب های محصول در جستجوی زنده.',
				'id'   => 'search_by_product_tag',
				'std'  => 0,
				'type' => 'checkbox',
			);
		}

		$of_options[] = array(
			'name' => 'Instagram',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'تنظیمات خوراک',
			'id'   => 'instagram_lazy_load',
			'desc' => 'هنگامی که فیدهای اینستاگرام در viewport ظاهر می شوند، تنبل بارگذاری می شوند.',
			'std'  => 0,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => 'حساب ها',
			'std'  => flatsome_facebook_accounts_html(),
			'type' => 'info',
		);

		$of_options[] = array(
			'name' => 'کش',
			'std'  => flatsome_facebook_cache_html(),
			'type' => 'info',
		);

		$of_options[] = array(
			'name' => 'حساب تجاری',
			'desc' => flatsome_facebook_login_button_html(),
			'type' => 'info',
		);

		$of_options[] = array(
			'name' => 'Google APIs',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'API نقشه های گوگل',
			'desc' => "کلید Google Maps API را در اینجا وارد کنید تا نقشه ها فعال شود. شما می توانید یکی را در اینجا ایجاد کنید : <a target='_blank' href='https://developers.google.com/maps/documentation/javascript/get-api-key'>Google Maps API</a>",
			'id'   => 'google_map_api',
			'std'  => '',
			'type' => 'text',
		);

		$maintenance_mode = apply_filters( 'flatsome_maintenance_mode', [ 'access_mode' => 'roles' ] );

		$of_options[] = array(
			'name' => 'Maintenance Mode',
			'type' => 'heading',
		);

		if ( ! empty( $maintenance_mode['access_mode'] ) ) {
			$access_mode = $maintenance_mode['access_mode'];

			$supported_modes = [ 'logged_in', 'roles', 'current_user_can' ];
			$display_mode    = in_array( $access_mode, $supported_modes, true )
				? $access_mode
				: sprintf( '%s (not supported)', $access_mode );

			$of_options[] = array(
				'name' => '',
				'type' => 'info',
				'desc' => sprintf( '<p style="font-size:14px">Access mode: %s</p>', $display_mode ),
			);
		}

		$of_options[] = array(
			'name' => 'حالت تعمیر و نگهداری',
			'id'   => 'maintenance_mode',
			'desc' => 'فعال کردن حالت تعمیر و نگهداری برای همه کاربران به جز مدیران.',
			'std'  => 0,
			'type' => 'checkbox',
		);

		if ( ! empty( $maintenance_mode['access_mode'] && $maintenance_mode['access_mode'] === 'roles' ) ) {
			$of_options[] = array(
				'name'    => 'حذف نقش ها',
				'id'      => 'maintenance_mode_excluded_roles',
				'desc'    => 'نقش ها را از حالت نگهداری حذف کنید (ادمین همیشه دسترسی دارد).',
				'std'     => array(),
				'type'    => 'multicheck',
				'options' => flatsome_get_role_list( array(
					'exclude' => array(
						'super_admin',
						'administrator',
					),
				) ),
			);
		}

		$of_options[] = array(
			'name' => 'کلید دور زدن',
			'id'   => 'maintenance_mode_bypass_key',
			'desc' => 'یک کلید منحصر به فرد را در اینجا وارد کنید. این کلید وقتی به عنوان پارامتر در URL اضافه می شود، به کاربر اجازه می دهد تا حالت تعمیر و نگهداری را دور بزند و به وب سایت دسترسی پیدا کند. برای مثال، اگر «key1234» را به‌عنوان کلید وارد کنید، می‌توانید با اضافه کردن کلید f.ex، حالت تعمیر و نگهداری را در هر URL دور بزنید: https://example.com/?key1234 یا https://example.com/shop /?key1234 و غیره',
			'std'  => '',
			'type' => 'text',
		);

		$of_options[] = array(
			'name' => 'اعلان ادمین',
		'id'   => 'maintenance_mode_admin_notice',
			'desc' => 'نمایش اعلان ادمین، وقتی حالت تعمیر و نگهداری فعال است.',
			'std'  => 1,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name'    => 'صفحه تعمیر و نگهداری سفارشی',
			'id'      => 'maintenance_mode_page',
			'desc'    => 'یک صفحه سفارشی را به عنوان صفحه تعمیر و نگهداری تنظیم کنید. این صفحه فقط برای بازدیدکنندگان قابل مشاهده خواهد بود.',
			'std'     => 0,
			'type'    => 'select',
			'options' => $of_pages,
		);

		$of_options[] = array(
			'name' => 'متن حالت تعمیر و نگهداری',
			'desc' => 'متنی که هنگام دسترسی به صفحه تعمیر و نگهداری برای مشتریان شما قابل مشاهده خواهد بود.',
			'id'   => 'maintenance_mode_text',
			'std'  => 'لطفا به زودی دوباره بررسی کنید ...',
			'type' => 'text',
		);

		$of_options[] = array(
			'name' => '404 Page',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name'    => 'بلوک 404 سفارشی',
			'id'      => '404_block',
			'desc'    => 'محتوای صفحه 404 را با یک بلوک سفارشی جایگزین کنید که می توانید آن را در صفحه ساز ویرایش کنید.',
			'std'     => 0,
			'type'    => 'select',
			'options' => flatsome_get_block_list_by_id( array( 'option_none' => '-- هیچ --' ) ),
		);

		if ( is_woocommerce_activated() ) {

			$of_options[] = array(
				'name' => 'WooCommerce',
				'type' => 'heading',
			);

			$of_options[] = array(
				'name' => 'متغییرهای محصول',
				'id'   => 'swatches',
				'desc' => 'فعال کردن اسواچزهای متغییرها.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'id'   => 'additional_variation_images',
				'desc' => 'فعال کردن تصاویر اضافی متغییر (گالری فلت سام).',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'محصول تک',
				'id'   => 'ajax_add_to_cart',
				'desc' => 'فعال کردن دکمه های افزودن به سبد خرید ایجکس در صفحه محصول و مشاهده سریع.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'غیرفعال کردن سراسری نظرات محصولات',
				'id'   => 'disable_reviews',
				'desc' => 'غیرفعال کردن سراسری نظرات محصول.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'گالری محصول ووکامرس',
				'id'   => 'product_gallery_woocommerce',
				'desc' => 'برای سازگاری افزونه ها از اسلایدر گالری ووکامرس پیشفرض استفاده کنید. <br>(با این کار گالری محصول فلت سام و چندین گزینه برای آن غیرفعال می شود)',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'هدر فروشگاه',
				'desc' => 'HTML را وارد کنید که باید در بالای صفحه اصلی فروشگاه قرار گیرد. کد کوتاه مجاز است. ',
				'id'   => 'html_shop_page',
				'std'  => '',
				'type' => 'textarea',
			);

			$of_options[] = array(
				'name' => 'عنوان تب/بخش سراسری اضافی',
				'id'   => 'tab_title',
				'std'  => '',
				'type' => 'text',
			);

			$of_options[] = array(
				'name' => 'محتوا تب/بخش سراسری اضافی',
				'id'   => 'tab_content',
				'std'  => '',
				'type' => 'textarea',
				'desc' => 'محتوای تب اضافی را در اینجا اضافه کنید ... مانند نمودار اندازه و غیره.',
			);

			$of_options[] = array(
				'name' => 'HTML قبل از دکمه افزودن به سبد خرید (سراسری)',
				'desc' => 'HTML و کدهای کوتاه را وارد کنید که قبل از انتخاب های افزودن به سبد خرید نشان داده می شوند.',
				'id'   => 'html_before_add_to_cart',
				'std'  => ' ',
				'type' => 'textarea',
			);

			$of_options[] = array(
				'name' => 'HTML بعد از دکمه افزودن به سبد خرید (سراسری)',
				'desc' => 'HTML و کدهای کوتاه را وارد کنید که بعد از دکمه افزودن به سبد خرید نشان داده می شوند.',
				'id'   => 'html_after_add_to_cart',
				'std'  => '',
				'type' => 'textarea',
			);

			$of_options[] = array(
				'name' => 'اسکریپت ها/محتوا صفحه تشکر از شما',
				'desc' => 'اسکریپت ها یا محتوای HTML سفارشی را برای صفحه تشکر در اینجا وارد کنید',
				'id'   => 'html_thank_you',
				'std'  => '',
				'type' => 'textarea',
			);

			$of_options[] = array(
				'name' => 'Catalog Mode',
				'type' => 'heading',
			);

			$of_options[] = array(
				'name' => 'فعال کردن حالت کاتالوگ',
				'id'   => 'catalog_mode',
				'desc' => 'حالت کاتالوگ را فعال کنید. این کار دکمه های افزودن به سبد خرید / پرداخت و سبد خرید را غیرفعال می کند.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'غیرفعال کردن قیمت ها',
				'id'   => 'catalog_mode_prices',
				'desc' => 'برای غیرفعال کردن قیمت ها در صفحات دسته بندی و صفحه محصول انتخاب کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'حذف نشان حراج',
				'id'   => 'catalog_mode_sale_badge',
				'desc' => 'برای حذف نشان های حراج انتخاب کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'جایگزینی سبد خرید/حساب (هدر)',
				'id'   => 'catalog_mode_header',
				'std'  => '',
				'type' => 'textarea',
				'desc' => "محتوایی را که می خواهید به جای حساب/سبد خرید نمایش دهید را وارد کنید. کد کوتاه مجاز است. برای کادر جستجو <b>[search]</b> را وارد کنید. برای آیکون های اجتماعی وارد کنید : <b>[follow twitter='http://' facebook='http://' email='post@email.com' pinterest='http://']</b>",
			);

			$of_options[] = array(
				'name' => 'جایگزینی افزودن به سبد خرید - صفحه محصول',
				'id'   => 'catalog_mode_product',
				'std'  => '',
				'type' => 'textarea',
				'desc' => 'اطلاعات تماس یا کد کوتاه فرم درخواست را در اینجا وارد کنید.',
			);

			$of_options[] = array(
				'name' => 'جایگزینی افزودن به سبد خرید - نمایش سریع محصول',
				'id'   => 'catalog_mode_lightbox',
				'std'  => '',
				'type' => 'textarea',
				'desc' => 'متنی را وارد کنید که در نمایش سریع محصول نشان داده شود',
				);
		}

		// Portfolio.
		$of_options[] = array(
			'name' => 'Portfolio',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'فعال کردن نمونه کارها',
			'id'   => 'fl_portfolio',
			'desc' => 'فعال کردن نمونه کارها',
			'std'  => 1,
			'type' => 'checkbox',
		);

		// Mobile.
		$of_options[] = array(
			'name' => 'موبایل',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'پشتیبانی از پارالاکس موبایل',
			'id'   => 'parallax_mobile',
			'desc' => 'فعال کردن پارالکس برای دستگاه های موبایل',
			'std'  => 0,
			'type' => 'checkbox',
		);

		// Integrations.
		$of_options[] = array(
			'name' => 'Integrations',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => '',
			'type' => 'info',
			'desc' => '<p style="font-size:14px">گزینه های اضافی برای افزونه های یکپارچه در صورت فعال شدن در اینجا نشان داده می شود.</p>',
		);

		$of_options[] = array(
			'name' => 'Flatsome Studio',
			'id'   => 'flatsome_studio',
			'desc' => 'فعال کردن دسترسی به Flatsome Studio در UX Builder',
			'std'  => 1,
			'type' => 'checkbox',
		);

		if ( function_exists( 'ubermenu' ) ) {
			$of_options[] = array(
				'name' => 'Ubermenu',
				'id'   => 'flatsome_uber_menu',
				'desc' => 'UberMenu با عرض کامل را فعال کنید. همچنین می توانید با استفاده از گزینه های UberMenu این را در جای دیگری وارد کنید.',
				'std'  => 1,
				'type' => 'checkbox',
			);
		}

		// Yoast options.
		if ( class_exists( 'WPSEO_Options' ) ) {
			$of_options[] = array(
				'name' => 'Yoast Primary Category',
				'id'   => 'wpseo_primary_term',
				'desc' => 'استفاده در در صفحات و المان های دسته محصول.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => '',
				'id'   => 'wpseo_manages_product_layout_priority',
				'desc' => 'مدیریت اولویت طرح محصول سفارشی.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name'  => 'Yoast Breadcrumbs',
				'id'    => 'wpseo_breadcrumb',
				'desc'  => 'استفاده در صفحات دسته محصول، صفحات محصول و المان ها.',
				'std'   => 0,
				'folds' => 1,
				'type'  => 'checkbox',
			);

			$of_options[] = array(
				'name' => '',
				'id'   => 'wpseo_breadcrumb_remove_last',
				'desc' => 'حذف آخرین crumb استاتیک در صفحات محصول (عنوان محصول).',
				'std'  => 1,
				'fold' => 'wpseo_breadcrumb',
				'type' => 'checkbox',
			);
		}

		// Rank Math options.
		if ( class_exists( 'RankMath' ) ) {
			$of_options[] = array(
				'name' => 'Rank Math Primary Category',
				'id'   => 'rank_math_primary_term',
				'desc' => 'استفاده در صفحات و المان های دسته محصول.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => '',
				'id'   => 'rank_math_manages_product_layout_priority',
				'desc' => 'مدیریت اولویت طرح محصول سفارشی.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'Rank Math Breadcrumbs',
				'id'   => 'rank_math_breadcrumb',
				'desc' => 'استفاده در صفحات دسته محصول، صفحات محصول و المان ها.',
				'std'  => 0,
				'type' => 'checkbox',
			);
		}

		// All in one SEO options.
		if ( class_exists( 'AIOSEO\Plugin\AIOSEO' ) ) {
			$of_options[] = array(
				'name' => 'AIOSEO Breadcrumbs',
				'id'   => 'aioseo_breadcrumb',
				'desc' => 'استفاده در صفحات دسته محصول، صفحات محصول و المان ها.',
				'std'  => 0,
				'type' => 'checkbox',
			);
		}

		// SEOPress options.
		if ( defined( 'SEOPRESS_VERSION' ) ) {
			$of_options[] = array(
				'name' => defined( 'SEOPRESS_PRO_VERSION' ) ? 'SEOPress Breadcrumbs' : 'SEOPress Breadcrumbs (Requires SeoPress PRO)',
				'id'   => 'wpseopress_breadcrumb',
				'desc' => 'استفاده در صفحات دسته محصول، صفحات محصول و المان ها.',
				'std'  => 0,
				'type' => 'checkbox',
			);
		}

		// Updates.
		$of_options[] = array(
			'name' => 'Updates',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name'    => 'کانال انتشار',
			'id'      => 'release_channel',
			'std'     => 'stable',
			'type'    => 'select',
			'options' => array(
				'stable' => 'پایدار',
				'beta'   => 'بتا',
			),
		);

		$of_options[] = array(
			'name' => '',
			'type' => 'warning',
			'desc' => '<p style="font-size:14px">با احتیاط استفاده کنید. از نسخه های پیش از انتشار در سایت های تولیدی استفاده نکنید. نسخه های بتا ممکن است پایدار نباشند.</p>',
		);

		// Backup Options.
		$of_options[] = array(
			'name' => 'Backup and Import',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'پشتیبان گیری و بازیابی تنظیمات',
			'id'   => 'of_backup',
			'std'  => '',
			'type' => 'backup',
			'desc' => 'می‌توانید از دکمه‌های بالا برای پشتیبان‌گیری از تنظیمات فعلی‌ تان استفاده کنید و بعداً آن را بازیابی کنید. اگر میخواهید روی تنظیمات آزمایش کنید، اما می‌خواهید تنظیمات قدیمی را در صورت نیاز به بازگشت، حفظ کنید، این کار مفید است.',
		);

		$of_options[] = array(
			'name' => 'انتقال داده های تنظیمات قالب',
			'id'   => 'of_transfer',
			'std'  => '',
			'type' => 'transfer',
			'desc' => 'می توانید با کپی کردن متن داخل کادر متن، داده های تنظیمات ذخیره شده را بین نصب های مختلف انتقال دهید. برای درون ریزی داده‌ها از یک نصب دیگر، داده‌های موجود در کادر متن را با یکی از نصب‌های دیگر جایگزین کنید و روی "وارد کردن گزینه‌ها" کلیک کنید.',
		);

	} // End of 'of_options()' function.
} // End check if function exists: of_options()
