<?php

$options = array(
	'per_page' => array(
		'type'    => 'slider',
		'heading' => 'تعداد',
		'default' => '12',
		'max'     => '99',
		'min'     => '4',
	),
	'columns'  => array(
		'type'    => 'slider',
		'heading' => 'ستون ها',
		'default' => '4',
		'max'     => '8',
		'min'     => '1',
	),
	'orderby'  => array(
		'type'    => 'select',
		'heading' => __( 'ترتیب بر اساس' ),
		'default' => 'title',
		'options' => array(
			'menu_order' => 'ترتیب منو',
			'title'      => 'عنوان',
			'date'       => 'تاریخ',
			'rand'       => 'تصادفی',
			//'id' => 'ID', // Valid but Disabled
		),
	),
	'order'    => array(
		'type'    => 'select',
		'heading' => __( 'ترتیب' ),
		'default' => 'asc',
		'options' => array(
			'asc'  => 'صعودی',
			'desc' => 'نزولی',
		),
	),
);

$options_custom = array(
	'ids'      => array(
		'type'       => 'select',
		'heading'    => 'محصولات',
		'param_name' => 'ids',
		'config'     => array(
			'multiple'    => true,
			'placeholder' => 'انتخاب ...',
			'postSelect'  => array(
				'post_type' => array( 'product' ),
			),
		),
	),
	'per_page' => array(
		'type'    => 'slider',
		'heading' => 'تعداد',
		'default' => '12',
		'max'     => '99',
		'min'     => '4',
	),
	'columns'  => array(
		'type'    => 'slider',
		'heading' => 'ستون ها',
		'default' => '4',
		'max'     => '8',
		'min'     => '1',
	),
	'orderby'  => array(
		'type'    => 'select',
		'heading' => __( 'ترتیب بر اساس' ),
		'default' => 'title',
		'options' => array(
			'menu_order' => 'ترتیب منو',
			'title'      => 'عنوان',
			'date'       => 'تاریخ',
			'rand'       => 'تصادفی',
			'price'      => 'قیمت',
			'popularity' => 'محبوبیت',
			'rating'     => 'امتیاز',
			//'id' => 'ID', // Valid but Disabled
		),
	),
	'order'    => array(
		'type'    => 'select',
		'heading' => __( 'ترتیب' ),
		'default' => 'asc',
		'options' => array(
			'asc'  => 'صعودی',
			'desc' => 'نزولی',
		),
	),
);

add_ux_builder_shortcode( 'products',
	array(
		'name'      => 'محصولات - سفارشی',
		'category'  => __( 'فروشگاه' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options_custom,
	)
);

add_ux_builder_shortcode( 'featured_products',
	array(
		'name'      => 'محصولات - ویژه',
		'category'  => __( 'فروشگاه' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options,
	)
);

add_ux_builder_shortcode( 'recent_products',
	array(
		'name'      => 'محصولات - آخرین',
		'category'  => __( 'فروشگاه' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options,
	)
);

add_ux_builder_shortcode( 'sale_products',
	array(
		'name'      => 'محصولات - حراج',
		'category'  => __( 'فروشگاه' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options,
	)
);

add_ux_builder_shortcode( 'best_selling_products',
	array(
		'name'      => 'محصولات - پرفروش ترین',
		'category'  => __( 'فروشگاه' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options,
	)
);

add_ux_builder_shortcode( 'top_rated_products',
	array(
		'name'      => 'محصولات - امتیاز بالا',
		'category'  => __( 'فروشگاه' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options,
	)
);
