<?php

// CART

Flatsome_Option::add_section( 'cart-checkout', array(
	'title'       => __( 'Cart', 'flatsome' ),
	'panel' => 'woocommerce',
  'priority'    => 1000
) );


Flatsome_Option::add_field( 'option', array(
  'type'        => 'radio-buttonset',
  'settings'     => 'cart_layout',
  'label'       => __( 'Cart layout', 'flatsome' ),
  'section'     => 'cart-checkout',
  'default'     => '',
  'choices'     => array(
    '' => __( 'Default', 'flatsome' ),
    'simple' => __( 'Simple', 'flatsome' ),
    'focused' => __( 'Focused', 'flatsome' ),
  ),
));


Flatsome_Option::add_field( 'option',  array(
  'type'        => 'checkbox',
  'settings'     => 'cart_sticky_sidebar',
  'label'       => __( 'Sticky sidebar', 'flatsome' ),
  'section'     => 'cart-checkout',
  'default' => 0
));

Flatsome_Option::add_field( 'option', array(
	'type'            => 'select',
	'settings'        => 'cart_sticky_sidebar_mode',
	'label'           => __( 'Sticky mode', 'flatsome' ),
	'section'         => 'cart-checkout',
	'default'         => '',
	'choices'         => array(
		''           => __( 'CSS (native)', 'flatsome' ),
		'javascript' => __( 'JavaScript (enhanced)', 'flatsome' ),
	),
	'active_callback' => array(
		array(
			'setting'  => 'cart_sticky_sidebar',
			'operator' => '==',
			'value'    => true,
		),
	),
) );

Flatsome_Option::add_field( 'option', array(
	'type'     => 'checkbox',
	'settings' => 'cart_auto_refresh',
	'label'    => __( 'Auto update on quantity change', 'flatsome' ),
	'section'  => 'cart-checkout',
	'default'  => 0,
) );


Flatsome_Option::add_field( 'option',  array(
  'type'        => 'checkbox',
  'settings'     => 'cart_boxed_shipping_labels',
  'label'       => __( 'Boxed Shipping labels', 'flatsome' ),
  'section'     => 'cart-checkout',
  'default' => 0
));

Flatsome_Option::add_field( 'option',  array(
  'type'        => 'checkbox',
  'settings'     => 'cart_estimate_text',
  'label'       => __( 'Show shipping estimate destination', 'flatsome' ),
  'section'     => 'cart-checkout',
  'default' => 1
));

Flatsome_Option::add_field( 'option', array(
	'type'     => 'checkbox',
	'settings' => 'cart_shipping',
	'label'    => esc_html__( 'Show free shipping', 'flatsome' ),
	'section'  => 'cart-checkout',
	'default'  => 0,
) );

Flatsome_Option::add_field( '', array(
	'type'     => 'custom',
	'settings' => 'cart_steps_title',
	'label'    => '',
	'section'  => 'cart-checkout',
	'default'  => '<div class="options-title-divider">Steps</div>',
) );

Flatsome_Option::add_field( 'option', array(
	'type'     => 'radio-buttonset',
	'settings' => 'cart_steps_size',
	'label'    => __( 'Steps size', 'flatsome' ),
	'section'  => 'cart-checkout',
	'default'  => 'h2',
	'choices'  => array(
		'h2' => __( 'Default', 'flatsome' ),
		'h3' => __( 'Small', 'flatsome' ),
		'h4' => __( 'Smaller', 'flatsome' ),
	),
) );

Flatsome_Option::add_field( 'option', array(
	'type'     => 'radio-buttonset',
	'settings' => 'cart_steps_case',
	'label'    => esc_attr__( 'Steps letter case', 'flatsome' ),
	'section'  => 'cart-checkout',
	'default'  => 'uppercase',
	'choices'  => array(
		'uppercase' => 'UPPERCASE',
		'none'      => 'Normal',
	),
) );

Flatsome_Option::add_field( 'option', array(
	'type'     => 'checkbox',
	'settings' => 'cart_steps_numbers',
	'label'    => __( 'Step numbers', 'flatsome' ),
	'section'  => 'cart-checkout',
	'default'  => 0,
) );

Flatsome_Option::add_field( '', array(
	'type'     => 'custom',
	'settings' => 'html_cart_title',
	'label'    => '',
	'section'  => 'cart-checkout',
	'default'  => '<div class="options-title-divider">Custom Content</div>',
) );

Flatsome_Option::add_field( 'option',  array(
	'type'        => 'textarea',
	'settings'     => 'html_cart_sidebar',
	'transport' => $transport,
	'label'       => __( 'Cart Sidebar content', 'flatsome' ),
	'help'        => __( 'Enter HTML that will show on bottom of cart sidebar' ),
	'section'     => 'cart-checkout',
	'default'     => '',
));

Flatsome_Option::add_field( 'option',  array(
	'type'        => 'textarea',
	'settings'     => 'html_cart_footer',
	'transport' => $transport,
	'label'       => __( 'After Cart content', 'flatsome' ),
	'help'        => __( 'Enter HTML or Shortcodes that will show after cart here.' ),
	'section'     => 'cart-checkout',
	'default'     => '',
));


// CHECKOUT

Flatsome_Option::add_field( 'option', array(
  'type'        => 'radio-buttonset',
  'settings'     => 'checkout_layout',
  'priority' => 1,
  'label'       => __( 'Checkout layout', 'flatsome' ),
  'section'     => 'woocommerce_checkout',
  'default'     => '',
  'choices'     => array(
    '' => __( 'Default', 'flatsome' ),
    'simple' => __( 'Simple', 'flatsome' ),
    'focused' => __( 'Focused', 'flatsome' ),
  ),
));


if ( is_nextend_facebook_login() || is_nextend_google_login() ) {
	Flatsome_Option::add_field( 'option',  array(
		'type'        => 'checkbox',
		'settings'     => 'facebook_login_checkout',
		'label'       => __( 'Social Login Buttons', 'flatsome' ),
		'section'     => 'woocommerce_checkout',
		'default' => 0
	));
}

Flatsome_Option::add_field( 'option', array(
	'type'     => 'radio-buttonset',
	'settings' => 'checkout_terms_and_conditions',
	'label'    => __( 'Terms and conditions link style', 'flatsome' ),
	'section'  => 'woocommerce_checkout',
	'default'  => '',
	'choices'  => array(
		''         => __( 'Default', 'flatsome' ),
		'tab'      => __( 'New Tab', 'flatsome' ),
		'lightbox' => __( 'Lightbox', 'flatsome' ),
	),
) );

Flatsome_Option::add_field( 'option', array(
	'type'            => 'checkbox',
	'settings'        => 'terms_and_conditions_lightbox_buttons',
	'transport'       => $transport,
	'label'           => __( 'Terms and conditions "Agree" button', 'flatsome' ),
	'section'         => 'woocommerce_checkout',
	'default'         => 1,
	'active_callback' => array(
		array(
			'setting'  => 'checkout_terms_and_conditions',
			'operator' => '==',
			'value'    => 'lightbox',
		),
	),
) );

Flatsome_Option::add_field( 'option',  array(
  'type'        => 'checkbox',
  'settings'     => 'checkout_floating_labels',
  'label'       => __( 'Floating field labels', 'flatsome' ),
  'section'     => 'woocommerce_checkout',
  'default' => 0
));

Flatsome_Option::add_field( 'option',  array(
  'type'        => 'checkbox',
  'settings'     => 'checkout_fields_email_first',
  'label'       => __( 'Move E-mail field to first position', 'flatsome' ),
  'section'     => 'woocommerce_checkout',
  'default' => 0
));

Flatsome_Option::add_field( 'option',  array(
  'type'        => 'checkbox',
  'settings'     => 'checkout_sticky_sidebar',
  'label'       => __( 'Sticky sidebar', 'flatsome' ),
  'section'     => 'woocommerce_checkout',
  'default' => 0
));

Flatsome_Option::add_field( 'option', array(
	'type'            => 'select',
	'settings'        => 'checkout_sticky_sidebar_mode',
	'label'           => __( 'Sticky mode', 'flatsome' ),
	'section'         => 'woocommerce_checkout',
	'default'         => '',
	'choices'         => array(
		''           => __( 'CSS (native)', 'flatsome' ),
		'javascript' => __( 'JavaScript (enhanced)', 'flatsome' ),
	),
	'active_callback' => array(
		array(
			'setting'  => 'checkout_sticky_sidebar',
			'operator' => '==',
			'value'    => true,
		),
	),
) );

Flatsome_Option::add_field( 'option', array(
	'type'     => 'checkbox',
	'settings' => 'checkout_shipping',
	'label'    => esc_html__( 'Show free shipping', 'flatsome' ),
	'section'  => 'woocommerce_checkout',
	'default'  => 0,
) );

Flatsome_Option::add_field( 'option',  array(
	'type'        => 'textarea',
	'settings'     => 'html_checkout_sidebar',
	'transport' => $transport,
	'label'       => __( 'Checkout Sidebar content', 'flatsome' ),
	'help'        => __( 'Enter HTML that will show on bottom of checkout sidebar' ),
	'section'     => 'woocommerce_checkout',
	'default'     => '',
));
