<?php
/**
 * Adds Pages Panel and options to the Customizer for Flatsome.
 *
 * @package Flatsome
 */

Flatsome_Option::add_section( 'pages', array(
	'title'       => __( 'Pages', 'flatsome' ),
	'description' => __( 'Change the default page layout for all pages. You can also override some of these options per page in the page editor.', 'flatsome' ),
) );

Flatsome_Option::add_field( 'option', array(
	'type'     => 'select',
	'settings' => 'pages_template',
	'label'    => __( 'Default - Page Template', 'flatsome' ),
	'section'  => 'pages',
	'default'  => 'default',
	'choices'  => array(
		'default'                           => __( 'Container (Default)', 'flatsome' ),
		'blank-title-center'                => __( 'Container - Center Title', 'flatsome' ),
		'blank'                             => __( 'Full-Width', 'flatsome' ),
		'header-on-scroll'                  => __( 'Full-Width - Header On Scroll', 'flatsome' ),
		'blank-featured'                    => __( 'Full-Width - Parallax Title', 'flatsome' ),
		'transparent-header'                => __( 'Full-Width - Transparent Header', 'flatsome' ),
		'transparent-header-light'          => __( 'Full-Width - Transparent Header Light', 'flatsome' ),
		'left-sidebar'                      => __( 'Sidebar Left', 'flatsome' ),
		'blank-landingpage'                 => __( 'No Header / No Footer', 'flatsome' ),
		'right-sidebar'                     => __( 'Sidebar Right', 'flatsome' ),
		'single-page-nav'                   => __( 'Single Page Navigation', 'flatsome' ),
		'single-page-nav-transparent'       => __( 'Single Page Navigation - Transparent Header', 'flatsome' ),
		'single-page-nav-transparent-light' => __( 'Single Page Navigation - Transparent Header - Light', 'flatsome' ),
		'blank-sub-nav-vertical'            => __( 'Vertical Sub Navigation', 'flatsome' ),
	),
));

Flatsome_Option::add_field( 'option', array(
	'type'     => 'checkbox',
	'settings' => 'default_title',
	'label'    => __( 'Show H1 Page title on the container (default), left sidebar and right sidebar templates.', 'flatsome' ),
	'section'  => 'pages',
	'default'  => 0,
));

Flatsome_Option::add_field( 'option', array(
	'type'     => 'checkbox',
	'settings' => 'page_top_excerpt',
	'label'    => __( 'Add excerpt content to top of pages.', 'flatsome' ),
	'section'  => 'pages',
	'default'  => 1,
));
