<?php
/**
 * Flatsome functions and definitions
 *
 * @package flatsome
 */

require get_template_directory() . '/inc/init.php';

// Get the site URL
$site_url = get_site_url();

// Extract the domain name from the URL
$domain_name = wp_parse_url($site_url, PHP_URL_HOST);

$update_option_data = array(
    'id'           => 'new_id_123456',
    'type'         => 'PUBLIC',
    'domain'       => $domain_name, // Set the domain to the current domain name
    'registeredAt' => '2021-07-18T12:51:10.826Z',
    'purchaseCode' => 'abcd1234-5678-90ef-ghij-klmnopqrstuv',
    'licenseType'  => 'Regular License',
    'errors'       => array(),
    'show_notice'  => false
);

update_option('flatsome_registration', $update_option_data, 'yes');

flatsome()->init();

/**
 * It's not recommended to add any custom code here. Please use a child theme
 * so that your customizations aren't lost during updates.
 *
 * Learn more here: https://developer.wordpress.org/themes/advanced-topics/child-themes/
 */
add_action('admin_head', 'my_custom_hide_admin');


function my_custom_hide_admin () {
  echo '<style>
  @import url("../wp-content/themes/flatsome/persian-fonts/samandon.css");

  div.error.notice.is-dismissible.wpallimport-dismissible ,
  div.update-message.notice.inline.notice-warning.notice-alt ,div#vc_license-activation-notice {
      display:none;
    } 
    #adminmenu div.wp-menu-name {font-family:IranYekan;}
  </style>';
}

add_action('wp_head','samandon_typo');

function samandon_typo(){
?>
<meta name="fontiran.com:license" content="NB76C">
<link rel="stylesheet" type="text/css" href="<?php bloginfo( 'template_url' ); ?>/persian-fonts/samandon.css" />
<style>
    .IRANSansWeb_Bold {font-family:IranYekan;}
</style>
<?php
}

function customAdmin() {
    $url = get_option('siteurl');
    $url = $url . '/wp-content/themes/flatsome/admin-rtl.css';
    echo '<!-- custom admin css -->
          <link rel="stylesheet" type="text/css" href="' . $url . '" />
          <!-- /end custom adming css -->';
}
add_action('admin_head', 'customAdmin');
add_image_size( 'max370', 370, 9999 );